package io.fabric8.openclustermanagement.api.model.multiclusterhub.operator.v1;

import java.lang.SuppressWarnings;
import io.fabric8.kubernetes.api.builder.Nested;
import java.lang.String;
import java.lang.Integer;
import io.fabric8.kubernetes.api.builder.BaseFluent;
import java.lang.Object;
import java.lang.Boolean;

/**
 * Generated
 */
@SuppressWarnings("unchecked")
public class BackupConfigFluent<A extends BackupConfigFluent<A>> extends BaseFluent<A>{
  public BackupConfigFluent() {
  }
  
  public BackupConfigFluent(BackupConfig instance) {
    this.copyInstance(instance);
  }
  private Integer minBackupPeriodSeconds;
  private VeleroBackupConfigBuilder velero;
  
  protected void copyInstance(BackupConfig instance) {
    instance = (instance != null ? instance : new BackupConfig());
    if (instance != null) {
          this.withMinBackupPeriodSeconds(instance.getMinBackupPeriodSeconds());
          this.withVelero(instance.getVelero());
          this.withMinBackupPeriodSeconds(instance.getMinBackupPeriodSeconds());
          this.withVelero(instance.getVelero());
        }
  }
  
  public Integer getMinBackupPeriodSeconds() {
    return this.minBackupPeriodSeconds;
  }
  
  public A withMinBackupPeriodSeconds(Integer minBackupPeriodSeconds) {
    this.minBackupPeriodSeconds = minBackupPeriodSeconds;
    return (A) this;
  }
  
  public boolean hasMinBackupPeriodSeconds() {
    return this.minBackupPeriodSeconds != null;
  }
  
  public VeleroBackupConfig buildVelero() {
    return this.velero != null ? this.velero.build() : null;
  }
  
  public A withVelero(VeleroBackupConfig velero) {
    this._visitables.remove(this.velero);
    if (velero != null) {
        this.velero = new VeleroBackupConfigBuilder(velero);
        this._visitables.get("velero").add(this.velero);
    } else {
        this.velero = null;
        this._visitables.get("velero").remove(this.velero);
    }
    return (A) this;
  }
  
  public boolean hasVelero() {
    return this.velero != null;
  }
  
  public A withNewVelero(Boolean enabled) {
    return (A)withVelero(new VeleroBackupConfig(enabled));
  }
  
  public VeleroNested<A> withNewVelero() {
    return new VeleroNested(null);
  }
  
  public VeleroNested<A> withNewVeleroLike(VeleroBackupConfig item) {
    return new VeleroNested(item);
  }
  
  public VeleroNested<A> editVelero() {
    return withNewVeleroLike(java.util.Optional.ofNullable(buildVelero()).orElse(null));
  }
  
  public VeleroNested<A> editOrNewVelero() {
    return withNewVeleroLike(java.util.Optional.ofNullable(buildVelero()).orElse(new VeleroBackupConfigBuilder().build()));
  }
  
  public VeleroNested<A> editOrNewVeleroLike(VeleroBackupConfig item) {
    return withNewVeleroLike(java.util.Optional.ofNullable(buildVelero()).orElse(item));
  }
  
  public boolean equals(Object o) {
    if (this == o) return true;
    if (o == null || getClass() != o.getClass()) return false;
    if (!super.equals(o)) return false;
    BackupConfigFluent that = (BackupConfigFluent) o;
    if (!java.util.Objects.equals(minBackupPeriodSeconds, that.minBackupPeriodSeconds)) return false;
    if (!java.util.Objects.equals(velero, that.velero)) return false;
    return true;
  }
  
  public int hashCode() {
    return java.util.Objects.hash(minBackupPeriodSeconds,  velero,  super.hashCode());
  }
  
  public String toString() {
    StringBuilder sb = new StringBuilder();
    sb.append("{");
    if (minBackupPeriodSeconds != null) { sb.append("minBackupPeriodSeconds:"); sb.append(minBackupPeriodSeconds + ","); }
    if (velero != null) { sb.append("velero:"); sb.append(velero); }
    sb.append("}");
    return sb.toString();
  }
  public class VeleroNested<N> extends VeleroBackupConfigFluent<VeleroNested<N>> implements Nested<N>{
    VeleroNested(VeleroBackupConfig item) {
      this.builder = new VeleroBackupConfigBuilder(this, item);
    }
    VeleroBackupConfigBuilder builder;
    
    public N and() {
      return (N) BackupConfigFluent.this.withVelero(builder.build());
    }
    
    public N endVelero() {
      return and();
    }
    
  
  }

}