package io.fabric8.openclustermanagement.api.model.multiclusterhub.operator.v1;

import io.fabric8.kubernetes.api.builder.VisitableBuilder;
public class BackupConfigBuilder extends BackupConfigFluent<BackupConfigBuilder> implements VisitableBuilder<BackupConfig,BackupConfigBuilder>{
  public BackupConfigBuilder() {
    this(new BackupConfig());
  }
  
  public BackupConfigBuilder(BackupConfigFluent<?> fluent) {
    this(fluent, new BackupConfig());
  }
  
  public BackupConfigBuilder(BackupConfigFluent<?> fluent,BackupConfig instance) {
    this.fluent = fluent;
    fluent.copyInstance(instance);
  }
  
  public BackupConfigBuilder(BackupConfig instance) {
    this.fluent = this;
    this.copyInstance(instance);
  }
  BackupConfigFluent<?> fluent;
  
  public BackupConfig build() {
    BackupConfig buildable = new BackupConfig(fluent.getMinBackupPeriodSeconds(),fluent.buildVelero());
    return buildable;
  }
  

}