/*
 * Decompiled with CFR 0.152.
 */
package io.fabric8.openclustermanagement.api.model.multiclusterhub.operator.v1;

import io.fabric8.kubernetes.api.builder.BaseFluent;
import io.fabric8.kubernetes.api.builder.Nested;
import io.fabric8.openclustermanagement.api.model.multiclusterhub.operator.v1.HubCondition;
import io.fabric8.openclustermanagement.api.model.multiclusterhub.operator.v1.HubConditionBuilder;
import io.fabric8.openclustermanagement.api.model.multiclusterhub.operator.v1.HubConditionFluent;
import io.fabric8.openclustermanagement.api.model.multiclusterhub.operator.v1.MultiClusterHubStatus;
import io.fabric8.openclustermanagement.api.model.multiclusterhub.operator.v1.StatusCondition;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.function.Predicate;

public class MultiClusterHubStatusFluent<A extends MultiClusterHubStatusFluent<A>>
extends BaseFluent<A> {
    private Map<String, StatusCondition> components;
    private ArrayList<HubConditionBuilder> conditions = new ArrayList();
    private String currentVersion;
    private String desiredVersion;
    private String phase;

    public MultiClusterHubStatusFluent() {
    }

    public MultiClusterHubStatusFluent(MultiClusterHubStatus instance) {
        MultiClusterHubStatus multiClusterHubStatus = instance = instance != null ? instance : new MultiClusterHubStatus();
        if (instance != null) {
            this.withComponents(instance.getComponents());
            this.withConditions(instance.getConditions());
            this.withCurrentVersion(instance.getCurrentVersion());
            this.withDesiredVersion(instance.getDesiredVersion());
            this.withPhase(instance.getPhase());
            this.withComponents(instance.getComponents());
            this.withConditions(instance.getConditions());
            this.withCurrentVersion(instance.getCurrentVersion());
            this.withDesiredVersion(instance.getDesiredVersion());
            this.withPhase(instance.getPhase());
        }
    }

    public A addToComponents(String key, StatusCondition value) {
        if (this.components == null && key != null && value != null) {
            this.components = new LinkedHashMap<String, StatusCondition>();
        }
        if (key != null && value != null) {
            this.components.put(key, value);
        }
        return (A)((Object)this);
    }

    public A addToComponents(Map<String, StatusCondition> map) {
        if (this.components == null && map != null) {
            this.components = new LinkedHashMap<String, StatusCondition>();
        }
        if (map != null) {
            this.components.putAll(map);
        }
        return (A)((Object)this);
    }

    public A removeFromComponents(String key) {
        if (this.components == null) {
            return (A)((Object)this);
        }
        if (key != null && this.components != null) {
            this.components.remove(key);
        }
        return (A)((Object)this);
    }

    public A removeFromComponents(Map<String, StatusCondition> map) {
        if (this.components == null) {
            return (A)((Object)this);
        }
        if (map != null) {
            for (String key : map.keySet()) {
                if (this.components == null) continue;
                this.components.remove(key);
            }
        }
        return (A)((Object)this);
    }

    public Map<String, StatusCondition> getComponents() {
        return this.components;
    }

    public <K, V> A withComponents(Map<String, StatusCondition> components) {
        this.components = components == null ? null : new LinkedHashMap<String, StatusCondition>(components);
        return (A)((Object)this);
    }

    public boolean hasComponents() {
        return this.components != null;
    }

    public A addToConditions(int index, HubCondition item) {
        if (this.conditions == null) {
            this.conditions = new ArrayList();
        }
        HubConditionBuilder builder = new HubConditionBuilder(item);
        if (index < 0 || index >= this.conditions.size()) {
            this._visitables.get((Object)"conditions").add(builder);
            this.conditions.add(builder);
        } else {
            this._visitables.get((Object)"conditions").add(index, builder);
            this.conditions.add(index, builder);
        }
        return (A)((Object)this);
    }

    public A setToConditions(int index, HubCondition item) {
        if (this.conditions == null) {
            this.conditions = new ArrayList();
        }
        HubConditionBuilder builder = new HubConditionBuilder(item);
        if (index < 0 || index >= this.conditions.size()) {
            this._visitables.get((Object)"conditions").add(builder);
            this.conditions.add(builder);
        } else {
            this._visitables.get((Object)"conditions").set(index, builder);
            this.conditions.set(index, builder);
        }
        return (A)((Object)this);
    }

    public A addToConditions(HubCondition ... items) {
        if (this.conditions == null) {
            this.conditions = new ArrayList();
        }
        for (HubCondition item : items) {
            HubConditionBuilder builder = new HubConditionBuilder(item);
            this._visitables.get((Object)"conditions").add(builder);
            this.conditions.add(builder);
        }
        return (A)((Object)this);
    }

    public A addAllToConditions(Collection<HubCondition> items) {
        if (this.conditions == null) {
            this.conditions = new ArrayList();
        }
        for (HubCondition item : items) {
            HubConditionBuilder builder = new HubConditionBuilder(item);
            this._visitables.get((Object)"conditions").add(builder);
            this.conditions.add(builder);
        }
        return (A)((Object)this);
    }

    public A removeFromConditions(HubCondition ... items) {
        if (this.conditions == null) {
            return (A)((Object)this);
        }
        for (HubCondition item : items) {
            HubConditionBuilder builder = new HubConditionBuilder(item);
            this._visitables.get((Object)"conditions").remove((Object)builder);
            this.conditions.remove((Object)builder);
        }
        return (A)((Object)this);
    }

    public A removeAllFromConditions(Collection<HubCondition> items) {
        if (this.conditions == null) {
            return (A)((Object)this);
        }
        for (HubCondition item : items) {
            HubConditionBuilder builder = new HubConditionBuilder(item);
            this._visitables.get((Object)"conditions").remove((Object)builder);
            this.conditions.remove((Object)builder);
        }
        return (A)((Object)this);
    }

    public A removeMatchingFromConditions(Predicate<HubConditionBuilder> predicate) {
        if (this.conditions == null) {
            return (A)((Object)this);
        }
        Iterator<HubConditionBuilder> each = this.conditions.iterator();
        List visitables = this._visitables.get((Object)"conditions");
        while (each.hasNext()) {
            HubConditionBuilder builder = each.next();
            if (!predicate.test(builder)) continue;
            visitables.remove((Object)builder);
            each.remove();
        }
        return (A)((Object)this);
    }

    public List<HubCondition> buildConditions() {
        return this.conditions != null ? MultiClusterHubStatusFluent.build(this.conditions) : null;
    }

    public HubCondition buildCondition(int index) {
        return this.conditions.get(index).build();
    }

    public HubCondition buildFirstCondition() {
        return this.conditions.get(0).build();
    }

    public HubCondition buildLastCondition() {
        return this.conditions.get(this.conditions.size() - 1).build();
    }

    public HubCondition buildMatchingCondition(Predicate<HubConditionBuilder> predicate) {
        for (HubConditionBuilder item : this.conditions) {
            if (!predicate.test(item)) continue;
            return item.build();
        }
        return null;
    }

    public boolean hasMatchingCondition(Predicate<HubConditionBuilder> predicate) {
        for (HubConditionBuilder item : this.conditions) {
            if (!predicate.test(item)) continue;
            return true;
        }
        return false;
    }

    public A withConditions(List<HubCondition> conditions) {
        if (this.conditions != null) {
            this._visitables.get((Object)"conditions").clear();
        }
        if (conditions != null) {
            this.conditions = new ArrayList();
            for (HubCondition item : conditions) {
                this.addToConditions(item);
            }
        } else {
            this.conditions = null;
        }
        return (A)((Object)this);
    }

    public A withConditions(HubCondition ... conditions) {
        if (this.conditions != null) {
            this.conditions.clear();
            this._visitables.remove((Object)"conditions");
        }
        if (conditions != null) {
            for (HubCondition item : conditions) {
                this.addToConditions(item);
            }
        }
        return (A)((Object)this);
    }

    public boolean hasConditions() {
        return this.conditions != null && !this.conditions.isEmpty();
    }

    public ConditionsNested<A> addNewCondition() {
        return new ConditionsNested(-1, null);
    }

    public ConditionsNested<A> addNewConditionLike(HubCondition item) {
        return new ConditionsNested(-1, item);
    }

    public ConditionsNested<A> setNewConditionLike(int index, HubCondition item) {
        return new ConditionsNested(index, item);
    }

    public ConditionsNested<A> editCondition(int index) {
        if (this.conditions.size() <= index) {
            throw new RuntimeException("Can't edit conditions. Index exceeds size.");
        }
        return this.setNewConditionLike(index, this.buildCondition(index));
    }

    public ConditionsNested<A> editFirstCondition() {
        if (this.conditions.size() == 0) {
            throw new RuntimeException("Can't edit first conditions. The list is empty.");
        }
        return this.setNewConditionLike(0, this.buildCondition(0));
    }

    public ConditionsNested<A> editLastCondition() {
        int index = this.conditions.size() - 1;
        if (index < 0) {
            throw new RuntimeException("Can't edit last conditions. The list is empty.");
        }
        return this.setNewConditionLike(index, this.buildCondition(index));
    }

    public ConditionsNested<A> editMatchingCondition(Predicate<HubConditionBuilder> predicate) {
        int index = -1;
        for (int i = 0; i < this.conditions.size(); ++i) {
            if (!predicate.test(this.conditions.get(i))) continue;
            index = i;
            break;
        }
        if (index < 0) {
            throw new RuntimeException("Can't edit matching conditions. No match found.");
        }
        return this.setNewConditionLike(index, this.buildCondition(index));
    }

    public String getCurrentVersion() {
        return this.currentVersion;
    }

    public A withCurrentVersion(String currentVersion) {
        this.currentVersion = currentVersion;
        return (A)((Object)this);
    }

    public boolean hasCurrentVersion() {
        return this.currentVersion != null;
    }

    public String getDesiredVersion() {
        return this.desiredVersion;
    }

    public A withDesiredVersion(String desiredVersion) {
        this.desiredVersion = desiredVersion;
        return (A)((Object)this);
    }

    public boolean hasDesiredVersion() {
        return this.desiredVersion != null;
    }

    public String getPhase() {
        return this.phase;
    }

    public A withPhase(String phase) {
        this.phase = phase;
        return (A)((Object)this);
    }

    public boolean hasPhase() {
        return this.phase != null;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || ((Object)((Object)this)).getClass() != o.getClass()) {
            return false;
        }
        if (!super.equals(o)) {
            return false;
        }
        MultiClusterHubStatusFluent that = (MultiClusterHubStatusFluent)((Object)o);
        if (!Objects.equals(this.components, that.components)) {
            return false;
        }
        if (!Objects.equals(this.conditions, that.conditions)) {
            return false;
        }
        if (!Objects.equals(this.currentVersion, that.currentVersion)) {
            return false;
        }
        if (!Objects.equals(this.desiredVersion, that.desiredVersion)) {
            return false;
        }
        return Objects.equals(this.phase, that.phase);
    }

    public int hashCode() {
        return Objects.hash(this.components, this.conditions, this.currentVersion, this.desiredVersion, this.phase, super.hashCode());
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("{");
        if (this.components != null && !this.components.isEmpty()) {
            sb.append("components:");
            sb.append(this.components + ",");
        }
        if (this.conditions != null && !this.conditions.isEmpty()) {
            sb.append("conditions:");
            sb.append(this.conditions + ",");
        }
        if (this.currentVersion != null) {
            sb.append("currentVersion:");
            sb.append(this.currentVersion + ",");
        }
        if (this.desiredVersion != null) {
            sb.append("desiredVersion:");
            sb.append(this.desiredVersion + ",");
        }
        if (this.phase != null) {
            sb.append("phase:");
            sb.append(this.phase);
        }
        sb.append("}");
        return sb.toString();
    }

    public class ConditionsNested<N>
    extends HubConditionFluent<ConditionsNested<N>>
    implements Nested<N> {
        HubConditionBuilder builder;
        int index;

        ConditionsNested(int index, HubCondition item) {
            this.index = index;
            this.builder = new HubConditionBuilder(this, item);
        }

        public N and() {
            return (N)MultiClusterHubStatusFluent.this.setToConditions(this.index, this.builder.build());
        }

        public N endCondition() {
            return this.and();
        }
    }
}

