package io.fabric8.openclustermanagement.api.model.operator.v1;

import io.fabric8.kubernetes.api.builder.VisitableBuilder;
import java.lang.Boolean;
public class ServerURLBuilder extends ServerURLFluent<ServerURLBuilder> implements VisitableBuilder<ServerURL,ServerURLBuilder>{
  public ServerURLBuilder() {
    this(false);
  }
  public ServerURLBuilder(Boolean validationEnabled) {
    this(new ServerURL(), validationEnabled);
  }
  public ServerURLBuilder(ServerURLFluent<?> fluent) {
    this(fluent, false);
  }
  public ServerURLBuilder(ServerURLFluent<?> fluent,Boolean validationEnabled) {
    this(fluent, new ServerURL(), validationEnabled);
  }
  public ServerURLBuilder(ServerURLFluent<?> fluent,ServerURL instance) {
    this(fluent, instance, false);
  }
  public ServerURLBuilder(ServerURLFluent<?> fluent,ServerURL instance,Boolean validationEnabled) {
    this.fluent = fluent; 
    instance = (instance != null ? instance : new ServerURL());

    if (instance != null) {
      fluent.withCaBundle(instance.getCaBundle());
      fluent.withUrl(instance.getUrl());
      fluent.withCaBundle(instance.getCaBundle());
      fluent.withUrl(instance.getUrl());
    }
    this.validationEnabled = validationEnabled; 
  }
  public ServerURLBuilder(ServerURL instance) {
    this(instance,false);
  }
  public ServerURLBuilder(ServerURL instance,Boolean validationEnabled) {
    this.fluent = this; 
    instance = (instance != null ? instance : new ServerURL());

    if (instance != null) {
      this.withCaBundle(instance.getCaBundle());
      this.withUrl(instance.getUrl());
      this.withCaBundle(instance.getCaBundle());
      this.withUrl(instance.getUrl());
    }
    this.validationEnabled = validationEnabled; 
  }
  ServerURLFluent<?> fluent;
  Boolean validationEnabled;
  public ServerURL build() {
    ServerURL buildable = new ServerURL(fluent.getCaBundle(),fluent.getUrl());
    return buildable;
  }
  
}