package io.fabric8.openclustermanagement.api.model.operator.v1;

import io.fabric8.kubernetes.api.builder.VisitableBuilder;
import java.lang.Boolean;
public class RelatedResourceMetaBuilder extends RelatedResourceMetaFluent<RelatedResourceMetaBuilder> implements VisitableBuilder<RelatedResourceMeta,RelatedResourceMetaBuilder>{
  public RelatedResourceMetaBuilder() {
    this(false);
  }
  public RelatedResourceMetaBuilder(Boolean validationEnabled) {
    this(new RelatedResourceMeta(), validationEnabled);
  }
  public RelatedResourceMetaBuilder(RelatedResourceMetaFluent<?> fluent) {
    this(fluent, false);
  }
  public RelatedResourceMetaBuilder(RelatedResourceMetaFluent<?> fluent,Boolean validationEnabled) {
    this(fluent, new RelatedResourceMeta(), validationEnabled);
  }
  public RelatedResourceMetaBuilder(RelatedResourceMetaFluent<?> fluent,RelatedResourceMeta instance) {
    this(fluent, instance, false);
  }
  public RelatedResourceMetaBuilder(RelatedResourceMetaFluent<?> fluent,RelatedResourceMeta instance,Boolean validationEnabled) {
    this.fluent = fluent; 
    instance = (instance != null ? instance : new RelatedResourceMeta());

    if (instance != null) {
      fluent.withGroup(instance.getGroup());
      fluent.withName(instance.getName());
      fluent.withNamespace(instance.getNamespace());
      fluent.withResource(instance.getResource());
      fluent.withVersion(instance.getVersion());
      fluent.withGroup(instance.getGroup());
      fluent.withName(instance.getName());
      fluent.withNamespace(instance.getNamespace());
      fluent.withResource(instance.getResource());
      fluent.withVersion(instance.getVersion());
    }
    this.validationEnabled = validationEnabled; 
  }
  public RelatedResourceMetaBuilder(RelatedResourceMeta instance) {
    this(instance,false);
  }
  public RelatedResourceMetaBuilder(RelatedResourceMeta instance,Boolean validationEnabled) {
    this.fluent = this; 
    instance = (instance != null ? instance : new RelatedResourceMeta());

    if (instance != null) {
      this.withGroup(instance.getGroup());
      this.withName(instance.getName());
      this.withNamespace(instance.getNamespace());
      this.withResource(instance.getResource());
      this.withVersion(instance.getVersion());
      this.withGroup(instance.getGroup());
      this.withName(instance.getName());
      this.withNamespace(instance.getNamespace());
      this.withResource(instance.getResource());
      this.withVersion(instance.getVersion());
    }
    this.validationEnabled = validationEnabled; 
  }
  RelatedResourceMetaFluent<?> fluent;
  Boolean validationEnabled;
  public RelatedResourceMeta build() {
    RelatedResourceMeta buildable = new RelatedResourceMeta(fluent.getGroup(),fluent.getName(),fluent.getNamespace(),fluent.getResource(),fluent.getVersion());
    return buildable;
  }
  
}