package io.fabric8.openclustermanagement.api.model.operator.v1;

import java.lang.SuppressWarnings;
import java.util.ArrayList;
import java.lang.String;
import java.util.LinkedHashMap;
import java.util.function.Predicate;
import io.fabric8.kubernetes.api.builder.BaseFluent;
import io.fabric8.kubernetes.api.model.Toleration;
import java.lang.Long;
import java.util.Collection;
import java.lang.Object;
import java.util.List;
import java.util.Map;

 /**
  * Generated
  */
  @SuppressWarnings(value = "unchecked")
  public class NodePlacementFluent<A extends NodePlacementFluent<A>> extends BaseFluent<A>{
  public NodePlacementFluent() {
  }
  public NodePlacementFluent(NodePlacement instance) {
    instance = (instance != null ? instance : new NodePlacement());

    if (instance != null) {
      this.withNodeSelector(instance.getNodeSelector());
      this.withTolerations(instance.getTolerations());
      this.withNodeSelector(instance.getNodeSelector());
      this.withTolerations(instance.getTolerations());
    }
  }
  private Map<String,String> nodeSelector;
  private List<Toleration> tolerations = new ArrayList<Toleration>();
  public A addToNodeSelector(String key,String value) {
    if(this.nodeSelector == null && key != null && value != null) { this.nodeSelector = new LinkedHashMap(); }
    if(key != null && value != null) {this.nodeSelector.put(key, value);} return (A)this;
  }
  public A addToNodeSelector(Map<String,String> map) {
    if(this.nodeSelector == null && map != null) { this.nodeSelector = new LinkedHashMap(); }
    if(map != null) { this.nodeSelector.putAll(map);} return (A)this;
  }
  public A removeFromNodeSelector(String key) {
    if(this.nodeSelector == null) { return (A) this; }
    if(key != null && this.nodeSelector != null) {this.nodeSelector.remove(key);} return (A)this;
  }
  public A removeFromNodeSelector(Map<String,String> map) {
    if(this.nodeSelector == null) { return (A) this; }
    if(map != null) { for(Object key : map.keySet()) {if (this.nodeSelector != null){this.nodeSelector.remove(key);}}} return (A)this;
  }
  public Map<String,String> getNodeSelector() {
    return this.nodeSelector;
  }
  public <K,V>A withNodeSelector(Map<String,String> nodeSelector) {
    if (nodeSelector == null) { this.nodeSelector =  null;} else {this.nodeSelector = new LinkedHashMap(nodeSelector);} return (A) this;
  }
  public boolean hasNodeSelector() {
    return this.nodeSelector != null;
  }
  public A addToTolerations(int index,Toleration item) {
    if (this.tolerations == null) {this.tolerations = new ArrayList<Toleration>();}
    this.tolerations.add(index, item);
    return (A)this;
  }
  public A setToTolerations(int index,Toleration item) {
    if (this.tolerations == null) {this.tolerations = new ArrayList<Toleration>();}
    this.tolerations.set(index, item); return (A)this;
  }
  public A addToTolerations(io.fabric8.kubernetes.api.model.Toleration... items) {
    if (this.tolerations == null) {this.tolerations = new ArrayList<Toleration>();}
    for (Toleration item : items) {this.tolerations.add(item);} return (A)this;
  }
  public A addAllToTolerations(Collection<Toleration> items) {
    if (this.tolerations == null) {this.tolerations = new ArrayList<Toleration>();}
    for (Toleration item : items) {this.tolerations.add(item);} return (A)this;
  }
  public A removeFromTolerations(io.fabric8.kubernetes.api.model.Toleration... items) {
    if (this.tolerations == null) return (A)this;
    for (Toleration item : items) { this.tolerations.remove(item);} return (A)this;
  }
  public A removeAllFromTolerations(Collection<Toleration> items) {
    if (this.tolerations == null) return (A)this;
    for (Toleration item : items) { this.tolerations.remove(item);} return (A)this;
  }
  public List<Toleration> getTolerations() {
    return this.tolerations;
  }
  public Toleration getToleration(int index) {
    return this.tolerations.get(index);
  }
  public Toleration getFirstToleration() {
    return this.tolerations.get(0);
  }
  public Toleration getLastToleration() {
    return this.tolerations.get(tolerations.size() - 1);
  }
  public Toleration getMatchingToleration(Predicate<Toleration> predicate) {
    for (Toleration item: tolerations) { if(predicate.test(item)){ return item;} } return null;
  }
  public boolean hasMatchingToleration(Predicate<Toleration> predicate) {
    for (Toleration item: tolerations) { if(predicate.test(item)){ return true;} } return false;
  }
  public A withTolerations(List<Toleration> tolerations) {
    if (tolerations != null) {this.tolerations = new ArrayList(); for (Toleration item : tolerations){this.addToTolerations(item);}} else { this.tolerations = null;} return (A) this;
  }
  public A withTolerations(io.fabric8.kubernetes.api.model.Toleration... tolerations) {
    if (this.tolerations != null) {this.tolerations.clear(); _visitables.remove("tolerations"); }
    if (tolerations != null) {for (Toleration item :tolerations){ this.addToTolerations(item);}} return (A) this;
  }
  public boolean hasTolerations() {
    return tolerations != null && !tolerations.isEmpty();
  }
  public A addNewToleration(String effect,String key,String operator,Long tolerationSeconds,String value) {
    return (A)addToTolerations(new Toleration(effect, key, operator, tolerationSeconds, value));
  }
  public boolean equals(Object o) {
    if (this == o) return true;
    if (o == null || getClass() != o.getClass()) return false;
    if (!super.equals(o)) return false;
    NodePlacementFluent that = (NodePlacementFluent) o;
    if (!java.util.Objects.equals(nodeSelector, that.nodeSelector)) return false;

    if (!java.util.Objects.equals(tolerations, that.tolerations)) return false;

    return true;
  }
  public int hashCode() {
    return java.util.Objects.hash(nodeSelector,  tolerations,  super.hashCode());
  }
  public String toString() {
    StringBuilder sb = new StringBuilder();
    sb.append("{");
    if (nodeSelector != null && !nodeSelector.isEmpty()) { sb.append("nodeSelector:"); sb.append(nodeSelector + ","); }
    if (tolerations != null && !tolerations.isEmpty()) { sb.append("tolerations:"); sb.append(tolerations); }
    sb.append("}");
    return sb.toString();
  }
  
}