package io.fabric8.openclustermanagement.api.model.operator.v1;

import io.fabric8.kubernetes.api.builder.VisitableBuilder;
import java.lang.Boolean;
public class NodePlacementBuilder extends NodePlacementFluent<NodePlacementBuilder> implements VisitableBuilder<NodePlacement,NodePlacementBuilder>{
  public NodePlacementBuilder() {
    this(false);
  }
  public NodePlacementBuilder(Boolean validationEnabled) {
    this(new NodePlacement(), validationEnabled);
  }
  public NodePlacementBuilder(NodePlacementFluent<?> fluent) {
    this(fluent, false);
  }
  public NodePlacementBuilder(NodePlacementFluent<?> fluent,Boolean validationEnabled) {
    this(fluent, new NodePlacement(), validationEnabled);
  }
  public NodePlacementBuilder(NodePlacementFluent<?> fluent,NodePlacement instance) {
    this(fluent, instance, false);
  }
  public NodePlacementBuilder(NodePlacementFluent<?> fluent,NodePlacement instance,Boolean validationEnabled) {
    this.fluent = fluent; 
    instance = (instance != null ? instance : new NodePlacement());

    if (instance != null) {
      fluent.withNodeSelector(instance.getNodeSelector());
      fluent.withTolerations(instance.getTolerations());
      fluent.withNodeSelector(instance.getNodeSelector());
      fluent.withTolerations(instance.getTolerations());
    }
    this.validationEnabled = validationEnabled; 
  }
  public NodePlacementBuilder(NodePlacement instance) {
    this(instance,false);
  }
  public NodePlacementBuilder(NodePlacement instance,Boolean validationEnabled) {
    this.fluent = this; 
    instance = (instance != null ? instance : new NodePlacement());

    if (instance != null) {
      this.withNodeSelector(instance.getNodeSelector());
      this.withTolerations(instance.getTolerations());
      this.withNodeSelector(instance.getNodeSelector());
      this.withTolerations(instance.getTolerations());
    }
    this.validationEnabled = validationEnabled; 
  }
  NodePlacementFluent<?> fluent;
  Boolean validationEnabled;
  public NodePlacement build() {
    NodePlacement buildable = new NodePlacement(fluent.getNodeSelector(),fluent.getTolerations());
    return buildable;
  }
  
}