package io.fabric8.openclustermanagement.api.model.operator.v1;

import io.fabric8.kubernetes.api.builder.VisitableBuilder;
import java.lang.Boolean;
public class KlusterletStatusBuilder extends KlusterletStatusFluent<KlusterletStatusBuilder> implements VisitableBuilder<KlusterletStatus,KlusterletStatusBuilder>{
  public KlusterletStatusBuilder() {
    this(false);
  }
  public KlusterletStatusBuilder(Boolean validationEnabled) {
    this(new KlusterletStatus(), validationEnabled);
  }
  public KlusterletStatusBuilder(KlusterletStatusFluent<?> fluent) {
    this(fluent, false);
  }
  public KlusterletStatusBuilder(KlusterletStatusFluent<?> fluent,Boolean validationEnabled) {
    this(fluent, new KlusterletStatus(), validationEnabled);
  }
  public KlusterletStatusBuilder(KlusterletStatusFluent<?> fluent,KlusterletStatus instance) {
    this(fluent, instance, false);
  }
  public KlusterletStatusBuilder(KlusterletStatusFluent<?> fluent,KlusterletStatus instance,Boolean validationEnabled) {
    this.fluent = fluent; 
    instance = (instance != null ? instance : new KlusterletStatus());

    if (instance != null) {
      fluent.withConditions(instance.getConditions());
      fluent.withGenerations(instance.getGenerations());
      fluent.withObservedGeneration(instance.getObservedGeneration());
      fluent.withRelatedResources(instance.getRelatedResources());
      fluent.withConditions(instance.getConditions());
      fluent.withGenerations(instance.getGenerations());
      fluent.withObservedGeneration(instance.getObservedGeneration());
      fluent.withRelatedResources(instance.getRelatedResources());
    }
    this.validationEnabled = validationEnabled; 
  }
  public KlusterletStatusBuilder(KlusterletStatus instance) {
    this(instance,false);
  }
  public KlusterletStatusBuilder(KlusterletStatus instance,Boolean validationEnabled) {
    this.fluent = this; 
    instance = (instance != null ? instance : new KlusterletStatus());

    if (instance != null) {
      this.withConditions(instance.getConditions());
      this.withGenerations(instance.getGenerations());
      this.withObservedGeneration(instance.getObservedGeneration());
      this.withRelatedResources(instance.getRelatedResources());
      this.withConditions(instance.getConditions());
      this.withGenerations(instance.getGenerations());
      this.withObservedGeneration(instance.getObservedGeneration());
      this.withRelatedResources(instance.getRelatedResources());
    }
    this.validationEnabled = validationEnabled; 
  }
  KlusterletStatusFluent<?> fluent;
  Boolean validationEnabled;
  public KlusterletStatus build() {
    KlusterletStatus buildable = new KlusterletStatus(fluent.getConditions(),fluent.buildGenerations(),fluent.getObservedGeneration(),fluent.buildRelatedResources());
    return buildable;
  }
  
}