package io.fabric8.openclustermanagement.api.model.operator.v1;

import io.fabric8.kubernetes.api.builder.VisitableBuilder;
import java.lang.Boolean;
public class KlusterletSpecBuilder extends KlusterletSpecFluent<KlusterletSpecBuilder> implements VisitableBuilder<KlusterletSpec,KlusterletSpecBuilder>{
  public KlusterletSpecBuilder() {
    this(false);
  }
  public KlusterletSpecBuilder(Boolean validationEnabled) {
    this(new KlusterletSpec(), validationEnabled);
  }
  public KlusterletSpecBuilder(KlusterletSpecFluent<?> fluent) {
    this(fluent, false);
  }
  public KlusterletSpecBuilder(KlusterletSpecFluent<?> fluent,Boolean validationEnabled) {
    this(fluent, new KlusterletSpec(), validationEnabled);
  }
  public KlusterletSpecBuilder(KlusterletSpecFluent<?> fluent,KlusterletSpec instance) {
    this(fluent, instance, false);
  }
  public KlusterletSpecBuilder(KlusterletSpecFluent<?> fluent,KlusterletSpec instance,Boolean validationEnabled) {
    this.fluent = fluent; 
    instance = (instance != null ? instance : new KlusterletSpec());

    if (instance != null) {
      fluent.withClusterName(instance.getClusterName());
      fluent.withExternalServerURLs(instance.getExternalServerURLs());
      fluent.withNamespace(instance.getNamespace());
      fluent.withNodePlacement(instance.getNodePlacement());
      fluent.withRegistrationImagePullSpec(instance.getRegistrationImagePullSpec());
      fluent.withWorkImagePullSpec(instance.getWorkImagePullSpec());
      fluent.withClusterName(instance.getClusterName());
      fluent.withExternalServerURLs(instance.getExternalServerURLs());
      fluent.withNamespace(instance.getNamespace());
      fluent.withNodePlacement(instance.getNodePlacement());
      fluent.withRegistrationImagePullSpec(instance.getRegistrationImagePullSpec());
      fluent.withWorkImagePullSpec(instance.getWorkImagePullSpec());
    }
    this.validationEnabled = validationEnabled; 
  }
  public KlusterletSpecBuilder(KlusterletSpec instance) {
    this(instance,false);
  }
  public KlusterletSpecBuilder(KlusterletSpec instance,Boolean validationEnabled) {
    this.fluent = this; 
    instance = (instance != null ? instance : new KlusterletSpec());

    if (instance != null) {
      this.withClusterName(instance.getClusterName());
      this.withExternalServerURLs(instance.getExternalServerURLs());
      this.withNamespace(instance.getNamespace());
      this.withNodePlacement(instance.getNodePlacement());
      this.withRegistrationImagePullSpec(instance.getRegistrationImagePullSpec());
      this.withWorkImagePullSpec(instance.getWorkImagePullSpec());
      this.withClusterName(instance.getClusterName());
      this.withExternalServerURLs(instance.getExternalServerURLs());
      this.withNamespace(instance.getNamespace());
      this.withNodePlacement(instance.getNodePlacement());
      this.withRegistrationImagePullSpec(instance.getRegistrationImagePullSpec());
      this.withWorkImagePullSpec(instance.getWorkImagePullSpec());
    }
    this.validationEnabled = validationEnabled; 
  }
  KlusterletSpecFluent<?> fluent;
  Boolean validationEnabled;
  public KlusterletSpec build() {
    KlusterletSpec buildable = new KlusterletSpec(fluent.getClusterName(),fluent.buildExternalServerURLs(),fluent.getNamespace(),fluent.buildNodePlacement(),fluent.getRegistrationImagePullSpec(),fluent.getWorkImagePullSpec());
    return buildable;
  }
  
}