package io.fabric8.openclustermanagement.api.model.operator.v1;

import io.fabric8.kubernetes.api.builder.VisitableBuilder;
import java.lang.Boolean;
public class KlusterletListBuilder extends KlusterletListFluent<KlusterletListBuilder> implements VisitableBuilder<KlusterletList,KlusterletListBuilder>{
  public KlusterletListBuilder() {
    this(false);
  }
  public KlusterletListBuilder(Boolean validationEnabled) {
    this(new KlusterletList(), validationEnabled);
  }
  public KlusterletListBuilder(KlusterletListFluent<?> fluent) {
    this(fluent, false);
  }
  public KlusterletListBuilder(KlusterletListFluent<?> fluent,Boolean validationEnabled) {
    this(fluent, new KlusterletList(), validationEnabled);
  }
  public KlusterletListBuilder(KlusterletListFluent<?> fluent,KlusterletList instance) {
    this(fluent, instance, false);
  }
  public KlusterletListBuilder(KlusterletListFluent<?> fluent,KlusterletList instance,Boolean validationEnabled) {
    this.fluent = fluent; 
    instance = (instance != null ? instance : new KlusterletList());

    if (instance != null) {
      fluent.withApiVersion(instance.getApiVersion());
      fluent.withItems(instance.getItems());
      fluent.withKind(instance.getKind());
      fluent.withMetadata(instance.getMetadata());
      fluent.withApiVersion(instance.getApiVersion());
      fluent.withItems(instance.getItems());
      fluent.withKind(instance.getKind());
      fluent.withMetadata(instance.getMetadata());
    }
    this.validationEnabled = validationEnabled; 
  }
  public KlusterletListBuilder(KlusterletList instance) {
    this(instance,false);
  }
  public KlusterletListBuilder(KlusterletList instance,Boolean validationEnabled) {
    this.fluent = this; 
    instance = (instance != null ? instance : new KlusterletList());

    if (instance != null) {
      this.withApiVersion(instance.getApiVersion());
      this.withItems(instance.getItems());
      this.withKind(instance.getKind());
      this.withMetadata(instance.getMetadata());
      this.withApiVersion(instance.getApiVersion());
      this.withItems(instance.getItems());
      this.withKind(instance.getKind());
      this.withMetadata(instance.getMetadata());
    }
    this.validationEnabled = validationEnabled; 
  }
  KlusterletListFluent<?> fluent;
  Boolean validationEnabled;
  public KlusterletList build() {
    KlusterletList buildable = new KlusterletList(fluent.getApiVersion(),fluent.buildItems(),fluent.getKind(),fluent.getMetadata());
    return buildable;
  }
  
}