package io.fabric8.openclustermanagement.api.model.operator.v1;

import io.fabric8.kubernetes.api.builder.VisitableBuilder;
import java.lang.SuppressWarnings;
import io.fabric8.kubernetes.api.builder.Nested;
import java.util.ArrayList;
import java.lang.String;
import java.util.function.Predicate;
import io.fabric8.kubernetes.api.builder.BaseFluent;
import java.util.Iterator;
import java.util.List;
import io.fabric8.kubernetes.api.model.Condition;
import java.lang.Long;
import java.util.Collection;
import java.lang.Object;

 /**
  * Generated
  */
  @SuppressWarnings(value = "unchecked")
  public class ClusterManagerStatusFluent<A extends ClusterManagerStatusFluent<A>> extends BaseFluent<A>{
  public ClusterManagerStatusFluent() {
  }
  public ClusterManagerStatusFluent(ClusterManagerStatus instance) {
    instance = (instance != null ? instance : new ClusterManagerStatus());

    if (instance != null) {
      this.withConditions(instance.getConditions());
      this.withGenerations(instance.getGenerations());
      this.withObservedGeneration(instance.getObservedGeneration());
      this.withRelatedResources(instance.getRelatedResources());
      this.withConditions(instance.getConditions());
      this.withGenerations(instance.getGenerations());
      this.withObservedGeneration(instance.getObservedGeneration());
      this.withRelatedResources(instance.getRelatedResources());
    }
  }
  private List<Condition> conditions = new ArrayList<Condition>();
  private ArrayList<GenerationStatusBuilder> generations = new ArrayList<GenerationStatusBuilder>();
  private Long observedGeneration;
  private ArrayList<RelatedResourceMetaBuilder> relatedResources = new ArrayList<RelatedResourceMetaBuilder>();
  public A addToConditions(int index,Condition item) {
    if (this.conditions == null) {this.conditions = new ArrayList<Condition>();}
    this.conditions.add(index, item);
    return (A)this;
  }
  public A setToConditions(int index,Condition item) {
    if (this.conditions == null) {this.conditions = new ArrayList<Condition>();}
    this.conditions.set(index, item); return (A)this;
  }
  public A addToConditions(io.fabric8.kubernetes.api.model.Condition... items) {
    if (this.conditions == null) {this.conditions = new ArrayList<Condition>();}
    for (Condition item : items) {this.conditions.add(item);} return (A)this;
  }
  public A addAllToConditions(Collection<Condition> items) {
    if (this.conditions == null) {this.conditions = new ArrayList<Condition>();}
    for (Condition item : items) {this.conditions.add(item);} return (A)this;
  }
  public A removeFromConditions(io.fabric8.kubernetes.api.model.Condition... items) {
    if (this.conditions == null) return (A)this;
    for (Condition item : items) { this.conditions.remove(item);} return (A)this;
  }
  public A removeAllFromConditions(Collection<Condition> items) {
    if (this.conditions == null) return (A)this;
    for (Condition item : items) { this.conditions.remove(item);} return (A)this;
  }
  public List<Condition> getConditions() {
    return this.conditions;
  }
  public Condition getCondition(int index) {
    return this.conditions.get(index);
  }
  public Condition getFirstCondition() {
    return this.conditions.get(0);
  }
  public Condition getLastCondition() {
    return this.conditions.get(conditions.size() - 1);
  }
  public Condition getMatchingCondition(Predicate<Condition> predicate) {
    for (Condition item: conditions) { if(predicate.test(item)){ return item;} } return null;
  }
  public boolean hasMatchingCondition(Predicate<Condition> predicate) {
    for (Condition item: conditions) { if(predicate.test(item)){ return true;} } return false;
  }
  public A withConditions(List<Condition> conditions) {
    if (conditions != null) {this.conditions = new ArrayList(); for (Condition item : conditions){this.addToConditions(item);}} else { this.conditions = null;} return (A) this;
  }
  public A withConditions(io.fabric8.kubernetes.api.model.Condition... conditions) {
    if (this.conditions != null) {this.conditions.clear(); _visitables.remove("conditions"); }
    if (conditions != null) {for (Condition item :conditions){ this.addToConditions(item);}} return (A) this;
  }
  public boolean hasConditions() {
    return conditions != null && !conditions.isEmpty();
  }
  public A addToGenerations(int index,GenerationStatus item) {
    if (this.generations == null) {this.generations = new ArrayList<GenerationStatusBuilder>();}
    GenerationStatusBuilder builder = new GenerationStatusBuilder(item);
    if (index < 0 || index >= generations.size()) { _visitables.get("generations").add(builder); generations.add(builder); } else { _visitables.get("generations").add(index, builder); generations.add(index, builder);}
    return (A)this;
  }
  public A setToGenerations(int index,GenerationStatus item) {
    if (this.generations == null) {this.generations = new ArrayList<GenerationStatusBuilder>();}
    GenerationStatusBuilder builder = new GenerationStatusBuilder(item);
    if (index < 0 || index >= generations.size()) { _visitables.get("generations").add(builder); generations.add(builder); } else { _visitables.get("generations").set(index, builder); generations.set(index, builder);}
    return (A)this;
  }
  public A addToGenerations(io.fabric8.openclustermanagement.api.model.operator.v1.GenerationStatus... items) {
    if (this.generations == null) {this.generations = new ArrayList<GenerationStatusBuilder>();}
    for (GenerationStatus item : items) {GenerationStatusBuilder builder = new GenerationStatusBuilder(item);_visitables.get("generations").add(builder);this.generations.add(builder);} return (A)this;
  }
  public A addAllToGenerations(Collection<GenerationStatus> items) {
    if (this.generations == null) {this.generations = new ArrayList<GenerationStatusBuilder>();}
    for (GenerationStatus item : items) {GenerationStatusBuilder builder = new GenerationStatusBuilder(item);_visitables.get("generations").add(builder);this.generations.add(builder);} return (A)this;
  }
  public A removeFromGenerations(io.fabric8.openclustermanagement.api.model.operator.v1.GenerationStatus... items) {
    if (this.generations == null) return (A)this;
    for (GenerationStatus item : items) {GenerationStatusBuilder builder = new GenerationStatusBuilder(item);_visitables.get("generations").remove(builder); this.generations.remove(builder);} return (A)this;
  }
  public A removeAllFromGenerations(Collection<GenerationStatus> items) {
    if (this.generations == null) return (A)this;
    for (GenerationStatus item : items) {GenerationStatusBuilder builder = new GenerationStatusBuilder(item);_visitables.get("generations").remove(builder); this.generations.remove(builder);} return (A)this;
  }
  public A removeMatchingFromGenerations(Predicate<GenerationStatusBuilder> predicate) {
    if (generations == null) return (A) this;
    final Iterator<GenerationStatusBuilder> each = generations.iterator();
    final List visitables = _visitables.get("generations");
    while (each.hasNext()) {
      GenerationStatusBuilder builder = each.next();
      if (predicate.test(builder)) {
        visitables.remove(builder);
        each.remove();
      }
    }
    return (A)this;
  }
  public List<GenerationStatus> buildGenerations() {
    return generations != null ? build(generations) : null;
  }
  public GenerationStatus buildGeneration(int index) {
    return this.generations.get(index).build();
  }
  public GenerationStatus buildFirstGeneration() {
    return this.generations.get(0).build();
  }
  public GenerationStatus buildLastGeneration() {
    return this.generations.get(generations.size() - 1).build();
  }
  public GenerationStatus buildMatchingGeneration(Predicate<GenerationStatusBuilder> predicate) {
    for (GenerationStatusBuilder item: generations) { if(predicate.test(item)){ return item.build();} } return null;
  }
  public boolean hasMatchingGeneration(Predicate<GenerationStatusBuilder> predicate) {
    for (GenerationStatusBuilder item: generations) { if(predicate.test(item)){ return true;} } return false;
  }
  public A withGenerations(List<GenerationStatus> generations) {
    if (this.generations != null) { _visitables.get("generations").clear();}
    if (generations != null) {this.generations = new ArrayList(); for (GenerationStatus item : generations){this.addToGenerations(item);}} else { this.generations = null;} return (A) this;
  }
  public A withGenerations(io.fabric8.openclustermanagement.api.model.operator.v1.GenerationStatus... generations) {
    if (this.generations != null) {this.generations.clear(); _visitables.remove("generations"); }
    if (generations != null) {for (GenerationStatus item :generations){ this.addToGenerations(item);}} return (A) this;
  }
  public boolean hasGenerations() {
    return generations != null && !generations.isEmpty();
  }
  public GenerationsNested<A> addNewGeneration() {
    return new GenerationsNested(-1, null);
  }
  public GenerationsNested<A> addNewGenerationLike(GenerationStatus item) {
    return new GenerationsNested(-1, item);
  }
  public GenerationsNested<A> setNewGenerationLike(int index,GenerationStatus item) {
    return new GenerationsNested(index, item);
  }
  public GenerationsNested<A> editGeneration(int index) {
    if (generations.size() <= index) throw new RuntimeException("Can't edit generations. Index exceeds size.");
    return setNewGenerationLike(index, buildGeneration(index));
  }
  public GenerationsNested<A> editFirstGeneration() {
    if (generations.size() == 0) throw new RuntimeException("Can't edit first generations. The list is empty.");
    return setNewGenerationLike(0, buildGeneration(0));
  }
  public GenerationsNested<A> editLastGeneration() {
    int index = generations.size() - 1;
    if (index < 0) throw new RuntimeException("Can't edit last generations. The list is empty.");
    return setNewGenerationLike(index, buildGeneration(index));
  }
  public GenerationsNested<A> editMatchingGeneration(Predicate<GenerationStatusBuilder> predicate) {
    int index = -1;
    for (int i=0;i<generations.size();i++) { 
    if (predicate.test(generations.get(i))) {index = i; break;}
    } 
    if (index < 0) throw new RuntimeException("Can't edit matching generations. No match found.");
    return setNewGenerationLike(index, buildGeneration(index));
  }
  public Long getObservedGeneration() {
    return this.observedGeneration;
  }
  public A withObservedGeneration(Long observedGeneration) {
    this.observedGeneration=observedGeneration; return (A) this;
  }
  public boolean hasObservedGeneration() {
    return this.observedGeneration != null;
  }
  public A addToRelatedResources(int index,RelatedResourceMeta item) {
    if (this.relatedResources == null) {this.relatedResources = new ArrayList<RelatedResourceMetaBuilder>();}
    RelatedResourceMetaBuilder builder = new RelatedResourceMetaBuilder(item);
    if (index < 0 || index >= relatedResources.size()) { _visitables.get("relatedResources").add(builder); relatedResources.add(builder); } else { _visitables.get("relatedResources").add(index, builder); relatedResources.add(index, builder);}
    return (A)this;
  }
  public A setToRelatedResources(int index,RelatedResourceMeta item) {
    if (this.relatedResources == null) {this.relatedResources = new ArrayList<RelatedResourceMetaBuilder>();}
    RelatedResourceMetaBuilder builder = new RelatedResourceMetaBuilder(item);
    if (index < 0 || index >= relatedResources.size()) { _visitables.get("relatedResources").add(builder); relatedResources.add(builder); } else { _visitables.get("relatedResources").set(index, builder); relatedResources.set(index, builder);}
    return (A)this;
  }
  public A addToRelatedResources(io.fabric8.openclustermanagement.api.model.operator.v1.RelatedResourceMeta... items) {
    if (this.relatedResources == null) {this.relatedResources = new ArrayList<RelatedResourceMetaBuilder>();}
    for (RelatedResourceMeta item : items) {RelatedResourceMetaBuilder builder = new RelatedResourceMetaBuilder(item);_visitables.get("relatedResources").add(builder);this.relatedResources.add(builder);} return (A)this;
  }
  public A addAllToRelatedResources(Collection<RelatedResourceMeta> items) {
    if (this.relatedResources == null) {this.relatedResources = new ArrayList<RelatedResourceMetaBuilder>();}
    for (RelatedResourceMeta item : items) {RelatedResourceMetaBuilder builder = new RelatedResourceMetaBuilder(item);_visitables.get("relatedResources").add(builder);this.relatedResources.add(builder);} return (A)this;
  }
  public A removeFromRelatedResources(io.fabric8.openclustermanagement.api.model.operator.v1.RelatedResourceMeta... items) {
    if (this.relatedResources == null) return (A)this;
    for (RelatedResourceMeta item : items) {RelatedResourceMetaBuilder builder = new RelatedResourceMetaBuilder(item);_visitables.get("relatedResources").remove(builder); this.relatedResources.remove(builder);} return (A)this;
  }
  public A removeAllFromRelatedResources(Collection<RelatedResourceMeta> items) {
    if (this.relatedResources == null) return (A)this;
    for (RelatedResourceMeta item : items) {RelatedResourceMetaBuilder builder = new RelatedResourceMetaBuilder(item);_visitables.get("relatedResources").remove(builder); this.relatedResources.remove(builder);} return (A)this;
  }
  public A removeMatchingFromRelatedResources(Predicate<RelatedResourceMetaBuilder> predicate) {
    if (relatedResources == null) return (A) this;
    final Iterator<RelatedResourceMetaBuilder> each = relatedResources.iterator();
    final List visitables = _visitables.get("relatedResources");
    while (each.hasNext()) {
      RelatedResourceMetaBuilder builder = each.next();
      if (predicate.test(builder)) {
        visitables.remove(builder);
        each.remove();
      }
    }
    return (A)this;
  }
  public List<RelatedResourceMeta> buildRelatedResources() {
    return relatedResources != null ? build(relatedResources) : null;
  }
  public RelatedResourceMeta buildRelatedResource(int index) {
    return this.relatedResources.get(index).build();
  }
  public RelatedResourceMeta buildFirstRelatedResource() {
    return this.relatedResources.get(0).build();
  }
  public RelatedResourceMeta buildLastRelatedResource() {
    return this.relatedResources.get(relatedResources.size() - 1).build();
  }
  public RelatedResourceMeta buildMatchingRelatedResource(Predicate<RelatedResourceMetaBuilder> predicate) {
    for (RelatedResourceMetaBuilder item: relatedResources) { if(predicate.test(item)){ return item.build();} } return null;
  }
  public boolean hasMatchingRelatedResource(Predicate<RelatedResourceMetaBuilder> predicate) {
    for (RelatedResourceMetaBuilder item: relatedResources) { if(predicate.test(item)){ return true;} } return false;
  }
  public A withRelatedResources(List<RelatedResourceMeta> relatedResources) {
    if (this.relatedResources != null) { _visitables.get("relatedResources").clear();}
    if (relatedResources != null) {this.relatedResources = new ArrayList(); for (RelatedResourceMeta item : relatedResources){this.addToRelatedResources(item);}} else { this.relatedResources = null;} return (A) this;
  }
  public A withRelatedResources(io.fabric8.openclustermanagement.api.model.operator.v1.RelatedResourceMeta... relatedResources) {
    if (this.relatedResources != null) {this.relatedResources.clear(); _visitables.remove("relatedResources"); }
    if (relatedResources != null) {for (RelatedResourceMeta item :relatedResources){ this.addToRelatedResources(item);}} return (A) this;
  }
  public boolean hasRelatedResources() {
    return relatedResources != null && !relatedResources.isEmpty();
  }
  public A addNewRelatedResource(String group,String name,String namespace,String resource,String version) {
    return (A)addToRelatedResources(new RelatedResourceMeta(group, name, namespace, resource, version));
  }
  public RelatedResourcesNested<A> addNewRelatedResource() {
    return new RelatedResourcesNested(-1, null);
  }
  public RelatedResourcesNested<A> addNewRelatedResourceLike(RelatedResourceMeta item) {
    return new RelatedResourcesNested(-1, item);
  }
  public RelatedResourcesNested<A> setNewRelatedResourceLike(int index,RelatedResourceMeta item) {
    return new RelatedResourcesNested(index, item);
  }
  public RelatedResourcesNested<A> editRelatedResource(int index) {
    if (relatedResources.size() <= index) throw new RuntimeException("Can't edit relatedResources. Index exceeds size.");
    return setNewRelatedResourceLike(index, buildRelatedResource(index));
  }
  public RelatedResourcesNested<A> editFirstRelatedResource() {
    if (relatedResources.size() == 0) throw new RuntimeException("Can't edit first relatedResources. The list is empty.");
    return setNewRelatedResourceLike(0, buildRelatedResource(0));
  }
  public RelatedResourcesNested<A> editLastRelatedResource() {
    int index = relatedResources.size() - 1;
    if (index < 0) throw new RuntimeException("Can't edit last relatedResources. The list is empty.");
    return setNewRelatedResourceLike(index, buildRelatedResource(index));
  }
  public RelatedResourcesNested<A> editMatchingRelatedResource(Predicate<RelatedResourceMetaBuilder> predicate) {
    int index = -1;
    for (int i=0;i<relatedResources.size();i++) { 
    if (predicate.test(relatedResources.get(i))) {index = i; break;}
    } 
    if (index < 0) throw new RuntimeException("Can't edit matching relatedResources. No match found.");
    return setNewRelatedResourceLike(index, buildRelatedResource(index));
  }
  public boolean equals(Object o) {
    if (this == o) return true;
    if (o == null || getClass() != o.getClass()) return false;
    if (!super.equals(o)) return false;
    ClusterManagerStatusFluent that = (ClusterManagerStatusFluent) o;
    if (!java.util.Objects.equals(conditions, that.conditions)) return false;

    if (!java.util.Objects.equals(generations, that.generations)) return false;

    if (!java.util.Objects.equals(observedGeneration, that.observedGeneration)) return false;

    if (!java.util.Objects.equals(relatedResources, that.relatedResources)) return false;

    return true;
  }
  public int hashCode() {
    return java.util.Objects.hash(conditions,  generations,  observedGeneration,  relatedResources,  super.hashCode());
  }
  public String toString() {
    StringBuilder sb = new StringBuilder();
    sb.append("{");
    if (conditions != null && !conditions.isEmpty()) { sb.append("conditions:"); sb.append(conditions + ","); }
    if (generations != null && !generations.isEmpty()) { sb.append("generations:"); sb.append(generations + ","); }
    if (observedGeneration != null) { sb.append("observedGeneration:"); sb.append(observedGeneration + ","); }
    if (relatedResources != null && !relatedResources.isEmpty()) { sb.append("relatedResources:"); sb.append(relatedResources); }
    sb.append("}");
    return sb.toString();
  }
  public class GenerationsNested<N> extends GenerationStatusFluent<GenerationsNested<N>> implements Nested<N>{
    GenerationsNested(int index,GenerationStatus item) {
      this.index = index;
      this.builder = new GenerationStatusBuilder(this, item);
    }
    GenerationStatusBuilder builder;
    int index;
    public N and() {
      return (N) ClusterManagerStatusFluent.this.setToGenerations(index,builder.build());
    }
    public N endGeneration() {
      return and();
    }
    
  }
  public class RelatedResourcesNested<N> extends RelatedResourceMetaFluent<RelatedResourcesNested<N>> implements Nested<N>{
    RelatedResourcesNested(int index,RelatedResourceMeta item) {
      this.index = index;
      this.builder = new RelatedResourceMetaBuilder(this, item);
    }
    RelatedResourceMetaBuilder builder;
    int index;
    public N and() {
      return (N) ClusterManagerStatusFluent.this.setToRelatedResources(index,builder.build());
    }
    public N endRelatedResource() {
      return and();
    }
    
  }
  
}