package io.fabric8.openclustermanagement.api.model.multiclusterhub.operator.v1;

import io.fabric8.kubernetes.api.builder.VisitableBuilder;
import java.lang.Boolean;
public class VeleroBackupConfigBuilder extends VeleroBackupConfigFluent<VeleroBackupConfigBuilder> implements VisitableBuilder<VeleroBackupConfig,VeleroBackupConfigBuilder>{
  public VeleroBackupConfigBuilder() {
    this(false);
  }
  public VeleroBackupConfigBuilder(Boolean validationEnabled) {
    this(new VeleroBackupConfig(), validationEnabled);
  }
  public VeleroBackupConfigBuilder(VeleroBackupConfigFluent<?> fluent) {
    this(fluent, false);
  }
  public VeleroBackupConfigBuilder(VeleroBackupConfigFluent<?> fluent,Boolean validationEnabled) {
    this(fluent, new VeleroBackupConfig(), validationEnabled);
  }
  public VeleroBackupConfigBuilder(VeleroBackupConfigFluent<?> fluent,VeleroBackupConfig instance) {
    this(fluent, instance, false);
  }
  public VeleroBackupConfigBuilder(VeleroBackupConfigFluent<?> fluent,VeleroBackupConfig instance,Boolean validationEnabled) {
    this.fluent = fluent; 
    instance = (instance != null ? instance : new VeleroBackupConfig());

    if (instance != null) {
      fluent.withEnabled(instance.getEnabled());
      fluent.withEnabled(instance.getEnabled());
    }
    this.validationEnabled = validationEnabled; 
  }
  public VeleroBackupConfigBuilder(VeleroBackupConfig instance) {
    this(instance,false);
  }
  public VeleroBackupConfigBuilder(VeleroBackupConfig instance,Boolean validationEnabled) {
    this.fluent = this; 
    instance = (instance != null ? instance : new VeleroBackupConfig());

    if (instance != null) {
      this.withEnabled(instance.getEnabled());
      this.withEnabled(instance.getEnabled());
    }
    this.validationEnabled = validationEnabled; 
  }
  VeleroBackupConfigFluent<?> fluent;
  Boolean validationEnabled;
  public VeleroBackupConfig build() {
    VeleroBackupConfig buildable = new VeleroBackupConfig(fluent.getEnabled());
    return buildable;
  }
  
}