package io.fabric8.openclustermanagement.api.model.multiclusterhub.operator.v1;

import io.fabric8.kubernetes.api.builder.VisitableBuilder;
import java.lang.Boolean;
public class MultiClusterHubSpecBuilder extends MultiClusterHubSpecFluent<MultiClusterHubSpecBuilder> implements VisitableBuilder<MultiClusterHubSpec,MultiClusterHubSpecBuilder>{
  public MultiClusterHubSpecBuilder() {
    this(false);
  }
  public MultiClusterHubSpecBuilder(Boolean validationEnabled) {
    this(new MultiClusterHubSpec(), validationEnabled);
  }
  public MultiClusterHubSpecBuilder(MultiClusterHubSpecFluent<?> fluent) {
    this(fluent, false);
  }
  public MultiClusterHubSpecBuilder(MultiClusterHubSpecFluent<?> fluent,Boolean validationEnabled) {
    this(fluent, new MultiClusterHubSpec(), validationEnabled);
  }
  public MultiClusterHubSpecBuilder(MultiClusterHubSpecFluent<?> fluent,MultiClusterHubSpec instance) {
    this(fluent, instance, false);
  }
  public MultiClusterHubSpecBuilder(MultiClusterHubSpecFluent<?> fluent,MultiClusterHubSpec instance,Boolean validationEnabled) {
    this.fluent = fluent; 
    instance = (instance != null ? instance : new MultiClusterHubSpec());

    if (instance != null) {
      fluent.withAvailabilityConfig(instance.getAvailabilityConfig());
      fluent.withCustomCAConfigmap(instance.getCustomCAConfigmap());
      fluent.withDisableHubSelfManagement(instance.getDisableHubSelfManagement());
      fluent.withDisableUpdateClusterImageSets(instance.getDisableUpdateClusterImageSets());
      fluent.withEnableClusterBackup(instance.getEnableClusterBackup());
      fluent.withEnableClusterProxyAddon(instance.getEnableClusterProxyAddon());
      fluent.withHive(instance.getHive());
      fluent.withImagePullSecret(instance.getImagePullSecret());
      fluent.withIngress(instance.getIngress());
      fluent.withNodeSelector(instance.getNodeSelector());
      fluent.withOverrides(instance.getOverrides());
      fluent.withSeparateCertificateManagement(instance.getSeparateCertificateManagement());
      fluent.withAvailabilityConfig(instance.getAvailabilityConfig());
      fluent.withCustomCAConfigmap(instance.getCustomCAConfigmap());
      fluent.withDisableHubSelfManagement(instance.getDisableHubSelfManagement());
      fluent.withDisableUpdateClusterImageSets(instance.getDisableUpdateClusterImageSets());
      fluent.withEnableClusterBackup(instance.getEnableClusterBackup());
      fluent.withEnableClusterProxyAddon(instance.getEnableClusterProxyAddon());
      fluent.withHive(instance.getHive());
      fluent.withImagePullSecret(instance.getImagePullSecret());
      fluent.withIngress(instance.getIngress());
      fluent.withNodeSelector(instance.getNodeSelector());
      fluent.withOverrides(instance.getOverrides());
      fluent.withSeparateCertificateManagement(instance.getSeparateCertificateManagement());
    }
    this.validationEnabled = validationEnabled; 
  }
  public MultiClusterHubSpecBuilder(MultiClusterHubSpec instance) {
    this(instance,false);
  }
  public MultiClusterHubSpecBuilder(MultiClusterHubSpec instance,Boolean validationEnabled) {
    this.fluent = this; 
    instance = (instance != null ? instance : new MultiClusterHubSpec());

    if (instance != null) {
      this.withAvailabilityConfig(instance.getAvailabilityConfig());
      this.withCustomCAConfigmap(instance.getCustomCAConfigmap());
      this.withDisableHubSelfManagement(instance.getDisableHubSelfManagement());
      this.withDisableUpdateClusterImageSets(instance.getDisableUpdateClusterImageSets());
      this.withEnableClusterBackup(instance.getEnableClusterBackup());
      this.withEnableClusterProxyAddon(instance.getEnableClusterProxyAddon());
      this.withHive(instance.getHive());
      this.withImagePullSecret(instance.getImagePullSecret());
      this.withIngress(instance.getIngress());
      this.withNodeSelector(instance.getNodeSelector());
      this.withOverrides(instance.getOverrides());
      this.withSeparateCertificateManagement(instance.getSeparateCertificateManagement());
      this.withAvailabilityConfig(instance.getAvailabilityConfig());
      this.withCustomCAConfigmap(instance.getCustomCAConfigmap());
      this.withDisableHubSelfManagement(instance.getDisableHubSelfManagement());
      this.withDisableUpdateClusterImageSets(instance.getDisableUpdateClusterImageSets());
      this.withEnableClusterBackup(instance.getEnableClusterBackup());
      this.withEnableClusterProxyAddon(instance.getEnableClusterProxyAddon());
      this.withHive(instance.getHive());
      this.withImagePullSecret(instance.getImagePullSecret());
      this.withIngress(instance.getIngress());
      this.withNodeSelector(instance.getNodeSelector());
      this.withOverrides(instance.getOverrides());
      this.withSeparateCertificateManagement(instance.getSeparateCertificateManagement());
    }
    this.validationEnabled = validationEnabled; 
  }
  MultiClusterHubSpecFluent<?> fluent;
  Boolean validationEnabled;
  public MultiClusterHubSpec build() {
    MultiClusterHubSpec buildable = new MultiClusterHubSpec(fluent.getAvailabilityConfig(),fluent.getCustomCAConfigmap(),fluent.getDisableHubSelfManagement(),fluent.getDisableUpdateClusterImageSets(),fluent.getEnableClusterBackup(),fluent.getEnableClusterProxyAddon(),fluent.buildHive(),fluent.getImagePullSecret(),fluent.buildIngress(),fluent.getNodeSelector(),fluent.buildOverrides(),fluent.getSeparateCertificateManagement());
    return buildable;
  }
  
}