package io.fabric8.openclustermanagement.api.model.multiclusterhub.operator.v1;

import io.fabric8.kubernetes.api.builder.VisitableBuilder;
import java.lang.Boolean;
public class IngressSpecBuilder extends IngressSpecFluent<IngressSpecBuilder> implements VisitableBuilder<IngressSpec,IngressSpecBuilder>{
  public IngressSpecBuilder() {
    this(false);
  }
  public IngressSpecBuilder(Boolean validationEnabled) {
    this(new IngressSpec(), validationEnabled);
  }
  public IngressSpecBuilder(IngressSpecFluent<?> fluent) {
    this(fluent, false);
  }
  public IngressSpecBuilder(IngressSpecFluent<?> fluent,Boolean validationEnabled) {
    this(fluent, new IngressSpec(), validationEnabled);
  }
  public IngressSpecBuilder(IngressSpecFluent<?> fluent,IngressSpec instance) {
    this(fluent, instance, false);
  }
  public IngressSpecBuilder(IngressSpecFluent<?> fluent,IngressSpec instance,Boolean validationEnabled) {
    this.fluent = fluent; 
    instance = (instance != null ? instance : new IngressSpec());

    if (instance != null) {
      fluent.withSslCiphers(instance.getSslCiphers());
      fluent.withSslCiphers(instance.getSslCiphers());
    }
    this.validationEnabled = validationEnabled; 
  }
  public IngressSpecBuilder(IngressSpec instance) {
    this(instance,false);
  }
  public IngressSpecBuilder(IngressSpec instance,Boolean validationEnabled) {
    this.fluent = this; 
    instance = (instance != null ? instance : new IngressSpec());

    if (instance != null) {
      this.withSslCiphers(instance.getSslCiphers());
      this.withSslCiphers(instance.getSslCiphers());
    }
    this.validationEnabled = validationEnabled; 
  }
  IngressSpecFluent<?> fluent;
  Boolean validationEnabled;
  public IngressSpec build() {
    IngressSpec buildable = new IngressSpec(fluent.getSslCiphers());
    return buildable;
  }
  
}