package io.fabric8.openclustermanagement.api.model.multiclusterhub.operator.v1;

import io.fabric8.kubernetes.api.builder.VisitableBuilder;
import java.lang.Boolean;
public class HubConditionBuilder extends HubConditionFluent<HubConditionBuilder> implements VisitableBuilder<HubCondition,HubConditionBuilder>{
  public HubConditionBuilder() {
    this(false);
  }
  public HubConditionBuilder(Boolean validationEnabled) {
    this(new HubCondition(), validationEnabled);
  }
  public HubConditionBuilder(HubConditionFluent<?> fluent) {
    this(fluent, false);
  }
  public HubConditionBuilder(HubConditionFluent<?> fluent,Boolean validationEnabled) {
    this(fluent, new HubCondition(), validationEnabled);
  }
  public HubConditionBuilder(HubConditionFluent<?> fluent,HubCondition instance) {
    this(fluent, instance, false);
  }
  public HubConditionBuilder(HubConditionFluent<?> fluent,HubCondition instance,Boolean validationEnabled) {
    this.fluent = fluent; 
    instance = (instance != null ? instance : new HubCondition());

    if (instance != null) {
      fluent.withLastTransitionTime(instance.getLastTransitionTime());
      fluent.withLastUpdateTime(instance.getLastUpdateTime());
      fluent.withMessage(instance.getMessage());
      fluent.withReason(instance.getReason());
      fluent.withStatus(instance.getStatus());
      fluent.withType(instance.getType());
      fluent.withLastTransitionTime(instance.getLastTransitionTime());
      fluent.withLastUpdateTime(instance.getLastUpdateTime());
      fluent.withMessage(instance.getMessage());
      fluent.withReason(instance.getReason());
      fluent.withStatus(instance.getStatus());
      fluent.withType(instance.getType());
    }
    this.validationEnabled = validationEnabled; 
  }
  public HubConditionBuilder(HubCondition instance) {
    this(instance,false);
  }
  public HubConditionBuilder(HubCondition instance,Boolean validationEnabled) {
    this.fluent = this; 
    instance = (instance != null ? instance : new HubCondition());

    if (instance != null) {
      this.withLastTransitionTime(instance.getLastTransitionTime());
      this.withLastUpdateTime(instance.getLastUpdateTime());
      this.withMessage(instance.getMessage());
      this.withReason(instance.getReason());
      this.withStatus(instance.getStatus());
      this.withType(instance.getType());
      this.withLastTransitionTime(instance.getLastTransitionTime());
      this.withLastUpdateTime(instance.getLastUpdateTime());
      this.withMessage(instance.getMessage());
      this.withReason(instance.getReason());
      this.withStatus(instance.getStatus());
      this.withType(instance.getType());
    }
    this.validationEnabled = validationEnabled; 
  }
  HubConditionFluent<?> fluent;
  Boolean validationEnabled;
  public HubCondition build() {
    HubCondition buildable = new HubCondition(fluent.getLastTransitionTime(),fluent.getLastUpdateTime(),fluent.getMessage(),fluent.getReason(),fluent.getStatus(),fluent.getType());
    return buildable;
  }
  
}