package io.fabric8.openclustermanagement.api.model.multiclusterhub.operator.v1;

import io.fabric8.kubernetes.api.builder.VisitableBuilder;
import java.lang.Boolean;
public class BackupConfigBuilder extends BackupConfigFluent<BackupConfigBuilder> implements VisitableBuilder<BackupConfig,BackupConfigBuilder>{
  public BackupConfigBuilder() {
    this(false);
  }
  public BackupConfigBuilder(Boolean validationEnabled) {
    this(new BackupConfig(), validationEnabled);
  }
  public BackupConfigBuilder(BackupConfigFluent<?> fluent) {
    this(fluent, false);
  }
  public BackupConfigBuilder(BackupConfigFluent<?> fluent,Boolean validationEnabled) {
    this(fluent, new BackupConfig(), validationEnabled);
  }
  public BackupConfigBuilder(BackupConfigFluent<?> fluent,BackupConfig instance) {
    this(fluent, instance, false);
  }
  public BackupConfigBuilder(BackupConfigFluent<?> fluent,BackupConfig instance,Boolean validationEnabled) {
    this.fluent = fluent; 
    instance = (instance != null ? instance : new BackupConfig());

    if (instance != null) {
      fluent.withMinBackupPeriodSeconds(instance.getMinBackupPeriodSeconds());
      fluent.withVelero(instance.getVelero());
      fluent.withMinBackupPeriodSeconds(instance.getMinBackupPeriodSeconds());
      fluent.withVelero(instance.getVelero());
    }
    this.validationEnabled = validationEnabled; 
  }
  public BackupConfigBuilder(BackupConfig instance) {
    this(instance,false);
  }
  public BackupConfigBuilder(BackupConfig instance,Boolean validationEnabled) {
    this.fluent = this; 
    instance = (instance != null ? instance : new BackupConfig());

    if (instance != null) {
      this.withMinBackupPeriodSeconds(instance.getMinBackupPeriodSeconds());
      this.withVelero(instance.getVelero());
      this.withMinBackupPeriodSeconds(instance.getMinBackupPeriodSeconds());
      this.withVelero(instance.getVelero());
    }
    this.validationEnabled = validationEnabled; 
  }
  BackupConfigFluent<?> fluent;
  Boolean validationEnabled;
  public BackupConfig build() {
    BackupConfig buildable = new BackupConfig(fluent.getMinBackupPeriodSeconds(),fluent.buildVelero());
    return buildable;
  }
  
}