package io.fabric8.openclustermanagement.api.model.operator.v1;

import io.fabric8.kubernetes.api.model.Condition;
import io.fabric8.kubernetes.api.builder.VisitableBuilder;
import com.fasterxml.jackson.annotation.JsonProperty;
import io.fabric8.kubernetes.api.builder.Fluent;
import com.fasterxml.jackson.annotation.JsonInclude;
import io.fabric8.kubernetes.api.builder.Nested;
import java.util.ArrayList;
import java.lang.String;
import java.util.function.Predicate;
import java.lang.Deprecated;
import java.lang.Long;
import java.util.Iterator;
import java.util.Collection;
import java.util.List;
import java.lang.Boolean;

 /**
  * Generated
  */
public interface KlusterletStatusFluent<A extends KlusterletStatusFluent<A>> extends Fluent<A>{
  public A addToConditions(int index,Condition item);
  public A setToConditions(int index,Condition item);
  public A addToConditions(io.fabric8.kubernetes.api.model.Condition... items);
  public A addAllToConditions(Collection<Condition> items);
  public A removeFromConditions(io.fabric8.kubernetes.api.model.Condition... items);
  public A removeAllFromConditions(Collection<Condition> items);
  public List<Condition> getConditions();
  public Condition getCondition(int index);
  public Condition getFirstCondition();
  public Condition getLastCondition();
  public Condition getMatchingCondition(Predicate<Condition> predicate);
  public Boolean hasMatchingCondition(Predicate<Condition> predicate);
  public A withConditions(List<Condition> conditions);
  public A withConditions(io.fabric8.kubernetes.api.model.Condition... conditions);
  public Boolean hasConditions();
  public A addToGenerations(int index,GenerationStatus item);
  public A setToGenerations(int index,GenerationStatus item);
  public A addToGenerations(io.fabric8.openclustermanagement.api.model.operator.v1.GenerationStatus... items);
  public A addAllToGenerations(Collection<GenerationStatus> items);
  public A removeFromGenerations(io.fabric8.openclustermanagement.api.model.operator.v1.GenerationStatus... items);
  public A removeAllFromGenerations(Collection<GenerationStatus> items);
  public A removeMatchingFromGenerations(Predicate<GenerationStatusBuilder> predicate);
  
  /**
   * This method has been deprecated, please use method buildGenerations instead.
   * @return The buildable object.
   */
  @Deprecated
  public List<GenerationStatus> getGenerations();
  public List<GenerationStatus> buildGenerations();
  public GenerationStatus buildGeneration(int index);
  public GenerationStatus buildFirstGeneration();
  public GenerationStatus buildLastGeneration();
  public GenerationStatus buildMatchingGeneration(Predicate<GenerationStatusBuilder> predicate);
  public Boolean hasMatchingGeneration(Predicate<GenerationStatusBuilder> predicate);
  public A withGenerations(List<GenerationStatus> generations);
  public A withGenerations(io.fabric8.openclustermanagement.api.model.operator.v1.GenerationStatus... generations);
  public Boolean hasGenerations();
  public KlusterletStatusFluent.GenerationsNested<A> addNewGeneration();
  public KlusterletStatusFluent.GenerationsNested<A> addNewGenerationLike(GenerationStatus item);
  public KlusterletStatusFluent.GenerationsNested<A> setNewGenerationLike(int index,GenerationStatus item);
  public KlusterletStatusFluent.GenerationsNested<A> editGeneration(int index);
  public KlusterletStatusFluent.GenerationsNested<A> editFirstGeneration();
  public KlusterletStatusFluent.GenerationsNested<A> editLastGeneration();
  public KlusterletStatusFluent.GenerationsNested<A> editMatchingGeneration(Predicate<GenerationStatusBuilder> predicate);
  public Long getObservedGeneration();
  public A withObservedGeneration(Long observedGeneration);
  public Boolean hasObservedGeneration();
  public A addToRelatedResources(int index,RelatedResourceMeta item);
  public A setToRelatedResources(int index,RelatedResourceMeta item);
  public A addToRelatedResources(io.fabric8.openclustermanagement.api.model.operator.v1.RelatedResourceMeta... items);
  public A addAllToRelatedResources(Collection<RelatedResourceMeta> items);
  public A removeFromRelatedResources(io.fabric8.openclustermanagement.api.model.operator.v1.RelatedResourceMeta... items);
  public A removeAllFromRelatedResources(Collection<RelatedResourceMeta> items);
  public A removeMatchingFromRelatedResources(Predicate<RelatedResourceMetaBuilder> predicate);
  
  /**
   * This method has been deprecated, please use method buildRelatedResources instead.
   * @return The buildable object.
   */
  @Deprecated
  public List<RelatedResourceMeta> getRelatedResources();
  public List<RelatedResourceMeta> buildRelatedResources();
  public RelatedResourceMeta buildRelatedResource(int index);
  public RelatedResourceMeta buildFirstRelatedResource();
  public RelatedResourceMeta buildLastRelatedResource();
  public RelatedResourceMeta buildMatchingRelatedResource(Predicate<RelatedResourceMetaBuilder> predicate);
  public Boolean hasMatchingRelatedResource(Predicate<RelatedResourceMetaBuilder> predicate);
  public A withRelatedResources(List<RelatedResourceMeta> relatedResources);
  public A withRelatedResources(io.fabric8.openclustermanagement.api.model.operator.v1.RelatedResourceMeta... relatedResources);
  public Boolean hasRelatedResources();
  public A addNewRelatedResource(String group,String name,String namespace,String resource,String version);
  public KlusterletStatusFluent.RelatedResourcesNested<A> addNewRelatedResource();
  public KlusterletStatusFluent.RelatedResourcesNested<A> addNewRelatedResourceLike(RelatedResourceMeta item);
  public KlusterletStatusFluent.RelatedResourcesNested<A> setNewRelatedResourceLike(int index,RelatedResourceMeta item);
  public KlusterletStatusFluent.RelatedResourcesNested<A> editRelatedResource(int index);
  public KlusterletStatusFluent.RelatedResourcesNested<A> editFirstRelatedResource();
  public KlusterletStatusFluent.RelatedResourcesNested<A> editLastRelatedResource();
  public KlusterletStatusFluent.RelatedResourcesNested<A> editMatchingRelatedResource(Predicate<RelatedResourceMetaBuilder> predicate);
  public interface GenerationsNested<N> extends Nested<N>,GenerationStatusFluent<KlusterletStatusFluent.GenerationsNested<N>>{
    public N and();
    public N endGeneration();
    
  }
  public interface RelatedResourcesNested<N> extends Nested<N>,RelatedResourceMetaFluent<KlusterletStatusFluent.RelatedResourcesNested<N>>{
    public N and();
    public N endRelatedResource();
    
  }
  
}