package io.fabric8.openclustermanagement.api.model.operator.v1;

import io.fabric8.kubernetes.api.builder.VisitableBuilder;
import java.lang.Boolean;
public class ClusterManagerBuilder extends ClusterManagerFluentImpl<ClusterManagerBuilder> implements VisitableBuilder<ClusterManager,ClusterManagerBuilder>{
  public ClusterManagerBuilder() {
    this(false);
  }
  public ClusterManagerBuilder(Boolean validationEnabled) {
    this(new ClusterManager(), validationEnabled);
  }
  public ClusterManagerBuilder(ClusterManagerFluent<?> fluent) {
    this(fluent, false);
  }
  public ClusterManagerBuilder(ClusterManagerFluent<?> fluent,Boolean validationEnabled) {
    this(fluent, new ClusterManager(), validationEnabled);
  }
  public ClusterManagerBuilder(ClusterManagerFluent<?> fluent,ClusterManager instance) {
    this(fluent, instance, false);
  }
  public ClusterManagerBuilder(ClusterManagerFluent<?> fluent,ClusterManager instance,Boolean validationEnabled) {
    this.fluent = fluent; 
    if (instance != null) {
      fluent.withApiVersion(instance.getApiVersion());
      fluent.withKind(instance.getKind());
      fluent.withMetadata(instance.getMetadata());
      fluent.withSpec(instance.getSpec());
      fluent.withStatus(instance.getStatus());
    }
    this.validationEnabled = validationEnabled; 
  }
  public ClusterManagerBuilder(ClusterManager instance) {
    this(instance,false);
  }
  public ClusterManagerBuilder(ClusterManager instance,Boolean validationEnabled) {
    this.fluent = this; 
    if (instance != null) {
      this.withApiVersion(instance.getApiVersion());
      this.withKind(instance.getKind());
      this.withMetadata(instance.getMetadata());
      this.withSpec(instance.getSpec());
      this.withStatus(instance.getStatus());
    }
    this.validationEnabled = validationEnabled; 
  }
  ClusterManagerFluent<?> fluent;
  Boolean validationEnabled;
  public ClusterManager build() {
    ClusterManager buildable = new ClusterManager(fluent.getApiVersion(),fluent.getKind(),fluent.getMetadata(),fluent.getSpec(),fluent.getStatus());
    return buildable;
  }
  
}