package io.fabric8.openclustermanagement.api.model.multiclusterhub.operator.v1;

import java.lang.SuppressWarnings;
import io.fabric8.kubernetes.api.builder.Nested;
import java.lang.String;
import java.util.LinkedHashMap;
import java.lang.Deprecated;
import io.fabric8.kubernetes.api.builder.BaseFluent;
import java.lang.Boolean;
import java.lang.Object;
import java.util.Map;

 /**
  * Generated
  */
  @SuppressWarnings(value = "unchecked")
  public class MultiClusterHubSpecFluentImpl<A extends MultiClusterHubSpecFluent<A>> extends BaseFluent<A> implements MultiClusterHubSpecFluent<A>{
  public MultiClusterHubSpecFluentImpl() {
  }
  public MultiClusterHubSpecFluentImpl(MultiClusterHubSpec instance) {
    if (instance != null) {
      this.withAvailabilityConfig(instance.getAvailabilityConfig());
      this.withCustomCAConfigmap(instance.getCustomCAConfigmap());
      this.withDisableHubSelfManagement(instance.getDisableHubSelfManagement());
      this.withDisableUpdateClusterImageSets(instance.getDisableUpdateClusterImageSets());
      this.withEnableClusterBackup(instance.getEnableClusterBackup());
      this.withEnableClusterProxyAddon(instance.getEnableClusterProxyAddon());
      this.withHive(instance.getHive());
      this.withImagePullSecret(instance.getImagePullSecret());
      this.withIngress(instance.getIngress());
      this.withNodeSelector(instance.getNodeSelector());
      this.withOverrides(instance.getOverrides());
      this.withSeparateCertificateManagement(instance.getSeparateCertificateManagement());
    }
  }
  private String availabilityConfig;
  private String customCAConfigmap;
  private Boolean disableHubSelfManagement;
  private Boolean disableUpdateClusterImageSets;
  private Boolean enableClusterBackup;
  private Boolean enableClusterProxyAddon;
  private HiveConfigSpecBuilder hive;
  private String imagePullSecret;
  private IngressSpecBuilder ingress;
  private Map<String,String> nodeSelector;
  private OverridesBuilder overrides;
  private Boolean separateCertificateManagement;
  public String getAvailabilityConfig() {
    return this.availabilityConfig;
  }
  public A withAvailabilityConfig(String availabilityConfig) {
    this.availabilityConfig=availabilityConfig; return (A) this;
  }
  public Boolean hasAvailabilityConfig() {
    return this.availabilityConfig != null;
  }
  public String getCustomCAConfigmap() {
    return this.customCAConfigmap;
  }
  public A withCustomCAConfigmap(String customCAConfigmap) {
    this.customCAConfigmap=customCAConfigmap; return (A) this;
  }
  public Boolean hasCustomCAConfigmap() {
    return this.customCAConfigmap != null;
  }
  public Boolean getDisableHubSelfManagement() {
    return this.disableHubSelfManagement;
  }
  public A withDisableHubSelfManagement(Boolean disableHubSelfManagement) {
    this.disableHubSelfManagement=disableHubSelfManagement; return (A) this;
  }
  public Boolean hasDisableHubSelfManagement() {
    return this.disableHubSelfManagement != null;
  }
  public Boolean getDisableUpdateClusterImageSets() {
    return this.disableUpdateClusterImageSets;
  }
  public A withDisableUpdateClusterImageSets(Boolean disableUpdateClusterImageSets) {
    this.disableUpdateClusterImageSets=disableUpdateClusterImageSets; return (A) this;
  }
  public Boolean hasDisableUpdateClusterImageSets() {
    return this.disableUpdateClusterImageSets != null;
  }
  public Boolean getEnableClusterBackup() {
    return this.enableClusterBackup;
  }
  public A withEnableClusterBackup(Boolean enableClusterBackup) {
    this.enableClusterBackup=enableClusterBackup; return (A) this;
  }
  public Boolean hasEnableClusterBackup() {
    return this.enableClusterBackup != null;
  }
  public Boolean getEnableClusterProxyAddon() {
    return this.enableClusterProxyAddon;
  }
  public A withEnableClusterProxyAddon(Boolean enableClusterProxyAddon) {
    this.enableClusterProxyAddon=enableClusterProxyAddon; return (A) this;
  }
  public Boolean hasEnableClusterProxyAddon() {
    return this.enableClusterProxyAddon != null;
  }
  
  /**
   * This method has been deprecated, please use method buildHive instead.
   * @return The buildable object.
   */
  @Deprecated
  public HiveConfigSpec getHive() {
    return this.hive!=null ?this.hive.build():null;
  }
  public HiveConfigSpec buildHive() {
    return this.hive!=null ?this.hive.build():null;
  }
  public A withHive(HiveConfigSpec hive) {
    _visitables.get("hive").remove(this.hive);
    if (hive!=null){ this.hive= new HiveConfigSpecBuilder(hive); _visitables.get("hive").add(this.hive);} else { this.hive = null; _visitables.get("hive").remove(this.hive); } return (A) this;
  }
  public Boolean hasHive() {
    return this.hive != null;
  }
  public MultiClusterHubSpecFluentImpl.HiveNested<A> withNewHive() {
    return new MultiClusterHubSpecFluentImpl.HiveNestedImpl();
  }
  public MultiClusterHubSpecFluentImpl.HiveNested<A> withNewHiveLike(HiveConfigSpec item) {
    return new MultiClusterHubSpecFluentImpl.HiveNestedImpl(item);
  }
  public MultiClusterHubSpecFluentImpl.HiveNested<A> editHive() {
    return withNewHiveLike(getHive());
  }
  public MultiClusterHubSpecFluentImpl.HiveNested<A> editOrNewHive() {
    return withNewHiveLike(getHive() != null ? getHive(): new HiveConfigSpecBuilder().build());
  }
  public MultiClusterHubSpecFluentImpl.HiveNested<A> editOrNewHiveLike(HiveConfigSpec item) {
    return withNewHiveLike(getHive() != null ? getHive(): item);
  }
  public String getImagePullSecret() {
    return this.imagePullSecret;
  }
  public A withImagePullSecret(String imagePullSecret) {
    this.imagePullSecret=imagePullSecret; return (A) this;
  }
  public Boolean hasImagePullSecret() {
    return this.imagePullSecret != null;
  }
  
  /**
   * This method has been deprecated, please use method buildIngress instead.
   * @return The buildable object.
   */
  @Deprecated
  public IngressSpec getIngress() {
    return this.ingress!=null ?this.ingress.build():null;
  }
  public IngressSpec buildIngress() {
    return this.ingress!=null ?this.ingress.build():null;
  }
  public A withIngress(IngressSpec ingress) {
    _visitables.get("ingress").remove(this.ingress);
    if (ingress!=null){ this.ingress= new IngressSpecBuilder(ingress); _visitables.get("ingress").add(this.ingress);} else { this.ingress = null; _visitables.get("ingress").remove(this.ingress); } return (A) this;
  }
  public Boolean hasIngress() {
    return this.ingress != null;
  }
  public MultiClusterHubSpecFluentImpl.IngressNested<A> withNewIngress() {
    return new MultiClusterHubSpecFluentImpl.IngressNestedImpl();
  }
  public MultiClusterHubSpecFluentImpl.IngressNested<A> withNewIngressLike(IngressSpec item) {
    return new MultiClusterHubSpecFluentImpl.IngressNestedImpl(item);
  }
  public MultiClusterHubSpecFluentImpl.IngressNested<A> editIngress() {
    return withNewIngressLike(getIngress());
  }
  public MultiClusterHubSpecFluentImpl.IngressNested<A> editOrNewIngress() {
    return withNewIngressLike(getIngress() != null ? getIngress(): new IngressSpecBuilder().build());
  }
  public MultiClusterHubSpecFluentImpl.IngressNested<A> editOrNewIngressLike(IngressSpec item) {
    return withNewIngressLike(getIngress() != null ? getIngress(): item);
  }
  public A addToNodeSelector(String key,String value) {
    if(this.nodeSelector == null && key != null && value != null) { this.nodeSelector = new LinkedHashMap(); }
    if(key != null && value != null) {this.nodeSelector.put(key, value);} return (A)this;
  }
  public A addToNodeSelector(Map<String,String> map) {
    if(this.nodeSelector == null && map != null) { this.nodeSelector = new LinkedHashMap(); }
    if(map != null) { this.nodeSelector.putAll(map);} return (A)this;
  }
  public A removeFromNodeSelector(String key) {
    if(this.nodeSelector == null) { return (A) this; }
    if(key != null && this.nodeSelector != null) {this.nodeSelector.remove(key);} return (A)this;
  }
  public A removeFromNodeSelector(Map<String,String> map) {
    if(this.nodeSelector == null) { return (A) this; }
    if(map != null) { for(Object key : map.keySet()) {if (this.nodeSelector != null){this.nodeSelector.remove(key);}}} return (A)this;
  }
  public Map<String,String> getNodeSelector() {
    return this.nodeSelector;
  }
  public <K,V>A withNodeSelector(Map<String,String> nodeSelector) {
    if (nodeSelector == null) { this.nodeSelector =  null;} else {this.nodeSelector = new LinkedHashMap(nodeSelector);} return (A) this;
  }
  public Boolean hasNodeSelector() {
    return this.nodeSelector != null;
  }
  
  /**
   * This method has been deprecated, please use method buildOverrides instead.
   * @return The buildable object.
   */
  @Deprecated
  public Overrides getOverrides() {
    return this.overrides!=null ?this.overrides.build():null;
  }
  public Overrides buildOverrides() {
    return this.overrides!=null ?this.overrides.build():null;
  }
  public A withOverrides(Overrides overrides) {
    _visitables.get("overrides").remove(this.overrides);
    if (overrides!=null){ this.overrides= new OverridesBuilder(overrides); _visitables.get("overrides").add(this.overrides);} else { this.overrides = null; _visitables.get("overrides").remove(this.overrides); } return (A) this;
  }
  public Boolean hasOverrides() {
    return this.overrides != null;
  }
  public A withNewOverrides(String imagePullPolicy) {
    return (A)withOverrides(new Overrides(imagePullPolicy));
  }
  public MultiClusterHubSpecFluentImpl.OverridesNested<A> withNewOverrides() {
    return new MultiClusterHubSpecFluentImpl.OverridesNestedImpl();
  }
  public MultiClusterHubSpecFluentImpl.OverridesNested<A> withNewOverridesLike(Overrides item) {
    return new MultiClusterHubSpecFluentImpl.OverridesNestedImpl(item);
  }
  public MultiClusterHubSpecFluentImpl.OverridesNested<A> editOverrides() {
    return withNewOverridesLike(getOverrides());
  }
  public MultiClusterHubSpecFluentImpl.OverridesNested<A> editOrNewOverrides() {
    return withNewOverridesLike(getOverrides() != null ? getOverrides(): new OverridesBuilder().build());
  }
  public MultiClusterHubSpecFluentImpl.OverridesNested<A> editOrNewOverridesLike(Overrides item) {
    return withNewOverridesLike(getOverrides() != null ? getOverrides(): item);
  }
  public Boolean getSeparateCertificateManagement() {
    return this.separateCertificateManagement;
  }
  public A withSeparateCertificateManagement(Boolean separateCertificateManagement) {
    this.separateCertificateManagement=separateCertificateManagement; return (A) this;
  }
  public Boolean hasSeparateCertificateManagement() {
    return this.separateCertificateManagement != null;
  }
  public boolean equals(Object o) {
    if (this == o) return true;
    if (o == null || getClass() != o.getClass()) return false;
    if (!super.equals(o)) return false;
    MultiClusterHubSpecFluentImpl that = (MultiClusterHubSpecFluentImpl) o;
    if (!java.util.Objects.equals(availabilityConfig, that.availabilityConfig)) return false;

    if (!java.util.Objects.equals(customCAConfigmap, that.customCAConfigmap)) return false;

    if (!java.util.Objects.equals(disableHubSelfManagement, that.disableHubSelfManagement)) return false;

    if (!java.util.Objects.equals(disableUpdateClusterImageSets, that.disableUpdateClusterImageSets)) return false;

    if (!java.util.Objects.equals(enableClusterBackup, that.enableClusterBackup)) return false;

    if (!java.util.Objects.equals(enableClusterProxyAddon, that.enableClusterProxyAddon)) return false;

    if (!java.util.Objects.equals(hive, that.hive)) return false;

    if (!java.util.Objects.equals(imagePullSecret, that.imagePullSecret)) return false;

    if (!java.util.Objects.equals(ingress, that.ingress)) return false;

    if (!java.util.Objects.equals(nodeSelector, that.nodeSelector)) return false;

    if (!java.util.Objects.equals(overrides, that.overrides)) return false;

    if (!java.util.Objects.equals(separateCertificateManagement, that.separateCertificateManagement)) return false;

    return true;
  }
  public int hashCode() {
    return java.util.Objects.hash(availabilityConfig,  customCAConfigmap,  disableHubSelfManagement,  disableUpdateClusterImageSets,  enableClusterBackup,  enableClusterProxyAddon,  hive,  imagePullSecret,  ingress,  nodeSelector,  overrides,  separateCertificateManagement,  super.hashCode());
  }
  public String toString() {
    StringBuilder sb = new StringBuilder();
    sb.append("{");
    if (availabilityConfig != null) { sb.append("availabilityConfig:"); sb.append(availabilityConfig + ","); }
    if (customCAConfigmap != null) { sb.append("customCAConfigmap:"); sb.append(customCAConfigmap + ","); }
    if (disableHubSelfManagement != null) { sb.append("disableHubSelfManagement:"); sb.append(disableHubSelfManagement + ","); }
    if (disableUpdateClusterImageSets != null) { sb.append("disableUpdateClusterImageSets:"); sb.append(disableUpdateClusterImageSets + ","); }
    if (enableClusterBackup != null) { sb.append("enableClusterBackup:"); sb.append(enableClusterBackup + ","); }
    if (enableClusterProxyAddon != null) { sb.append("enableClusterProxyAddon:"); sb.append(enableClusterProxyAddon + ","); }
    if (hive != null) { sb.append("hive:"); sb.append(hive + ","); }
    if (imagePullSecret != null) { sb.append("imagePullSecret:"); sb.append(imagePullSecret + ","); }
    if (ingress != null) { sb.append("ingress:"); sb.append(ingress + ","); }
    if (nodeSelector != null && !nodeSelector.isEmpty()) { sb.append("nodeSelector:"); sb.append(nodeSelector + ","); }
    if (overrides != null) { sb.append("overrides:"); sb.append(overrides + ","); }
    if (separateCertificateManagement != null) { sb.append("separateCertificateManagement:"); sb.append(separateCertificateManagement); }
    sb.append("}");
    return sb.toString();
  }
  public A withDisableHubSelfManagement() {
    return withDisableHubSelfManagement(true);
  }
  public A withDisableUpdateClusterImageSets() {
    return withDisableUpdateClusterImageSets(true);
  }
  public A withEnableClusterBackup() {
    return withEnableClusterBackup(true);
  }
  public A withEnableClusterProxyAddon() {
    return withEnableClusterProxyAddon(true);
  }
  public A withSeparateCertificateManagement() {
    return withSeparateCertificateManagement(true);
  }
  class HiveNestedImpl<N> extends HiveConfigSpecFluentImpl<MultiClusterHubSpecFluentImpl.HiveNested<N>> implements MultiClusterHubSpecFluentImpl.HiveNested<N>,Nested<N>{
    HiveNestedImpl(HiveConfigSpec item) {
      this.builder = new HiveConfigSpecBuilder(this, item);
    }
    HiveNestedImpl() {
      this.builder = new HiveConfigSpecBuilder(this);
    }
    HiveConfigSpecBuilder builder;
    public N and() {
      return (N) MultiClusterHubSpecFluentImpl.this.withHive(builder.build());
    }
    public N endHive() {
      return and();
    }
    
  }
  class IngressNestedImpl<N> extends IngressSpecFluentImpl<MultiClusterHubSpecFluentImpl.IngressNested<N>> implements MultiClusterHubSpecFluentImpl.IngressNested<N>,Nested<N>{
    IngressNestedImpl(IngressSpec item) {
      this.builder = new IngressSpecBuilder(this, item);
    }
    IngressNestedImpl() {
      this.builder = new IngressSpecBuilder(this);
    }
    IngressSpecBuilder builder;
    public N and() {
      return (N) MultiClusterHubSpecFluentImpl.this.withIngress(builder.build());
    }
    public N endIngress() {
      return and();
    }
    
  }
  class OverridesNestedImpl<N> extends OverridesFluentImpl<MultiClusterHubSpecFluentImpl.OverridesNested<N>> implements MultiClusterHubSpecFluentImpl.OverridesNested<N>,Nested<N>{
    OverridesNestedImpl(Overrides item) {
      this.builder = new OverridesBuilder(this, item);
    }
    OverridesNestedImpl() {
      this.builder = new OverridesBuilder(this);
    }
    OverridesBuilder builder;
    public N and() {
      return (N) MultiClusterHubSpecFluentImpl.this.withOverrides(builder.build());
    }
    public N endOverrides() {
      return and();
    }
    
  }
  
}