package io.fabric8.openclustermanagement.api.model.multiclusterhub.operator.v1;

import io.fabric8.kubernetes.api.builder.VisitableBuilder;
import java.lang.SuppressWarnings;
import io.fabric8.kubernetes.api.builder.Nested;
import java.util.ArrayList;
import java.lang.String;
import java.util.function.Predicate;
import java.lang.Deprecated;
import io.fabric8.kubernetes.api.builder.BaseFluent;
import io.fabric8.kubernetes.api.model.LocalObjectReferenceFluentImpl;
import java.util.Iterator;
import java.util.List;
import java.lang.Boolean;
import io.fabric8.kubernetes.api.model.LocalObjectReferenceBuilder;
import io.fabric8.kubernetes.api.model.LocalObjectReference;
import java.util.Collection;
import java.lang.Object;

 /**
  * Generated
  */
  @SuppressWarnings(value = "unchecked")
  public class HiveConfigSpecFluentImpl<A extends HiveConfigSpecFluent<A>> extends BaseFluent<A> implements HiveConfigSpecFluent<A>{
  public HiveConfigSpecFluentImpl() {
  }
  public HiveConfigSpecFluentImpl(HiveConfigSpec instance) {
    if (instance != null) {
      this.withAdditionalCertificateAuthorities(instance.getAdditionalCertificateAuthorities());
      this.withBackup(instance.getBackup());
      this.withExternalDNS(instance.getExternalDNS());
      this.withFailedProvisionConfig(instance.getFailedProvisionConfig());
      this.withGlobalPullSecret(instance.getGlobalPullSecret());
      this.withMaintenanceMode(instance.getMaintenanceMode());
    }
  }
  private ArrayList<LocalObjectReferenceBuilder> additionalCertificateAuthorities = new ArrayList<LocalObjectReferenceBuilder>();
  private BackupConfigBuilder backup;
  private ExternalDNSConfigBuilder externalDNS;
  private FailedProvisionConfigBuilder failedProvisionConfig;
  private LocalObjectReferenceBuilder globalPullSecret;
  private Boolean maintenanceMode;
  public A addToAdditionalCertificateAuthorities(int index,LocalObjectReference item) {
    if (this.additionalCertificateAuthorities == null) {this.additionalCertificateAuthorities = new ArrayList<LocalObjectReferenceBuilder>();}
    LocalObjectReferenceBuilder builder = new LocalObjectReferenceBuilder(item);
    if (index < 0 || index >= additionalCertificateAuthorities.size()) { _visitables.get("additionalCertificateAuthorities").add(builder); additionalCertificateAuthorities.add(builder); } else { _visitables.get("additionalCertificateAuthorities").add(index, builder); additionalCertificateAuthorities.add(index, builder);}
    return (A)this;
  }
  public A setToAdditionalCertificateAuthorities(int index,LocalObjectReference item) {
    if (this.additionalCertificateAuthorities == null) {this.additionalCertificateAuthorities = new ArrayList<LocalObjectReferenceBuilder>();}
    LocalObjectReferenceBuilder builder = new LocalObjectReferenceBuilder(item);
    if (index < 0 || index >= additionalCertificateAuthorities.size()) { _visitables.get("additionalCertificateAuthorities").add(builder); additionalCertificateAuthorities.add(builder); } else { _visitables.get("additionalCertificateAuthorities").set(index, builder); additionalCertificateAuthorities.set(index, builder);}
    return (A)this;
  }
  public A addToAdditionalCertificateAuthorities(io.fabric8.kubernetes.api.model.LocalObjectReference... items) {
    if (this.additionalCertificateAuthorities == null) {this.additionalCertificateAuthorities = new ArrayList<LocalObjectReferenceBuilder>();}
    for (LocalObjectReference item : items) {LocalObjectReferenceBuilder builder = new LocalObjectReferenceBuilder(item);_visitables.get("additionalCertificateAuthorities").add(builder);this.additionalCertificateAuthorities.add(builder);} return (A)this;
  }
  public A addAllToAdditionalCertificateAuthorities(Collection<LocalObjectReference> items) {
    if (this.additionalCertificateAuthorities == null) {this.additionalCertificateAuthorities = new ArrayList<LocalObjectReferenceBuilder>();}
    for (LocalObjectReference item : items) {LocalObjectReferenceBuilder builder = new LocalObjectReferenceBuilder(item);_visitables.get("additionalCertificateAuthorities").add(builder);this.additionalCertificateAuthorities.add(builder);} return (A)this;
  }
  public A removeFromAdditionalCertificateAuthorities(io.fabric8.kubernetes.api.model.LocalObjectReference... items) {
    for (LocalObjectReference item : items) {LocalObjectReferenceBuilder builder = new LocalObjectReferenceBuilder(item);_visitables.get("additionalCertificateAuthorities").remove(builder);if (this.additionalCertificateAuthorities != null) {this.additionalCertificateAuthorities.remove(builder);}} return (A)this;
  }
  public A removeAllFromAdditionalCertificateAuthorities(Collection<LocalObjectReference> items) {
    for (LocalObjectReference item : items) {LocalObjectReferenceBuilder builder = new LocalObjectReferenceBuilder(item);_visitables.get("additionalCertificateAuthorities").remove(builder);if (this.additionalCertificateAuthorities != null) {this.additionalCertificateAuthorities.remove(builder);}} return (A)this;
  }
  public A removeMatchingFromAdditionalCertificateAuthorities(Predicate<LocalObjectReferenceBuilder> predicate) {
    if (additionalCertificateAuthorities == null) return (A) this;
    final Iterator<LocalObjectReferenceBuilder> each = additionalCertificateAuthorities.iterator();
    final List visitables = _visitables.get("additionalCertificateAuthorities");
    while (each.hasNext()) {
      LocalObjectReferenceBuilder builder = each.next();
      if (predicate.test(builder)) {
        visitables.remove(builder);
        each.remove();
      }
    }
    return (A)this;
  }
  
  /**
   * This method has been deprecated, please use method buildAdditionalCertificateAuthorities instead.
   * @return The buildable object.
   */
  @Deprecated
  public List<LocalObjectReference> getAdditionalCertificateAuthorities() {
    return additionalCertificateAuthorities != null ? build(additionalCertificateAuthorities) : null;
  }
  public List<LocalObjectReference> buildAdditionalCertificateAuthorities() {
    return additionalCertificateAuthorities != null ? build(additionalCertificateAuthorities) : null;
  }
  public LocalObjectReference buildAdditionalCertificateAuthority(int index) {
    return this.additionalCertificateAuthorities.get(index).build();
  }
  public LocalObjectReference buildFirstAdditionalCertificateAuthority() {
    return this.additionalCertificateAuthorities.get(0).build();
  }
  public LocalObjectReference buildLastAdditionalCertificateAuthority() {
    return this.additionalCertificateAuthorities.get(additionalCertificateAuthorities.size() - 1).build();
  }
  public LocalObjectReference buildMatchingAdditionalCertificateAuthority(Predicate<LocalObjectReferenceBuilder> predicate) {
    for (LocalObjectReferenceBuilder item: additionalCertificateAuthorities) { if(predicate.test(item)){ return item.build();} } return null;
  }
  public Boolean hasMatchingAdditionalCertificateAuthority(Predicate<LocalObjectReferenceBuilder> predicate) {
    for (LocalObjectReferenceBuilder item: additionalCertificateAuthorities) { if(predicate.test(item)){ return true;} } return false;
  }
  public A withAdditionalCertificateAuthorities(List<LocalObjectReference> additionalCertificateAuthorities) {
    if (this.additionalCertificateAuthorities != null) { _visitables.get("additionalCertificateAuthorities").clear();}
    if (additionalCertificateAuthorities != null) {this.additionalCertificateAuthorities = new ArrayList(); for (LocalObjectReference item : additionalCertificateAuthorities){this.addToAdditionalCertificateAuthorities(item);}} else { this.additionalCertificateAuthorities = null;} return (A) this;
  }
  public A withAdditionalCertificateAuthorities(io.fabric8.kubernetes.api.model.LocalObjectReference... additionalCertificateAuthorities) {
    if (this.additionalCertificateAuthorities != null) {this.additionalCertificateAuthorities.clear(); _visitables.remove("additionalCertificateAuthorities"); }
    if (additionalCertificateAuthorities != null) {for (LocalObjectReference item :additionalCertificateAuthorities){ this.addToAdditionalCertificateAuthorities(item);}} return (A) this;
  }
  public Boolean hasAdditionalCertificateAuthorities() {
    return additionalCertificateAuthorities != null && !additionalCertificateAuthorities.isEmpty();
  }
  public A addNewAdditionalCertificateAuthority(String name) {
    return (A)addToAdditionalCertificateAuthorities(new LocalObjectReference(name));
  }
  public HiveConfigSpecFluentImpl.AdditionalCertificateAuthoritiesNested<A> addNewAdditionalCertificateAuthority() {
    return new HiveConfigSpecFluentImpl.AdditionalCertificateAuthoritiesNestedImpl();
  }
  public HiveConfigSpecFluentImpl.AdditionalCertificateAuthoritiesNested<A> addNewAdditionalCertificateAuthorityLike(LocalObjectReference item) {
    return new HiveConfigSpecFluentImpl.AdditionalCertificateAuthoritiesNestedImpl(-1, item);
  }
  public HiveConfigSpecFluentImpl.AdditionalCertificateAuthoritiesNested<A> setNewAdditionalCertificateAuthorityLike(int index,LocalObjectReference item) {
    return new HiveConfigSpecFluentImpl.AdditionalCertificateAuthoritiesNestedImpl(index, item);
  }
  public HiveConfigSpecFluentImpl.AdditionalCertificateAuthoritiesNested<A> editAdditionalCertificateAuthority(int index) {
    if (additionalCertificateAuthorities.size() <= index) throw new RuntimeException("Can't edit additionalCertificateAuthorities. Index exceeds size.");
    return setNewAdditionalCertificateAuthorityLike(index, buildAdditionalCertificateAuthority(index));
  }
  public HiveConfigSpecFluentImpl.AdditionalCertificateAuthoritiesNested<A> editFirstAdditionalCertificateAuthority() {
    if (additionalCertificateAuthorities.size() == 0) throw new RuntimeException("Can't edit first additionalCertificateAuthorities. The list is empty.");
    return setNewAdditionalCertificateAuthorityLike(0, buildAdditionalCertificateAuthority(0));
  }
  public HiveConfigSpecFluentImpl.AdditionalCertificateAuthoritiesNested<A> editLastAdditionalCertificateAuthority() {
    int index = additionalCertificateAuthorities.size() - 1;
    if (index < 0) throw new RuntimeException("Can't edit last additionalCertificateAuthorities. The list is empty.");
    return setNewAdditionalCertificateAuthorityLike(index, buildAdditionalCertificateAuthority(index));
  }
  public HiveConfigSpecFluentImpl.AdditionalCertificateAuthoritiesNested<A> editMatchingAdditionalCertificateAuthority(Predicate<LocalObjectReferenceBuilder> predicate) {
    int index = -1;
    for (int i=0;i<additionalCertificateAuthorities.size();i++) { 
    if (predicate.test(additionalCertificateAuthorities.get(i))) {index = i; break;}
    } 
    if (index < 0) throw new RuntimeException("Can't edit matching additionalCertificateAuthorities. No match found.");
    return setNewAdditionalCertificateAuthorityLike(index, buildAdditionalCertificateAuthority(index));
  }
  
  /**
   * This method has been deprecated, please use method buildBackup instead.
   * @return The buildable object.
   */
  @Deprecated
  public BackupConfig getBackup() {
    return this.backup!=null ?this.backup.build():null;
  }
  public BackupConfig buildBackup() {
    return this.backup!=null ?this.backup.build():null;
  }
  public A withBackup(BackupConfig backup) {
    _visitables.get("backup").remove(this.backup);
    if (backup!=null){ this.backup= new BackupConfigBuilder(backup); _visitables.get("backup").add(this.backup);} else { this.backup = null; _visitables.get("backup").remove(this.backup); } return (A) this;
  }
  public Boolean hasBackup() {
    return this.backup != null;
  }
  public HiveConfigSpecFluentImpl.BackupNested<A> withNewBackup() {
    return new HiveConfigSpecFluentImpl.BackupNestedImpl();
  }
  public HiveConfigSpecFluentImpl.BackupNested<A> withNewBackupLike(BackupConfig item) {
    return new HiveConfigSpecFluentImpl.BackupNestedImpl(item);
  }
  public HiveConfigSpecFluentImpl.BackupNested<A> editBackup() {
    return withNewBackupLike(getBackup());
  }
  public HiveConfigSpecFluentImpl.BackupNested<A> editOrNewBackup() {
    return withNewBackupLike(getBackup() != null ? getBackup(): new BackupConfigBuilder().build());
  }
  public HiveConfigSpecFluentImpl.BackupNested<A> editOrNewBackupLike(BackupConfig item) {
    return withNewBackupLike(getBackup() != null ? getBackup(): item);
  }
  
  /**
   * This method has been deprecated, please use method buildExternalDNS instead.
   * @return The buildable object.
   */
  @Deprecated
  public ExternalDNSConfig getExternalDNS() {
    return this.externalDNS!=null ?this.externalDNS.build():null;
  }
  public ExternalDNSConfig buildExternalDNS() {
    return this.externalDNS!=null ?this.externalDNS.build():null;
  }
  public A withExternalDNS(ExternalDNSConfig externalDNS) {
    _visitables.get("externalDNS").remove(this.externalDNS);
    if (externalDNS!=null){ this.externalDNS= new ExternalDNSConfigBuilder(externalDNS); _visitables.get("externalDNS").add(this.externalDNS);} else { this.externalDNS = null; _visitables.get("externalDNS").remove(this.externalDNS); } return (A) this;
  }
  public Boolean hasExternalDNS() {
    return this.externalDNS != null;
  }
  public HiveConfigSpecFluentImpl.ExternalDNSNested<A> withNewExternalDNS() {
    return new HiveConfigSpecFluentImpl.ExternalDNSNestedImpl();
  }
  public HiveConfigSpecFluentImpl.ExternalDNSNested<A> withNewExternalDNSLike(ExternalDNSConfig item) {
    return new HiveConfigSpecFluentImpl.ExternalDNSNestedImpl(item);
  }
  public HiveConfigSpecFluentImpl.ExternalDNSNested<A> editExternalDNS() {
    return withNewExternalDNSLike(getExternalDNS());
  }
  public HiveConfigSpecFluentImpl.ExternalDNSNested<A> editOrNewExternalDNS() {
    return withNewExternalDNSLike(getExternalDNS() != null ? getExternalDNS(): new ExternalDNSConfigBuilder().build());
  }
  public HiveConfigSpecFluentImpl.ExternalDNSNested<A> editOrNewExternalDNSLike(ExternalDNSConfig item) {
    return withNewExternalDNSLike(getExternalDNS() != null ? getExternalDNS(): item);
  }
  
  /**
   * This method has been deprecated, please use method buildFailedProvisionConfig instead.
   * @return The buildable object.
   */
  @Deprecated
  public FailedProvisionConfig getFailedProvisionConfig() {
    return this.failedProvisionConfig!=null ?this.failedProvisionConfig.build():null;
  }
  public FailedProvisionConfig buildFailedProvisionConfig() {
    return this.failedProvisionConfig!=null ?this.failedProvisionConfig.build():null;
  }
  public A withFailedProvisionConfig(FailedProvisionConfig failedProvisionConfig) {
    _visitables.get("failedProvisionConfig").remove(this.failedProvisionConfig);
    if (failedProvisionConfig!=null){ this.failedProvisionConfig= new FailedProvisionConfigBuilder(failedProvisionConfig); _visitables.get("failedProvisionConfig").add(this.failedProvisionConfig);} else { this.failedProvisionConfig = null; _visitables.get("failedProvisionConfig").remove(this.failedProvisionConfig); } return (A) this;
  }
  public Boolean hasFailedProvisionConfig() {
    return this.failedProvisionConfig != null;
  }
  public A withNewFailedProvisionConfig(Boolean skipGatherLogs) {
    return (A)withFailedProvisionConfig(new FailedProvisionConfig(skipGatherLogs));
  }
  public HiveConfigSpecFluentImpl.FailedProvisionConfigNested<A> withNewFailedProvisionConfig() {
    return new HiveConfigSpecFluentImpl.FailedProvisionConfigNestedImpl();
  }
  public HiveConfigSpecFluentImpl.FailedProvisionConfigNested<A> withNewFailedProvisionConfigLike(FailedProvisionConfig item) {
    return new HiveConfigSpecFluentImpl.FailedProvisionConfigNestedImpl(item);
  }
  public HiveConfigSpecFluentImpl.FailedProvisionConfigNested<A> editFailedProvisionConfig() {
    return withNewFailedProvisionConfigLike(getFailedProvisionConfig());
  }
  public HiveConfigSpecFluentImpl.FailedProvisionConfigNested<A> editOrNewFailedProvisionConfig() {
    return withNewFailedProvisionConfigLike(getFailedProvisionConfig() != null ? getFailedProvisionConfig(): new FailedProvisionConfigBuilder().build());
  }
  public HiveConfigSpecFluentImpl.FailedProvisionConfigNested<A> editOrNewFailedProvisionConfigLike(FailedProvisionConfig item) {
    return withNewFailedProvisionConfigLike(getFailedProvisionConfig() != null ? getFailedProvisionConfig(): item);
  }
  
  /**
   * This method has been deprecated, please use method buildGlobalPullSecret instead.
   * @return The buildable object.
   */
  @Deprecated
  public LocalObjectReference getGlobalPullSecret() {
    return this.globalPullSecret!=null ?this.globalPullSecret.build():null;
  }
  public LocalObjectReference buildGlobalPullSecret() {
    return this.globalPullSecret!=null ?this.globalPullSecret.build():null;
  }
  public A withGlobalPullSecret(LocalObjectReference globalPullSecret) {
    _visitables.get("globalPullSecret").remove(this.globalPullSecret);
    if (globalPullSecret!=null){ this.globalPullSecret= new LocalObjectReferenceBuilder(globalPullSecret); _visitables.get("globalPullSecret").add(this.globalPullSecret);} else { this.globalPullSecret = null; _visitables.get("globalPullSecret").remove(this.globalPullSecret); } return (A) this;
  }
  public Boolean hasGlobalPullSecret() {
    return this.globalPullSecret != null;
  }
  public A withNewGlobalPullSecret(String name) {
    return (A)withGlobalPullSecret(new LocalObjectReference(name));
  }
  public HiveConfigSpecFluentImpl.GlobalPullSecretNested<A> withNewGlobalPullSecret() {
    return new HiveConfigSpecFluentImpl.GlobalPullSecretNestedImpl();
  }
  public HiveConfigSpecFluentImpl.GlobalPullSecretNested<A> withNewGlobalPullSecretLike(LocalObjectReference item) {
    return new HiveConfigSpecFluentImpl.GlobalPullSecretNestedImpl(item);
  }
  public HiveConfigSpecFluentImpl.GlobalPullSecretNested<A> editGlobalPullSecret() {
    return withNewGlobalPullSecretLike(getGlobalPullSecret());
  }
  public HiveConfigSpecFluentImpl.GlobalPullSecretNested<A> editOrNewGlobalPullSecret() {
    return withNewGlobalPullSecretLike(getGlobalPullSecret() != null ? getGlobalPullSecret(): new LocalObjectReferenceBuilder().build());
  }
  public HiveConfigSpecFluentImpl.GlobalPullSecretNested<A> editOrNewGlobalPullSecretLike(LocalObjectReference item) {
    return withNewGlobalPullSecretLike(getGlobalPullSecret() != null ? getGlobalPullSecret(): item);
  }
  public Boolean getMaintenanceMode() {
    return this.maintenanceMode;
  }
  public A withMaintenanceMode(Boolean maintenanceMode) {
    this.maintenanceMode=maintenanceMode; return (A) this;
  }
  public Boolean hasMaintenanceMode() {
    return this.maintenanceMode != null;
  }
  public boolean equals(Object o) {
    if (this == o) return true;
    if (o == null || getClass() != o.getClass()) return false;
    if (!super.equals(o)) return false;
    HiveConfigSpecFluentImpl that = (HiveConfigSpecFluentImpl) o;
    if (!java.util.Objects.equals(additionalCertificateAuthorities, that.additionalCertificateAuthorities)) return false;

    if (!java.util.Objects.equals(backup, that.backup)) return false;

    if (!java.util.Objects.equals(externalDNS, that.externalDNS)) return false;

    if (!java.util.Objects.equals(failedProvisionConfig, that.failedProvisionConfig)) return false;

    if (!java.util.Objects.equals(globalPullSecret, that.globalPullSecret)) return false;

    if (!java.util.Objects.equals(maintenanceMode, that.maintenanceMode)) return false;

    return true;
  }
  public int hashCode() {
    return java.util.Objects.hash(additionalCertificateAuthorities,  backup,  externalDNS,  failedProvisionConfig,  globalPullSecret,  maintenanceMode,  super.hashCode());
  }
  public String toString() {
    StringBuilder sb = new StringBuilder();
    sb.append("{");
    if (additionalCertificateAuthorities != null) { sb.append("additionalCertificateAuthorities:"); sb.append(additionalCertificateAuthorities + ","); }
    if (backup != null) { sb.append("backup:"); sb.append(backup + ","); }
    if (externalDNS != null) { sb.append("externalDNS:"); sb.append(externalDNS + ","); }
    if (failedProvisionConfig != null) { sb.append("failedProvisionConfig:"); sb.append(failedProvisionConfig + ","); }
    if (globalPullSecret != null) { sb.append("globalPullSecret:"); sb.append(globalPullSecret + ","); }
    if (maintenanceMode != null) { sb.append("maintenanceMode:"); sb.append(maintenanceMode); }
    sb.append("}");
    return sb.toString();
  }
  public A withMaintenanceMode() {
    return withMaintenanceMode(true);
  }
  class AdditionalCertificateAuthoritiesNestedImpl<N> extends LocalObjectReferenceFluentImpl<HiveConfigSpecFluentImpl.AdditionalCertificateAuthoritiesNested<N>> implements HiveConfigSpecFluentImpl.AdditionalCertificateAuthoritiesNested<N>,Nested<N>{
    AdditionalCertificateAuthoritiesNestedImpl(int index,LocalObjectReference item) {
      this.index = index;
      this.builder = new LocalObjectReferenceBuilder(this, item);
    }
    AdditionalCertificateAuthoritiesNestedImpl() {
      this.index = -1;
      this.builder = new LocalObjectReferenceBuilder(this);
    }
    LocalObjectReferenceBuilder builder;
    int index;
    public N and() {
      return (N) HiveConfigSpecFluentImpl.this.setToAdditionalCertificateAuthorities(index,builder.build());
    }
    public N endAdditionalCertificateAuthority() {
      return and();
    }
    
  }
  class BackupNestedImpl<N> extends BackupConfigFluentImpl<HiveConfigSpecFluentImpl.BackupNested<N>> implements HiveConfigSpecFluentImpl.BackupNested<N>,Nested<N>{
    BackupNestedImpl(BackupConfig item) {
      this.builder = new BackupConfigBuilder(this, item);
    }
    BackupNestedImpl() {
      this.builder = new BackupConfigBuilder(this);
    }
    BackupConfigBuilder builder;
    public N and() {
      return (N) HiveConfigSpecFluentImpl.this.withBackup(builder.build());
    }
    public N endBackup() {
      return and();
    }
    
  }
  class ExternalDNSNestedImpl<N> extends ExternalDNSConfigFluentImpl<HiveConfigSpecFluentImpl.ExternalDNSNested<N>> implements HiveConfigSpecFluentImpl.ExternalDNSNested<N>,Nested<N>{
    ExternalDNSNestedImpl(ExternalDNSConfig item) {
      this.builder = new ExternalDNSConfigBuilder(this, item);
    }
    ExternalDNSNestedImpl() {
      this.builder = new ExternalDNSConfigBuilder(this);
    }
    ExternalDNSConfigBuilder builder;
    public N and() {
      return (N) HiveConfigSpecFluentImpl.this.withExternalDNS(builder.build());
    }
    public N endExternalDNS() {
      return and();
    }
    
  }
  class FailedProvisionConfigNestedImpl<N> extends FailedProvisionConfigFluentImpl<HiveConfigSpecFluentImpl.FailedProvisionConfigNested<N>> implements HiveConfigSpecFluentImpl.FailedProvisionConfigNested<N>,Nested<N>{
    FailedProvisionConfigNestedImpl(FailedProvisionConfig item) {
      this.builder = new FailedProvisionConfigBuilder(this, item);
    }
    FailedProvisionConfigNestedImpl() {
      this.builder = new FailedProvisionConfigBuilder(this);
    }
    FailedProvisionConfigBuilder builder;
    public N and() {
      return (N) HiveConfigSpecFluentImpl.this.withFailedProvisionConfig(builder.build());
    }
    public N endFailedProvisionConfig() {
      return and();
    }
    
  }
  class GlobalPullSecretNestedImpl<N> extends LocalObjectReferenceFluentImpl<HiveConfigSpecFluentImpl.GlobalPullSecretNested<N>> implements HiveConfigSpecFluentImpl.GlobalPullSecretNested<N>,Nested<N>{
    GlobalPullSecretNestedImpl(LocalObjectReference item) {
      this.builder = new LocalObjectReferenceBuilder(this, item);
    }
    GlobalPullSecretNestedImpl() {
      this.builder = new LocalObjectReferenceBuilder(this);
    }
    LocalObjectReferenceBuilder builder;
    public N and() {
      return (N) HiveConfigSpecFluentImpl.this.withGlobalPullSecret(builder.build());
    }
    public N endGlobalPullSecret() {
      return and();
    }
    
  }
  
}