package io.fabric8.openclustermanagement.api.model.multiclusterhub.operator.v1;

import io.fabric8.kubernetes.api.builder.VisitableBuilder;
import java.lang.Boolean;
public class ExternalDNSConfigBuilder extends ExternalDNSConfigFluentImpl<ExternalDNSConfigBuilder> implements VisitableBuilder<ExternalDNSConfig,ExternalDNSConfigBuilder>{
  public ExternalDNSConfigBuilder() {
    this(false);
  }
  public ExternalDNSConfigBuilder(Boolean validationEnabled) {
    this(new ExternalDNSConfig(), validationEnabled);
  }
  public ExternalDNSConfigBuilder(ExternalDNSConfigFluent<?> fluent) {
    this(fluent, false);
  }
  public ExternalDNSConfigBuilder(ExternalDNSConfigFluent<?> fluent,Boolean validationEnabled) {
    this(fluent, new ExternalDNSConfig(), validationEnabled);
  }
  public ExternalDNSConfigBuilder(ExternalDNSConfigFluent<?> fluent,ExternalDNSConfig instance) {
    this(fluent, instance, false);
  }
  public ExternalDNSConfigBuilder(ExternalDNSConfigFluent<?> fluent,ExternalDNSConfig instance,Boolean validationEnabled) {
    this.fluent = fluent; 
    if (instance != null) {
      fluent.withAws(instance.getAws());
      fluent.withGcp(instance.getGcp());
    }
    this.validationEnabled = validationEnabled; 
  }
  public ExternalDNSConfigBuilder(ExternalDNSConfig instance) {
    this(instance,false);
  }
  public ExternalDNSConfigBuilder(ExternalDNSConfig instance,Boolean validationEnabled) {
    this.fluent = this; 
    if (instance != null) {
      this.withAws(instance.getAws());
      this.withGcp(instance.getGcp());
    }
    this.validationEnabled = validationEnabled; 
  }
  ExternalDNSConfigFluent<?> fluent;
  Boolean validationEnabled;
  public ExternalDNSConfig build() {
    ExternalDNSConfig buildable = new ExternalDNSConfig(fluent.getAws(),fluent.getGcp());
    return buildable;
  }
  
}