/*
 * Decompiled with CFR 0.152.
 */
package io.fabric8.openclustermanagement.api.model.multiclusterhub.operator.v1;

import io.fabric8.kubernetes.api.builder.BaseFluent;
import io.fabric8.kubernetes.api.builder.Nested;
import io.fabric8.openclustermanagement.api.model.multiclusterhub.operator.v1.BackupConfig;
import io.fabric8.openclustermanagement.api.model.multiclusterhub.operator.v1.BackupConfigFluent;
import io.fabric8.openclustermanagement.api.model.multiclusterhub.operator.v1.VeleroBackupConfig;
import io.fabric8.openclustermanagement.api.model.multiclusterhub.operator.v1.VeleroBackupConfigBuilder;
import io.fabric8.openclustermanagement.api.model.multiclusterhub.operator.v1.VeleroBackupConfigFluentImpl;
import java.util.Objects;

public class BackupConfigFluentImpl<A extends BackupConfigFluent<A>>
extends BaseFluent<A>
implements BackupConfigFluent<A> {
    private Integer minBackupPeriodSeconds;
    private VeleroBackupConfigBuilder velero;

    public BackupConfigFluentImpl() {
    }

    public BackupConfigFluentImpl(BackupConfig instance) {
        if (instance != null) {
            this.withMinBackupPeriodSeconds(instance.getMinBackupPeriodSeconds());
            this.withVelero(instance.getVelero());
        }
    }

    @Override
    public Integer getMinBackupPeriodSeconds() {
        return this.minBackupPeriodSeconds;
    }

    @Override
    public A withMinBackupPeriodSeconds(Integer minBackupPeriodSeconds) {
        this.minBackupPeriodSeconds = minBackupPeriodSeconds;
        return (A)this;
    }

    @Override
    public Boolean hasMinBackupPeriodSeconds() {
        return this.minBackupPeriodSeconds != null;
    }

    @Override
    @Deprecated
    public VeleroBackupConfig getVelero() {
        return this.velero != null ? this.velero.build() : null;
    }

    @Override
    public VeleroBackupConfig buildVelero() {
        return this.velero != null ? this.velero.build() : null;
    }

    @Override
    public A withVelero(VeleroBackupConfig velero) {
        this._visitables.get((Object)"velero").remove(this.velero);
        if (velero != null) {
            this.velero = new VeleroBackupConfigBuilder(velero);
            this._visitables.get((Object)"velero").add(this.velero);
        } else {
            this.velero = null;
            this._visitables.get((Object)"velero").remove(this.velero);
        }
        return (A)this;
    }

    @Override
    public Boolean hasVelero() {
        return this.velero != null;
    }

    @Override
    public A withNewVelero(Boolean enabled) {
        return this.withVelero(new VeleroBackupConfig(enabled));
    }

    @Override
    public BackupConfigFluent.VeleroNested<A> withNewVelero() {
        return new VeleroNestedImpl();
    }

    @Override
    public BackupConfigFluent.VeleroNested<A> withNewVeleroLike(VeleroBackupConfig item) {
        return new VeleroNestedImpl(item);
    }

    @Override
    public BackupConfigFluent.VeleroNested<A> editVelero() {
        return this.withNewVeleroLike(this.getVelero());
    }

    @Override
    public BackupConfigFluent.VeleroNested<A> editOrNewVelero() {
        return this.withNewVeleroLike(this.getVelero() != null ? this.getVelero() : new VeleroBackupConfigBuilder().build());
    }

    @Override
    public BackupConfigFluent.VeleroNested<A> editOrNewVeleroLike(VeleroBackupConfig item) {
        return this.withNewVeleroLike(this.getVelero() != null ? this.getVelero() : item);
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        if (!super.equals(o)) {
            return false;
        }
        BackupConfigFluentImpl that = (BackupConfigFluentImpl)o;
        if (!Objects.equals(this.minBackupPeriodSeconds, that.minBackupPeriodSeconds)) {
            return false;
        }
        return Objects.equals(this.velero, that.velero);
    }

    public int hashCode() {
        return Objects.hash(this.minBackupPeriodSeconds, this.velero, super.hashCode());
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("{");
        if (this.minBackupPeriodSeconds != null) {
            sb.append("minBackupPeriodSeconds:");
            sb.append(this.minBackupPeriodSeconds + ",");
        }
        if (this.velero != null) {
            sb.append("velero:");
            sb.append(this.velero);
        }
        sb.append("}");
        return sb.toString();
    }

    class VeleroNestedImpl<N>
    extends VeleroBackupConfigFluentImpl<BackupConfigFluent.VeleroNested<N>>
    implements BackupConfigFluent.VeleroNested<N>,
    Nested<N> {
        VeleroBackupConfigBuilder builder;

        VeleroNestedImpl(VeleroBackupConfig item) {
            this.builder = new VeleroBackupConfigBuilder(this, item);
        }

        VeleroNestedImpl() {
            this.builder = new VeleroBackupConfigBuilder(this);
        }

        @Override
        public N and() {
            return (N)BackupConfigFluentImpl.this.withVelero(this.builder.build());
        }

        @Override
        public N endVelero() {
            return this.and();
        }
    }
}

