package io.fabric8.openclustermanagement.api.model.operator.v1;

import io.fabric8.kubernetes.api.builder.VisitableBuilder;
import java.lang.SuppressWarnings;
import io.fabric8.kubernetes.api.builder.Nested;
import java.util.ArrayList;
import java.lang.String;
import java.util.function.Predicate;
import java.lang.Deprecated;
import io.fabric8.kubernetes.api.builder.BaseFluent;
import java.util.Iterator;
import java.util.List;
import java.lang.Boolean;
import java.util.Collection;
import java.lang.Object;

 /**
  * Generated
  */
  @SuppressWarnings(value = "unchecked")
  public class KlusterletSpecFluentImpl<A extends KlusterletSpecFluent<A>> extends BaseFluent<A> implements KlusterletSpecFluent<A>{
  public KlusterletSpecFluentImpl() {
  }
  public KlusterletSpecFluentImpl(KlusterletSpec instance) {
    if (instance != null) {
      this.withClusterName(instance.getClusterName());
      this.withExternalServerURLs(instance.getExternalServerURLs());
      this.withNamespace(instance.getNamespace());
      this.withNodePlacement(instance.getNodePlacement());
      this.withRegistrationImagePullSpec(instance.getRegistrationImagePullSpec());
      this.withWorkImagePullSpec(instance.getWorkImagePullSpec());
    }
  }
  private String clusterName;
  private ArrayList<ServerURLBuilder> externalServerURLs = new ArrayList<ServerURLBuilder>();
  private String namespace;
  private NodePlacementBuilder nodePlacement;
  private String registrationImagePullSpec;
  private String workImagePullSpec;
  public String getClusterName() {
    return this.clusterName;
  }
  public A withClusterName(String clusterName) {
    this.clusterName=clusterName; return (A) this;
  }
  public Boolean hasClusterName() {
    return this.clusterName != null;
  }
  public A addToExternalServerURLs(int index,ServerURL item) {
    if (this.externalServerURLs == null) {this.externalServerURLs = new ArrayList<ServerURLBuilder>();}
    ServerURLBuilder builder = new ServerURLBuilder(item);
    if (index < 0 || index >= externalServerURLs.size()) { _visitables.get("externalServerURLs").add(builder); externalServerURLs.add(builder); } else { _visitables.get("externalServerURLs").add(index, builder); externalServerURLs.add(index, builder);}
    return (A)this;
  }
  public A setToExternalServerURLs(int index,ServerURL item) {
    if (this.externalServerURLs == null) {this.externalServerURLs = new ArrayList<ServerURLBuilder>();}
    ServerURLBuilder builder = new ServerURLBuilder(item);
    if (index < 0 || index >= externalServerURLs.size()) { _visitables.get("externalServerURLs").add(builder); externalServerURLs.add(builder); } else { _visitables.get("externalServerURLs").set(index, builder); externalServerURLs.set(index, builder);}
    return (A)this;
  }
  public A addToExternalServerURLs(io.fabric8.openclustermanagement.api.model.operator.v1.ServerURL... items) {
    if (this.externalServerURLs == null) {this.externalServerURLs = new ArrayList<ServerURLBuilder>();}
    for (ServerURL item : items) {ServerURLBuilder builder = new ServerURLBuilder(item);_visitables.get("externalServerURLs").add(builder);this.externalServerURLs.add(builder);} return (A)this;
  }
  public A addAllToExternalServerURLs(Collection<ServerURL> items) {
    if (this.externalServerURLs == null) {this.externalServerURLs = new ArrayList<ServerURLBuilder>();}
    for (ServerURL item : items) {ServerURLBuilder builder = new ServerURLBuilder(item);_visitables.get("externalServerURLs").add(builder);this.externalServerURLs.add(builder);} return (A)this;
  }
  public A removeFromExternalServerURLs(io.fabric8.openclustermanagement.api.model.operator.v1.ServerURL... items) {
    for (ServerURL item : items) {ServerURLBuilder builder = new ServerURLBuilder(item);_visitables.get("externalServerURLs").remove(builder);if (this.externalServerURLs != null) {this.externalServerURLs.remove(builder);}} return (A)this;
  }
  public A removeAllFromExternalServerURLs(Collection<ServerURL> items) {
    for (ServerURL item : items) {ServerURLBuilder builder = new ServerURLBuilder(item);_visitables.get("externalServerURLs").remove(builder);if (this.externalServerURLs != null) {this.externalServerURLs.remove(builder);}} return (A)this;
  }
  public A removeMatchingFromExternalServerURLs(Predicate<ServerURLBuilder> predicate) {
    if (externalServerURLs == null) return (A) this;
    final Iterator<ServerURLBuilder> each = externalServerURLs.iterator();
    final List visitables = _visitables.get("externalServerURLs");
    while (each.hasNext()) {
      ServerURLBuilder builder = each.next();
      if (predicate.test(builder)) {
        visitables.remove(builder);
        each.remove();
      }
    }
    return (A)this;
  }
  
  /**
   * This method has been deprecated, please use method buildExternalServerURLs instead.
   * @return The buildable object.
   */
  @Deprecated
  public List<ServerURL> getExternalServerURLs() {
    return externalServerURLs != null ? build(externalServerURLs) : null;
  }
  public List<ServerURL> buildExternalServerURLs() {
    return externalServerURLs != null ? build(externalServerURLs) : null;
  }
  public ServerURL buildExternalServerURL(int index) {
    return this.externalServerURLs.get(index).build();
  }
  public ServerURL buildFirstExternalServerURL() {
    return this.externalServerURLs.get(0).build();
  }
  public ServerURL buildLastExternalServerURL() {
    return this.externalServerURLs.get(externalServerURLs.size() - 1).build();
  }
  public ServerURL buildMatchingExternalServerURL(Predicate<ServerURLBuilder> predicate) {
    for (ServerURLBuilder item: externalServerURLs) { if(predicate.test(item)){ return item.build();} } return null;
  }
  public Boolean hasMatchingExternalServerURL(Predicate<ServerURLBuilder> predicate) {
    for (ServerURLBuilder item: externalServerURLs) { if(predicate.test(item)){ return true;} } return false;
  }
  public A withExternalServerURLs(List<ServerURL> externalServerURLs) {
    if (this.externalServerURLs != null) { _visitables.get("externalServerURLs").clear();}
    if (externalServerURLs != null) {this.externalServerURLs = new ArrayList(); for (ServerURL item : externalServerURLs){this.addToExternalServerURLs(item);}} else { this.externalServerURLs = null;} return (A) this;
  }
  public A withExternalServerURLs(io.fabric8.openclustermanagement.api.model.operator.v1.ServerURL... externalServerURLs) {
    if (this.externalServerURLs != null) {this.externalServerURLs.clear(); _visitables.remove("externalServerURLs"); }
    if (externalServerURLs != null) {for (ServerURL item :externalServerURLs){ this.addToExternalServerURLs(item);}} return (A) this;
  }
  public Boolean hasExternalServerURLs() {
    return externalServerURLs != null && !externalServerURLs.isEmpty();
  }
  public A addNewExternalServerURL(String caBundle,String url) {
    return (A)addToExternalServerURLs(new ServerURL(caBundle, url));
  }
  public KlusterletSpecFluentImpl.ExternalServerURLsNested<A> addNewExternalServerURL() {
    return new KlusterletSpecFluentImpl.ExternalServerURLsNestedImpl();
  }
  public KlusterletSpecFluentImpl.ExternalServerURLsNested<A> addNewExternalServerURLLike(ServerURL item) {
    return new KlusterletSpecFluentImpl.ExternalServerURLsNestedImpl(-1, item);
  }
  public KlusterletSpecFluentImpl.ExternalServerURLsNested<A> setNewExternalServerURLLike(int index,ServerURL item) {
    return new KlusterletSpecFluentImpl.ExternalServerURLsNestedImpl(index, item);
  }
  public KlusterletSpecFluentImpl.ExternalServerURLsNested<A> editExternalServerURL(int index) {
    if (externalServerURLs.size() <= index) throw new RuntimeException("Can't edit externalServerURLs. Index exceeds size.");
    return setNewExternalServerURLLike(index, buildExternalServerURL(index));
  }
  public KlusterletSpecFluentImpl.ExternalServerURLsNested<A> editFirstExternalServerURL() {
    if (externalServerURLs.size() == 0) throw new RuntimeException("Can't edit first externalServerURLs. The list is empty.");
    return setNewExternalServerURLLike(0, buildExternalServerURL(0));
  }
  public KlusterletSpecFluentImpl.ExternalServerURLsNested<A> editLastExternalServerURL() {
    int index = externalServerURLs.size() - 1;
    if (index < 0) throw new RuntimeException("Can't edit last externalServerURLs. The list is empty.");
    return setNewExternalServerURLLike(index, buildExternalServerURL(index));
  }
  public KlusterletSpecFluentImpl.ExternalServerURLsNested<A> editMatchingExternalServerURL(Predicate<ServerURLBuilder> predicate) {
    int index = -1;
    for (int i=0;i<externalServerURLs.size();i++) { 
    if (predicate.test(externalServerURLs.get(i))) {index = i; break;}
    } 
    if (index < 0) throw new RuntimeException("Can't edit matching externalServerURLs. No match found.");
    return setNewExternalServerURLLike(index, buildExternalServerURL(index));
  }
  public String getNamespace() {
    return this.namespace;
  }
  public A withNamespace(String namespace) {
    this.namespace=namespace; return (A) this;
  }
  public Boolean hasNamespace() {
    return this.namespace != null;
  }
  
  /**
   * This method has been deprecated, please use method buildNodePlacement instead.
   * @return The buildable object.
   */
  @Deprecated
  public NodePlacement getNodePlacement() {
    return this.nodePlacement!=null ?this.nodePlacement.build():null;
  }
  public NodePlacement buildNodePlacement() {
    return this.nodePlacement!=null ?this.nodePlacement.build():null;
  }
  public A withNodePlacement(NodePlacement nodePlacement) {
    _visitables.get("nodePlacement").remove(this.nodePlacement);
    if (nodePlacement!=null){ this.nodePlacement= new NodePlacementBuilder(nodePlacement); _visitables.get("nodePlacement").add(this.nodePlacement);} else { this.nodePlacement = null; _visitables.get("nodePlacement").remove(this.nodePlacement); } return (A) this;
  }
  public Boolean hasNodePlacement() {
    return this.nodePlacement != null;
  }
  public KlusterletSpecFluentImpl.NodePlacementNested<A> withNewNodePlacement() {
    return new KlusterletSpecFluentImpl.NodePlacementNestedImpl();
  }
  public KlusterletSpecFluentImpl.NodePlacementNested<A> withNewNodePlacementLike(NodePlacement item) {
    return new KlusterletSpecFluentImpl.NodePlacementNestedImpl(item);
  }
  public KlusterletSpecFluentImpl.NodePlacementNested<A> editNodePlacement() {
    return withNewNodePlacementLike(getNodePlacement());
  }
  public KlusterletSpecFluentImpl.NodePlacementNested<A> editOrNewNodePlacement() {
    return withNewNodePlacementLike(getNodePlacement() != null ? getNodePlacement(): new NodePlacementBuilder().build());
  }
  public KlusterletSpecFluentImpl.NodePlacementNested<A> editOrNewNodePlacementLike(NodePlacement item) {
    return withNewNodePlacementLike(getNodePlacement() != null ? getNodePlacement(): item);
  }
  public String getRegistrationImagePullSpec() {
    return this.registrationImagePullSpec;
  }
  public A withRegistrationImagePullSpec(String registrationImagePullSpec) {
    this.registrationImagePullSpec=registrationImagePullSpec; return (A) this;
  }
  public Boolean hasRegistrationImagePullSpec() {
    return this.registrationImagePullSpec != null;
  }
  public String getWorkImagePullSpec() {
    return this.workImagePullSpec;
  }
  public A withWorkImagePullSpec(String workImagePullSpec) {
    this.workImagePullSpec=workImagePullSpec; return (A) this;
  }
  public Boolean hasWorkImagePullSpec() {
    return this.workImagePullSpec != null;
  }
  public boolean equals(Object o) {
    if (this == o) return true;
    if (o == null || getClass() != o.getClass()) return false;
    if (!super.equals(o)) return false;
    KlusterletSpecFluentImpl that = (KlusterletSpecFluentImpl) o;
    if (!java.util.Objects.equals(clusterName, that.clusterName)) return false;

    if (!java.util.Objects.equals(externalServerURLs, that.externalServerURLs)) return false;

    if (!java.util.Objects.equals(namespace, that.namespace)) return false;

    if (!java.util.Objects.equals(nodePlacement, that.nodePlacement)) return false;

    if (!java.util.Objects.equals(registrationImagePullSpec, that.registrationImagePullSpec)) return false;

    if (!java.util.Objects.equals(workImagePullSpec, that.workImagePullSpec)) return false;

    return true;
  }
  public int hashCode() {
    return java.util.Objects.hash(clusterName,  externalServerURLs,  namespace,  nodePlacement,  registrationImagePullSpec,  workImagePullSpec,  super.hashCode());
  }
  public String toString() {
    StringBuilder sb = new StringBuilder();
    sb.append("{");
    if (clusterName != null) { sb.append("clusterName:"); sb.append(clusterName + ","); }
    if (externalServerURLs != null) { sb.append("externalServerURLs:"); sb.append(externalServerURLs + ","); }
    if (namespace != null) { sb.append("namespace:"); sb.append(namespace + ","); }
    if (nodePlacement != null) { sb.append("nodePlacement:"); sb.append(nodePlacement + ","); }
    if (registrationImagePullSpec != null) { sb.append("registrationImagePullSpec:"); sb.append(registrationImagePullSpec + ","); }
    if (workImagePullSpec != null) { sb.append("workImagePullSpec:"); sb.append(workImagePullSpec); }
    sb.append("}");
    return sb.toString();
  }
  class ExternalServerURLsNestedImpl<N> extends ServerURLFluentImpl<KlusterletSpecFluentImpl.ExternalServerURLsNested<N>> implements KlusterletSpecFluentImpl.ExternalServerURLsNested<N>,Nested<N>{
    ExternalServerURLsNestedImpl(int index,ServerURL item) {
      this.index = index;
      this.builder = new ServerURLBuilder(this, item);
    }
    ExternalServerURLsNestedImpl() {
      this.index = -1;
      this.builder = new ServerURLBuilder(this);
    }
    ServerURLBuilder builder;
    int index;
    public N and() {
      return (N) KlusterletSpecFluentImpl.this.setToExternalServerURLs(index,builder.build());
    }
    public N endExternalServerURL() {
      return and();
    }
    
  }
  class NodePlacementNestedImpl<N> extends NodePlacementFluentImpl<KlusterletSpecFluentImpl.NodePlacementNested<N>> implements KlusterletSpecFluentImpl.NodePlacementNested<N>,Nested<N>{
    NodePlacementNestedImpl(NodePlacement item) {
      this.builder = new NodePlacementBuilder(this, item);
    }
    NodePlacementNestedImpl() {
      this.builder = new NodePlacementBuilder(this);
    }
    NodePlacementBuilder builder;
    public N and() {
      return (N) KlusterletSpecFluentImpl.this.withNodePlacement(builder.build());
    }
    public N endNodePlacement() {
      return and();
    }
    
  }
  
}