package io.fabric8.openclustermanagement.api.model.operator.v1;

import io.fabric8.kubernetes.api.builder.VisitableBuilder;
import java.lang.Boolean;
public class GenerationStatusBuilder extends GenerationStatusFluentImpl<GenerationStatusBuilder> implements VisitableBuilder<GenerationStatus,GenerationStatusBuilder>{
  public GenerationStatusBuilder() {
    this(false);
  }
  public GenerationStatusBuilder(Boolean validationEnabled) {
    this(new GenerationStatus(), validationEnabled);
  }
  public GenerationStatusBuilder(GenerationStatusFluent<?> fluent) {
    this(fluent, false);
  }
  public GenerationStatusBuilder(GenerationStatusFluent<?> fluent,Boolean validationEnabled) {
    this(fluent, new GenerationStatus(), validationEnabled);
  }
  public GenerationStatusBuilder(GenerationStatusFluent<?> fluent,GenerationStatus instance) {
    this(fluent, instance, false);
  }
  public GenerationStatusBuilder(GenerationStatusFluent<?> fluent,GenerationStatus instance,Boolean validationEnabled) {
    this.fluent = fluent; 
    if (instance != null) {
      fluent.withGroup(instance.getGroup());
      fluent.withLastGeneration(instance.getLastGeneration());
      fluent.withName(instance.getName());
      fluent.withNamespace(instance.getNamespace());
      fluent.withResource(instance.getResource());
      fluent.withVersion(instance.getVersion());
    }
    this.validationEnabled = validationEnabled; 
  }
  public GenerationStatusBuilder(GenerationStatus instance) {
    this(instance,false);
  }
  public GenerationStatusBuilder(GenerationStatus instance,Boolean validationEnabled) {
    this.fluent = this; 
    if (instance != null) {
      this.withGroup(instance.getGroup());
      this.withLastGeneration(instance.getLastGeneration());
      this.withName(instance.getName());
      this.withNamespace(instance.getNamespace());
      this.withResource(instance.getResource());
      this.withVersion(instance.getVersion());
    }
    this.validationEnabled = validationEnabled; 
  }
  GenerationStatusFluent<?> fluent;
  Boolean validationEnabled;
  public GenerationStatus build() {
    GenerationStatus buildable = new GenerationStatus(fluent.getGroup(),fluent.getLastGeneration(),fluent.getName(),fluent.getNamespace(),fluent.getResource(),fluent.getVersion());
    return buildable;
  }
  
}