package io.fabric8.openclustermanagement.api.model.operator.v1;

import java.lang.SuppressWarnings;
import io.fabric8.kubernetes.api.builder.Nested;
import java.lang.String;
import java.lang.Deprecated;
import io.fabric8.kubernetes.api.builder.BaseFluent;
import java.lang.Boolean;
import io.fabric8.kubernetes.api.model.ObjectMeta;
import io.fabric8.kubernetes.api.model.ObjectMetaFluentImpl;
import io.fabric8.kubernetes.api.model.ObjectMetaBuilder;
import java.lang.Object;

 /**
  * Generated
  */
  @SuppressWarnings(value = "unchecked")
  public class ClusterManagerFluentImpl<A extends ClusterManagerFluent<A>> extends BaseFluent<A> implements ClusterManagerFluent<A>{
  public ClusterManagerFluentImpl() {
  }
  public ClusterManagerFluentImpl(ClusterManager instance) {
    if (instance != null) {
      this.withApiVersion(instance.getApiVersion());
      this.withKind(instance.getKind());
      this.withMetadata(instance.getMetadata());
      this.withSpec(instance.getSpec());
      this.withStatus(instance.getStatus());
    }
  }
  private String apiVersion;
  private String kind;
  private ObjectMetaBuilder metadata;
  private ClusterManagerSpecBuilder spec;
  private ClusterManagerStatusBuilder status;
  public String getApiVersion() {
    return this.apiVersion;
  }
  public A withApiVersion(String apiVersion) {
    this.apiVersion=apiVersion; return (A) this;
  }
  public Boolean hasApiVersion() {
    return this.apiVersion != null;
  }
  public String getKind() {
    return this.kind;
  }
  public A withKind(String kind) {
    this.kind=kind; return (A) this;
  }
  public Boolean hasKind() {
    return this.kind != null;
  }
  
  /**
   * This method has been deprecated, please use method buildMetadata instead.
   * @return The buildable object.
   */
  @Deprecated
  public ObjectMeta getMetadata() {
    return this.metadata!=null ?this.metadata.build():null;
  }
  public ObjectMeta buildMetadata() {
    return this.metadata!=null ?this.metadata.build():null;
  }
  public A withMetadata(ObjectMeta metadata) {
    _visitables.get("metadata").remove(this.metadata);
    if (metadata!=null){ this.metadata= new ObjectMetaBuilder(metadata); _visitables.get("metadata").add(this.metadata);} else { this.metadata = null; _visitables.get("metadata").remove(this.metadata); } return (A) this;
  }
  public Boolean hasMetadata() {
    return this.metadata != null;
  }
  public ClusterManagerFluentImpl.MetadataNested<A> withNewMetadata() {
    return new ClusterManagerFluentImpl.MetadataNestedImpl();
  }
  public ClusterManagerFluentImpl.MetadataNested<A> withNewMetadataLike(ObjectMeta item) {
    return new ClusterManagerFluentImpl.MetadataNestedImpl(item);
  }
  public ClusterManagerFluentImpl.MetadataNested<A> editMetadata() {
    return withNewMetadataLike(getMetadata());
  }
  public ClusterManagerFluentImpl.MetadataNested<A> editOrNewMetadata() {
    return withNewMetadataLike(getMetadata() != null ? getMetadata(): new ObjectMetaBuilder().build());
  }
  public ClusterManagerFluentImpl.MetadataNested<A> editOrNewMetadataLike(ObjectMeta item) {
    return withNewMetadataLike(getMetadata() != null ? getMetadata(): item);
  }
  
  /**
   * This method has been deprecated, please use method buildSpec instead.
   * @return The buildable object.
   */
  @Deprecated
  public ClusterManagerSpec getSpec() {
    return this.spec!=null ?this.spec.build():null;
  }
  public ClusterManagerSpec buildSpec() {
    return this.spec!=null ?this.spec.build():null;
  }
  public A withSpec(ClusterManagerSpec spec) {
    _visitables.get("spec").remove(this.spec);
    if (spec!=null){ this.spec= new ClusterManagerSpecBuilder(spec); _visitables.get("spec").add(this.spec);} else { this.spec = null; _visitables.get("spec").remove(this.spec); } return (A) this;
  }
  public Boolean hasSpec() {
    return this.spec != null;
  }
  public ClusterManagerFluentImpl.SpecNested<A> withNewSpec() {
    return new ClusterManagerFluentImpl.SpecNestedImpl();
  }
  public ClusterManagerFluentImpl.SpecNested<A> withNewSpecLike(ClusterManagerSpec item) {
    return new ClusterManagerFluentImpl.SpecNestedImpl(item);
  }
  public ClusterManagerFluentImpl.SpecNested<A> editSpec() {
    return withNewSpecLike(getSpec());
  }
  public ClusterManagerFluentImpl.SpecNested<A> editOrNewSpec() {
    return withNewSpecLike(getSpec() != null ? getSpec(): new ClusterManagerSpecBuilder().build());
  }
  public ClusterManagerFluentImpl.SpecNested<A> editOrNewSpecLike(ClusterManagerSpec item) {
    return withNewSpecLike(getSpec() != null ? getSpec(): item);
  }
  
  /**
   * This method has been deprecated, please use method buildStatus instead.
   * @return The buildable object.
   */
  @Deprecated
  public ClusterManagerStatus getStatus() {
    return this.status!=null ?this.status.build():null;
  }
  public ClusterManagerStatus buildStatus() {
    return this.status!=null ?this.status.build():null;
  }
  public A withStatus(ClusterManagerStatus status) {
    _visitables.get("status").remove(this.status);
    if (status!=null){ this.status= new ClusterManagerStatusBuilder(status); _visitables.get("status").add(this.status);} else { this.status = null; _visitables.get("status").remove(this.status); } return (A) this;
  }
  public Boolean hasStatus() {
    return this.status != null;
  }
  public ClusterManagerFluentImpl.StatusNested<A> withNewStatus() {
    return new ClusterManagerFluentImpl.StatusNestedImpl();
  }
  public ClusterManagerFluentImpl.StatusNested<A> withNewStatusLike(ClusterManagerStatus item) {
    return new ClusterManagerFluentImpl.StatusNestedImpl(item);
  }
  public ClusterManagerFluentImpl.StatusNested<A> editStatus() {
    return withNewStatusLike(getStatus());
  }
  public ClusterManagerFluentImpl.StatusNested<A> editOrNewStatus() {
    return withNewStatusLike(getStatus() != null ? getStatus(): new ClusterManagerStatusBuilder().build());
  }
  public ClusterManagerFluentImpl.StatusNested<A> editOrNewStatusLike(ClusterManagerStatus item) {
    return withNewStatusLike(getStatus() != null ? getStatus(): item);
  }
  public boolean equals(Object o) {
    if (this == o) return true;
    if (o == null || getClass() != o.getClass()) return false;
    if (!super.equals(o)) return false;
    ClusterManagerFluentImpl that = (ClusterManagerFluentImpl) o;
    if (!java.util.Objects.equals(apiVersion, that.apiVersion)) return false;

    if (!java.util.Objects.equals(kind, that.kind)) return false;

    if (!java.util.Objects.equals(metadata, that.metadata)) return false;

    if (!java.util.Objects.equals(spec, that.spec)) return false;

    if (!java.util.Objects.equals(status, that.status)) return false;

    return true;
  }
  public int hashCode() {
    return java.util.Objects.hash(apiVersion,  kind,  metadata,  spec,  status,  super.hashCode());
  }
  public String toString() {
    StringBuilder sb = new StringBuilder();
    sb.append("{");
    if (apiVersion != null) { sb.append("apiVersion:"); sb.append(apiVersion + ","); }
    if (kind != null) { sb.append("kind:"); sb.append(kind + ","); }
    if (metadata != null) { sb.append("metadata:"); sb.append(metadata + ","); }
    if (spec != null) { sb.append("spec:"); sb.append(spec + ","); }
    if (status != null) { sb.append("status:"); sb.append(status); }
    sb.append("}");
    return sb.toString();
  }
  class MetadataNestedImpl<N> extends ObjectMetaFluentImpl<ClusterManagerFluentImpl.MetadataNested<N>> implements ClusterManagerFluentImpl.MetadataNested<N>,Nested<N>{
    MetadataNestedImpl(ObjectMeta item) {
      this.builder = new ObjectMetaBuilder(this, item);
    }
    MetadataNestedImpl() {
      this.builder = new ObjectMetaBuilder(this);
    }
    ObjectMetaBuilder builder;
    public N and() {
      return (N) ClusterManagerFluentImpl.this.withMetadata(builder.build());
    }
    public N endMetadata() {
      return and();
    }
    
  }
  class SpecNestedImpl<N> extends ClusterManagerSpecFluentImpl<ClusterManagerFluentImpl.SpecNested<N>> implements ClusterManagerFluentImpl.SpecNested<N>,Nested<N>{
    SpecNestedImpl(ClusterManagerSpec item) {
      this.builder = new ClusterManagerSpecBuilder(this, item);
    }
    SpecNestedImpl() {
      this.builder = new ClusterManagerSpecBuilder(this);
    }
    ClusterManagerSpecBuilder builder;
    public N and() {
      return (N) ClusterManagerFluentImpl.this.withSpec(builder.build());
    }
    public N endSpec() {
      return and();
    }
    
  }
  class StatusNestedImpl<N> extends ClusterManagerStatusFluentImpl<ClusterManagerFluentImpl.StatusNested<N>> implements ClusterManagerFluentImpl.StatusNested<N>,Nested<N>{
    StatusNestedImpl(ClusterManagerStatus item) {
      this.builder = new ClusterManagerStatusBuilder(this, item);
    }
    StatusNestedImpl() {
      this.builder = new ClusterManagerStatusBuilder(this);
    }
    ClusterManagerStatusBuilder builder;
    public N and() {
      return (N) ClusterManagerFluentImpl.this.withStatus(builder.build());
    }
    public N endStatus() {
      return and();
    }
    
  }
  
}