package io.fabric8.openclustermanagement.api.model.multiclusterhub.operator.v1;

import io.fabric8.kubernetes.api.builder.VisitableBuilder;
import java.lang.Boolean;
public class MultiClusterHubStatusBuilder extends MultiClusterHubStatusFluentImpl<MultiClusterHubStatusBuilder> implements VisitableBuilder<MultiClusterHubStatus,MultiClusterHubStatusBuilder>{
  public MultiClusterHubStatusBuilder() {
    this(false);
  }
  public MultiClusterHubStatusBuilder(Boolean validationEnabled) {
    this(new MultiClusterHubStatus(), validationEnabled);
  }
  public MultiClusterHubStatusBuilder(MultiClusterHubStatusFluent<?> fluent) {
    this(fluent, false);
  }
  public MultiClusterHubStatusBuilder(MultiClusterHubStatusFluent<?> fluent,Boolean validationEnabled) {
    this(fluent, new MultiClusterHubStatus(), validationEnabled);
  }
  public MultiClusterHubStatusBuilder(MultiClusterHubStatusFluent<?> fluent,MultiClusterHubStatus instance) {
    this(fluent, instance, false);
  }
  public MultiClusterHubStatusBuilder(MultiClusterHubStatusFluent<?> fluent,MultiClusterHubStatus instance,Boolean validationEnabled) {
    this.fluent = fluent; 
    if (instance != null) {
      fluent.withComponents(instance.getComponents());
      fluent.withConditions(instance.getConditions());
      fluent.withCurrentVersion(instance.getCurrentVersion());
      fluent.withDesiredVersion(instance.getDesiredVersion());
      fluent.withPhase(instance.getPhase());
    }
    this.validationEnabled = validationEnabled; 
  }
  public MultiClusterHubStatusBuilder(MultiClusterHubStatus instance) {
    this(instance,false);
  }
  public MultiClusterHubStatusBuilder(MultiClusterHubStatus instance,Boolean validationEnabled) {
    this.fluent = this; 
    if (instance != null) {
      this.withComponents(instance.getComponents());
      this.withConditions(instance.getConditions());
      this.withCurrentVersion(instance.getCurrentVersion());
      this.withDesiredVersion(instance.getDesiredVersion());
      this.withPhase(instance.getPhase());
    }
    this.validationEnabled = validationEnabled; 
  }
  MultiClusterHubStatusFluent<?> fluent;
  Boolean validationEnabled;
  public MultiClusterHubStatus build() {
    MultiClusterHubStatus buildable = new MultiClusterHubStatus(fluent.getComponents(),fluent.getConditions(),fluent.getCurrentVersion(),fluent.getDesiredVersion(),fluent.getPhase());
    return buildable;
  }
  
}