package io.fabric8.openclustermanagement.api.model.multiclusterhub.operator.v1;

import java.lang.SuppressWarnings;
import io.fabric8.kubernetes.api.builder.Nested;
import java.lang.String;
import java.lang.Deprecated;
import io.fabric8.kubernetes.api.builder.BaseFluent;
import java.lang.Boolean;
import io.fabric8.kubernetes.api.model.ObjectMeta;
import io.fabric8.kubernetes.api.model.ObjectMetaFluentImpl;
import io.fabric8.kubernetes.api.model.ObjectMetaBuilder;
import java.lang.Object;

 /**
  * Generated
  */
  @SuppressWarnings(value = "unchecked")
  public class MultiClusterHubFluentImpl<A extends MultiClusterHubFluent<A>> extends BaseFluent<A> implements MultiClusterHubFluent<A>{
  public MultiClusterHubFluentImpl() {
  }
  public MultiClusterHubFluentImpl(MultiClusterHub instance) {
    if (instance != null) {
      this.withApiVersion(instance.getApiVersion());
      this.withKind(instance.getKind());
      this.withMetadata(instance.getMetadata());
      this.withSpec(instance.getSpec());
      this.withStatus(instance.getStatus());
    }
  }
  private String apiVersion;
  private String kind;
  private ObjectMetaBuilder metadata;
  private MultiClusterHubSpecBuilder spec;
  private MultiClusterHubStatusBuilder status;
  public String getApiVersion() {
    return this.apiVersion;
  }
  public A withApiVersion(String apiVersion) {
    this.apiVersion=apiVersion; return (A) this;
  }
  public Boolean hasApiVersion() {
    return this.apiVersion != null;
  }
  public String getKind() {
    return this.kind;
  }
  public A withKind(String kind) {
    this.kind=kind; return (A) this;
  }
  public Boolean hasKind() {
    return this.kind != null;
  }
  
  /**
   * This method has been deprecated, please use method buildMetadata instead.
   * @return The buildable object.
   */
  @Deprecated
  public ObjectMeta getMetadata() {
    return this.metadata!=null ?this.metadata.build():null;
  }
  public ObjectMeta buildMetadata() {
    return this.metadata!=null ?this.metadata.build():null;
  }
  public A withMetadata(ObjectMeta metadata) {
    _visitables.get("metadata").remove(this.metadata);
    if (metadata!=null){ this.metadata= new ObjectMetaBuilder(metadata); _visitables.get("metadata").add(this.metadata);} else { this.metadata = null; _visitables.get("metadata").remove(this.metadata); } return (A) this;
  }
  public Boolean hasMetadata() {
    return this.metadata != null;
  }
  public MultiClusterHubFluentImpl.MetadataNested<A> withNewMetadata() {
    return new MultiClusterHubFluentImpl.MetadataNestedImpl();
  }
  public MultiClusterHubFluentImpl.MetadataNested<A> withNewMetadataLike(ObjectMeta item) {
    return new MultiClusterHubFluentImpl.MetadataNestedImpl(item);
  }
  public MultiClusterHubFluentImpl.MetadataNested<A> editMetadata() {
    return withNewMetadataLike(getMetadata());
  }
  public MultiClusterHubFluentImpl.MetadataNested<A> editOrNewMetadata() {
    return withNewMetadataLike(getMetadata() != null ? getMetadata(): new ObjectMetaBuilder().build());
  }
  public MultiClusterHubFluentImpl.MetadataNested<A> editOrNewMetadataLike(ObjectMeta item) {
    return withNewMetadataLike(getMetadata() != null ? getMetadata(): item);
  }
  
  /**
   * This method has been deprecated, please use method buildSpec instead.
   * @return The buildable object.
   */
  @Deprecated
  public MultiClusterHubSpec getSpec() {
    return this.spec!=null ?this.spec.build():null;
  }
  public MultiClusterHubSpec buildSpec() {
    return this.spec!=null ?this.spec.build():null;
  }
  public A withSpec(MultiClusterHubSpec spec) {
    _visitables.get("spec").remove(this.spec);
    if (spec!=null){ this.spec= new MultiClusterHubSpecBuilder(spec); _visitables.get("spec").add(this.spec);} else { this.spec = null; _visitables.get("spec").remove(this.spec); } return (A) this;
  }
  public Boolean hasSpec() {
    return this.spec != null;
  }
  public MultiClusterHubFluentImpl.SpecNested<A> withNewSpec() {
    return new MultiClusterHubFluentImpl.SpecNestedImpl();
  }
  public MultiClusterHubFluentImpl.SpecNested<A> withNewSpecLike(MultiClusterHubSpec item) {
    return new MultiClusterHubFluentImpl.SpecNestedImpl(item);
  }
  public MultiClusterHubFluentImpl.SpecNested<A> editSpec() {
    return withNewSpecLike(getSpec());
  }
  public MultiClusterHubFluentImpl.SpecNested<A> editOrNewSpec() {
    return withNewSpecLike(getSpec() != null ? getSpec(): new MultiClusterHubSpecBuilder().build());
  }
  public MultiClusterHubFluentImpl.SpecNested<A> editOrNewSpecLike(MultiClusterHubSpec item) {
    return withNewSpecLike(getSpec() != null ? getSpec(): item);
  }
  
  /**
   * This method has been deprecated, please use method buildStatus instead.
   * @return The buildable object.
   */
  @Deprecated
  public MultiClusterHubStatus getStatus() {
    return this.status!=null ?this.status.build():null;
  }
  public MultiClusterHubStatus buildStatus() {
    return this.status!=null ?this.status.build():null;
  }
  public A withStatus(MultiClusterHubStatus status) {
    _visitables.get("status").remove(this.status);
    if (status!=null){ this.status= new MultiClusterHubStatusBuilder(status); _visitables.get("status").add(this.status);} else { this.status = null; _visitables.get("status").remove(this.status); } return (A) this;
  }
  public Boolean hasStatus() {
    return this.status != null;
  }
  public MultiClusterHubFluentImpl.StatusNested<A> withNewStatus() {
    return new MultiClusterHubFluentImpl.StatusNestedImpl();
  }
  public MultiClusterHubFluentImpl.StatusNested<A> withNewStatusLike(MultiClusterHubStatus item) {
    return new MultiClusterHubFluentImpl.StatusNestedImpl(item);
  }
  public MultiClusterHubFluentImpl.StatusNested<A> editStatus() {
    return withNewStatusLike(getStatus());
  }
  public MultiClusterHubFluentImpl.StatusNested<A> editOrNewStatus() {
    return withNewStatusLike(getStatus() != null ? getStatus(): new MultiClusterHubStatusBuilder().build());
  }
  public MultiClusterHubFluentImpl.StatusNested<A> editOrNewStatusLike(MultiClusterHubStatus item) {
    return withNewStatusLike(getStatus() != null ? getStatus(): item);
  }
  public boolean equals(Object o) {
    if (this == o) return true;
    if (o == null || getClass() != o.getClass()) return false;
    if (!super.equals(o)) return false;
    MultiClusterHubFluentImpl that = (MultiClusterHubFluentImpl) o;
    if (!java.util.Objects.equals(apiVersion, that.apiVersion)) return false;

    if (!java.util.Objects.equals(kind, that.kind)) return false;

    if (!java.util.Objects.equals(metadata, that.metadata)) return false;

    if (!java.util.Objects.equals(spec, that.spec)) return false;

    if (!java.util.Objects.equals(status, that.status)) return false;

    return true;
  }
  public int hashCode() {
    return java.util.Objects.hash(apiVersion,  kind,  metadata,  spec,  status,  super.hashCode());
  }
  public String toString() {
    StringBuilder sb = new StringBuilder();
    sb.append("{");
    if (apiVersion != null) { sb.append("apiVersion:"); sb.append(apiVersion + ","); }
    if (kind != null) { sb.append("kind:"); sb.append(kind + ","); }
    if (metadata != null) { sb.append("metadata:"); sb.append(metadata + ","); }
    if (spec != null) { sb.append("spec:"); sb.append(spec + ","); }
    if (status != null) { sb.append("status:"); sb.append(status); }
    sb.append("}");
    return sb.toString();
  }
  class MetadataNestedImpl<N> extends ObjectMetaFluentImpl<MultiClusterHubFluentImpl.MetadataNested<N>> implements MultiClusterHubFluentImpl.MetadataNested<N>,Nested<N>{
    MetadataNestedImpl(ObjectMeta item) {
      this.builder = new ObjectMetaBuilder(this, item);
    }
    MetadataNestedImpl() {
      this.builder = new ObjectMetaBuilder(this);
    }
    ObjectMetaBuilder builder;
    public N and() {
      return (N) MultiClusterHubFluentImpl.this.withMetadata(builder.build());
    }
    public N endMetadata() {
      return and();
    }
    
  }
  class SpecNestedImpl<N> extends MultiClusterHubSpecFluentImpl<MultiClusterHubFluentImpl.SpecNested<N>> implements MultiClusterHubFluentImpl.SpecNested<N>,Nested<N>{
    SpecNestedImpl(MultiClusterHubSpec item) {
      this.builder = new MultiClusterHubSpecBuilder(this, item);
    }
    SpecNestedImpl() {
      this.builder = new MultiClusterHubSpecBuilder(this);
    }
    MultiClusterHubSpecBuilder builder;
    public N and() {
      return (N) MultiClusterHubFluentImpl.this.withSpec(builder.build());
    }
    public N endSpec() {
      return and();
    }
    
  }
  class StatusNestedImpl<N> extends MultiClusterHubStatusFluentImpl<MultiClusterHubFluentImpl.StatusNested<N>> implements MultiClusterHubFluentImpl.StatusNested<N>,Nested<N>{
    StatusNestedImpl(MultiClusterHubStatus item) {
      this.builder = new MultiClusterHubStatusBuilder(this, item);
    }
    StatusNestedImpl() {
      this.builder = new MultiClusterHubStatusBuilder(this);
    }
    MultiClusterHubStatusBuilder builder;
    public N and() {
      return (N) MultiClusterHubFluentImpl.this.withStatus(builder.build());
    }
    public N endStatus() {
      return and();
    }
    
  }
  
}