package io.fabric8.openclustermanagement.api.model.multiclusterhub.operator.v1;

import io.fabric8.kubernetes.api.builder.VisitableBuilder;
import java.lang.Boolean;
public class HiveConfigSpecBuilder extends HiveConfigSpecFluentImpl<HiveConfigSpecBuilder> implements VisitableBuilder<HiveConfigSpec,HiveConfigSpecBuilder>{
  public HiveConfigSpecBuilder() {
    this(false);
  }
  public HiveConfigSpecBuilder(Boolean validationEnabled) {
    this(new HiveConfigSpec(), validationEnabled);
  }
  public HiveConfigSpecBuilder(HiveConfigSpecFluent<?> fluent) {
    this(fluent, false);
  }
  public HiveConfigSpecBuilder(HiveConfigSpecFluent<?> fluent,Boolean validationEnabled) {
    this(fluent, new HiveConfigSpec(), validationEnabled);
  }
  public HiveConfigSpecBuilder(HiveConfigSpecFluent<?> fluent,HiveConfigSpec instance) {
    this(fluent, instance, false);
  }
  public HiveConfigSpecBuilder(HiveConfigSpecFluent<?> fluent,HiveConfigSpec instance,Boolean validationEnabled) {
    this.fluent = fluent; 
    if (instance != null) {
      fluent.withAdditionalCertificateAuthorities(instance.getAdditionalCertificateAuthorities());
      fluent.withBackup(instance.getBackup());
      fluent.withExternalDNS(instance.getExternalDNS());
      fluent.withFailedProvisionConfig(instance.getFailedProvisionConfig());
      fluent.withGlobalPullSecret(instance.getGlobalPullSecret());
      fluent.withMaintenanceMode(instance.getMaintenanceMode());
    }
    this.validationEnabled = validationEnabled; 
  }
  public HiveConfigSpecBuilder(HiveConfigSpec instance) {
    this(instance,false);
  }
  public HiveConfigSpecBuilder(HiveConfigSpec instance,Boolean validationEnabled) {
    this.fluent = this; 
    if (instance != null) {
      this.withAdditionalCertificateAuthorities(instance.getAdditionalCertificateAuthorities());
      this.withBackup(instance.getBackup());
      this.withExternalDNS(instance.getExternalDNS());
      this.withFailedProvisionConfig(instance.getFailedProvisionConfig());
      this.withGlobalPullSecret(instance.getGlobalPullSecret());
      this.withMaintenanceMode(instance.getMaintenanceMode());
    }
    this.validationEnabled = validationEnabled; 
  }
  HiveConfigSpecFluent<?> fluent;
  Boolean validationEnabled;
  public HiveConfigSpec build() {
    HiveConfigSpec buildable = new HiveConfigSpec(fluent.getAdditionalCertificateAuthorities(),fluent.getBackup(),fluent.getExternalDNS(),fluent.getFailedProvisionConfig(),fluent.getGlobalPullSecret(),fluent.getMaintenanceMode());
    return buildable;
  }
  
}