package io.fabric8.openclustermanagement.api.model.multiclusterhub.operator.v1;

import java.lang.SuppressWarnings;
import io.fabric8.kubernetes.api.builder.Nested;
import java.lang.String;
import java.lang.Integer;
import java.lang.Deprecated;
import io.fabric8.kubernetes.api.builder.BaseFluent;
import java.lang.Object;
import java.lang.Boolean;

 /**
  * Generated
  */
  @SuppressWarnings(value = "unchecked")
  public class BackupConfigFluentImpl<A extends BackupConfigFluent<A>> extends BaseFluent<A> implements BackupConfigFluent<A>{
  public BackupConfigFluentImpl() {
  }
  public BackupConfigFluentImpl(BackupConfig instance) {
    if (instance != null) {
      this.withMinBackupPeriodSeconds(instance.getMinBackupPeriodSeconds());
      this.withVelero(instance.getVelero());
    }
  }
  private Integer minBackupPeriodSeconds;
  private VeleroBackupConfigBuilder velero;
  public Integer getMinBackupPeriodSeconds() {
    return this.minBackupPeriodSeconds;
  }
  public A withMinBackupPeriodSeconds(Integer minBackupPeriodSeconds) {
    this.minBackupPeriodSeconds=minBackupPeriodSeconds; return (A) this;
  }
  public Boolean hasMinBackupPeriodSeconds() {
    return this.minBackupPeriodSeconds != null;
  }
  
  /**
   * This method has been deprecated, please use method buildVelero instead.
   * @return The buildable object.
   */
  @Deprecated
  public VeleroBackupConfig getVelero() {
    return this.velero!=null ?this.velero.build():null;
  }
  public VeleroBackupConfig buildVelero() {
    return this.velero!=null ?this.velero.build():null;
  }
  public A withVelero(VeleroBackupConfig velero) {
    _visitables.get("velero").remove(this.velero);
    if (velero!=null){ this.velero= new VeleroBackupConfigBuilder(velero); _visitables.get("velero").add(this.velero);} else { this.velero = null; _visitables.get("velero").remove(this.velero); } return (A) this;
  }
  public Boolean hasVelero() {
    return this.velero != null;
  }
  public A withNewVelero(Boolean enabled) {
    return (A)withVelero(new VeleroBackupConfig(enabled));
  }
  public BackupConfigFluentImpl.VeleroNested<A> withNewVelero() {
    return new BackupConfigFluentImpl.VeleroNestedImpl();
  }
  public BackupConfigFluentImpl.VeleroNested<A> withNewVeleroLike(VeleroBackupConfig item) {
    return new BackupConfigFluentImpl.VeleroNestedImpl(item);
  }
  public BackupConfigFluentImpl.VeleroNested<A> editVelero() {
    return withNewVeleroLike(getVelero());
  }
  public BackupConfigFluentImpl.VeleroNested<A> editOrNewVelero() {
    return withNewVeleroLike(getVelero() != null ? getVelero(): new VeleroBackupConfigBuilder().build());
  }
  public BackupConfigFluentImpl.VeleroNested<A> editOrNewVeleroLike(VeleroBackupConfig item) {
    return withNewVeleroLike(getVelero() != null ? getVelero(): item);
  }
  public boolean equals(Object o) {
    if (this == o) return true;
    if (o == null || getClass() != o.getClass()) return false;
    if (!super.equals(o)) return false;
    BackupConfigFluentImpl that = (BackupConfigFluentImpl) o;
    if (!java.util.Objects.equals(minBackupPeriodSeconds, that.minBackupPeriodSeconds)) return false;

    if (!java.util.Objects.equals(velero, that.velero)) return false;

    return true;
  }
  public int hashCode() {
    return java.util.Objects.hash(minBackupPeriodSeconds,  velero,  super.hashCode());
  }
  public String toString() {
    StringBuilder sb = new StringBuilder();
    sb.append("{");
    if (minBackupPeriodSeconds != null) { sb.append("minBackupPeriodSeconds:"); sb.append(minBackupPeriodSeconds + ","); }
    if (velero != null) { sb.append("velero:"); sb.append(velero); }
    sb.append("}");
    return sb.toString();
  }
  class VeleroNestedImpl<N> extends VeleroBackupConfigFluentImpl<BackupConfigFluentImpl.VeleroNested<N>> implements BackupConfigFluentImpl.VeleroNested<N>,Nested<N>{
    VeleroNestedImpl(VeleroBackupConfig item) {
      this.builder = new VeleroBackupConfigBuilder(this, item);
    }
    VeleroNestedImpl() {
      this.builder = new VeleroBackupConfigBuilder(this);
    }
    VeleroBackupConfigBuilder builder;
    public N and() {
      return (N) BackupConfigFluentImpl.this.withVelero(builder.build());
    }
    public N endVelero() {
      return and();
    }
    
  }
  
}