package io.fabric8.openclustermanagement.api.model.multiclusterhub.operator.v1;

import io.fabric8.kubernetes.api.builder.VisitableBuilder;
import java.lang.SuppressWarnings;
import io.fabric8.kubernetes.api.builder.Nested;
import java.util.ArrayList;
import java.lang.String;
import java.util.LinkedHashMap;
import java.util.function.Predicate;
import java.lang.Deprecated;
import io.fabric8.kubernetes.api.builder.BaseFluent;
import java.util.Iterator;
import java.util.List;
import java.lang.Boolean;
import java.lang.Integer;
import java.util.Collection;
import java.lang.Object;
import java.util.Map;

 /**
  * Generated
  */
  @SuppressWarnings(value = "unchecked")
  public class MultiClusterHubStatusFluentImpl<A extends MultiClusterHubStatusFluent<A>> extends BaseFluent<A> implements MultiClusterHubStatusFluent<A>{
  public MultiClusterHubStatusFluentImpl() {
  }
  public MultiClusterHubStatusFluentImpl(MultiClusterHubStatus instance) {
    this.withComponents(instance.getComponents()); 
    this.withConditions(instance.getConditions()); 
    this.withCurrentVersion(instance.getCurrentVersion()); 
    this.withDesiredVersion(instance.getDesiredVersion()); 
    this.withPhase(instance.getPhase()); 
  }
  private Map<String,StatusCondition> components;
  private ArrayList<HubConditionBuilder> conditions = new ArrayList<HubConditionBuilder>();
  private String currentVersion;
  private String desiredVersion;
  private String phase;
  public A addToComponents(String key,StatusCondition value) {
    if(this.components == null && key != null && value != null) { this.components = new LinkedHashMap(); }
    if(key != null && value != null) {this.components.put(key, value);} return (A)this;
  }
  public A addToComponents(Map<String,StatusCondition> map) {
    if(this.components == null && map != null) { this.components = new LinkedHashMap(); }
    if(map != null) { this.components.putAll(map);} return (A)this;
  }
  public A removeFromComponents(String key) {
    if(this.components == null) { return (A) this; }
    if(key != null && this.components != null) {this.components.remove(key);} return (A)this;
  }
  public A removeFromComponents(Map<String,StatusCondition> map) {
    if(this.components == null) { return (A) this; }
    if(map != null) { for(Object key : map.keySet()) {if (this.components != null){this.components.remove(key);}}} return (A)this;
  }
  public Map<String,StatusCondition> getComponents() {
    return this.components;
  }
  public <K,V>A withComponents(Map<String,StatusCondition> components) {
    if (components == null) { this.components =  null;} else {this.components = new LinkedHashMap(components);} return (A) this;
  }
  public Boolean hasComponents() {
    return this.components != null;
  }
  public A addToConditions(Integer index,HubCondition item) {
    if (this.conditions == null) {this.conditions = new ArrayList<HubConditionBuilder>();}
    HubConditionBuilder builder = new HubConditionBuilder(item);_visitables.get("conditions").add(index >= 0 ? index : _visitables.get("conditions").size(), builder);this.conditions.add(index >= 0 ? index : conditions.size(), builder); return (A)this;
  }
  public A setToConditions(Integer index,HubCondition item) {
    if (this.conditions == null) {this.conditions = new ArrayList<HubConditionBuilder>();}
    HubConditionBuilder builder = new HubConditionBuilder(item);
    if (index < 0 || index >= _visitables.get("conditions").size()) { _visitables.get("conditions").add(builder); } else { _visitables.get("conditions").set(index, builder);}
    if (index < 0 || index >= conditions.size()) { conditions.add(builder); } else { conditions.set(index, builder);}
     return (A)this;
  }
  public A addToConditions(io.fabric8.openclustermanagement.api.model.multiclusterhub.operator.v1.HubCondition... items) {
    if (this.conditions == null) {this.conditions = new ArrayList<HubConditionBuilder>();}
    for (HubCondition item : items) {HubConditionBuilder builder = new HubConditionBuilder(item);_visitables.get("conditions").add(builder);this.conditions.add(builder);} return (A)this;
  }
  public A addAllToConditions(Collection<HubCondition> items) {
    if (this.conditions == null) {this.conditions = new ArrayList<HubConditionBuilder>();}
    for (HubCondition item : items) {HubConditionBuilder builder = new HubConditionBuilder(item);_visitables.get("conditions").add(builder);this.conditions.add(builder);} return (A)this;
  }
  public A removeFromConditions(io.fabric8.openclustermanagement.api.model.multiclusterhub.operator.v1.HubCondition... items) {
    for (HubCondition item : items) {HubConditionBuilder builder = new HubConditionBuilder(item);_visitables.get("conditions").remove(builder);if (this.conditions != null) {this.conditions.remove(builder);}} return (A)this;
  }
  public A removeAllFromConditions(Collection<HubCondition> items) {
    for (HubCondition item : items) {HubConditionBuilder builder = new HubConditionBuilder(item);_visitables.get("conditions").remove(builder);if (this.conditions != null) {this.conditions.remove(builder);}} return (A)this;
  }
  public A removeMatchingFromConditions(Predicate<HubConditionBuilder> predicate) {
    if (conditions == null) return (A) this;
    final Iterator<HubConditionBuilder> each = conditions.iterator();
    final List visitables = _visitables.get("conditions");
    while (each.hasNext()) {
      HubConditionBuilder builder = each.next();
      if (predicate.test(builder)) {
        visitables.remove(builder);
        each.remove();
      }
    }
    return (A)this;
  }
  
  /**
   * This method has been deprecated, please use method buildConditions instead.
   * @return The buildable object.
   */
  @Deprecated
  public List<HubCondition> getConditions() {
    return conditions != null ? build(conditions) : null;
  }
  public List<HubCondition> buildConditions() {
    return conditions != null ? build(conditions) : null;
  }
  public HubCondition buildCondition(Integer index) {
    return this.conditions.get(index).build();
  }
  public HubCondition buildFirstCondition() {
    return this.conditions.get(0).build();
  }
  public HubCondition buildLastCondition() {
    return this.conditions.get(conditions.size() - 1).build();
  }
  public HubCondition buildMatchingCondition(Predicate<HubConditionBuilder> predicate) {
    for (HubConditionBuilder item: conditions) { if(predicate.test(item)){ return item.build();} } return null;
  }
  public Boolean hasMatchingCondition(Predicate<HubConditionBuilder> predicate) {
    for (HubConditionBuilder item: conditions) { if(predicate.test(item)){ return true;} } return false;
  }
  public A withConditions(List<HubCondition> conditions) {
    if (this.conditions != null) { _visitables.get("conditions").removeAll(this.conditions);}
    if (conditions != null) {this.conditions = new ArrayList(); for (HubCondition item : conditions){this.addToConditions(item);}} else { this.conditions = null;} return (A) this;
  }
  public A withConditions(io.fabric8.openclustermanagement.api.model.multiclusterhub.operator.v1.HubCondition... conditions) {
    if (this.conditions != null) {this.conditions.clear();}
    if (conditions != null) {for (HubCondition item :conditions){ this.addToConditions(item);}} return (A) this;
  }
  public Boolean hasConditions() {
    return conditions != null && !conditions.isEmpty();
  }
  public MultiClusterHubStatusFluent.ConditionsNested<A> addNewCondition() {
    return new MultiClusterHubStatusFluentImpl.ConditionsNestedImpl();
  }
  public MultiClusterHubStatusFluent.ConditionsNested<A> addNewConditionLike(HubCondition item) {
    return new MultiClusterHubStatusFluentImpl.ConditionsNestedImpl(-1, item);
  }
  public MultiClusterHubStatusFluent.ConditionsNested<A> setNewConditionLike(Integer index,HubCondition item) {
    return new MultiClusterHubStatusFluentImpl.ConditionsNestedImpl(index, item);
  }
  public MultiClusterHubStatusFluent.ConditionsNested<A> editCondition(Integer index) {
    if (conditions.size() <= index) throw new RuntimeException("Can't edit conditions. Index exceeds size.");
    return setNewConditionLike(index, buildCondition(index));
  }
  public MultiClusterHubStatusFluent.ConditionsNested<A> editFirstCondition() {
    if (conditions.size() == 0) throw new RuntimeException("Can't edit first conditions. The list is empty.");
    return setNewConditionLike(0, buildCondition(0));
  }
  public MultiClusterHubStatusFluent.ConditionsNested<A> editLastCondition() {
    int index = conditions.size() - 1;
    if (index < 0) throw new RuntimeException("Can't edit last conditions. The list is empty.");
    return setNewConditionLike(index, buildCondition(index));
  }
  public MultiClusterHubStatusFluent.ConditionsNested<A> editMatchingCondition(Predicate<HubConditionBuilder> predicate) {
    int index = -1;
    for (int i=0;i<conditions.size();i++) { 
    if (predicate.test(conditions.get(i))) {index = i; break;}
    } 
    if (index < 0) throw new RuntimeException("Can't edit matching conditions. No match found.");
    return setNewConditionLike(index, buildCondition(index));
  }
  public String getCurrentVersion() {
    return this.currentVersion;
  }
  public A withCurrentVersion(String currentVersion) {
    this.currentVersion=currentVersion; return (A) this;
  }
  public Boolean hasCurrentVersion() {
    return this.currentVersion != null;
  }
  public String getDesiredVersion() {
    return this.desiredVersion;
  }
  public A withDesiredVersion(String desiredVersion) {
    this.desiredVersion=desiredVersion; return (A) this;
  }
  public Boolean hasDesiredVersion() {
    return this.desiredVersion != null;
  }
  public String getPhase() {
    return this.phase;
  }
  public A withPhase(String phase) {
    this.phase=phase; return (A) this;
  }
  public Boolean hasPhase() {
    return this.phase != null;
  }
  public boolean equals(Object o) {
    if (this == o) return true;
    if (o == null || getClass() != o.getClass()) return false;
    MultiClusterHubStatusFluentImpl that = (MultiClusterHubStatusFluentImpl) o;
    if (components != null ? !components.equals(that.components) :that.components != null) return false;
    if (conditions != null ? !conditions.equals(that.conditions) :that.conditions != null) return false;
    if (currentVersion != null ? !currentVersion.equals(that.currentVersion) :that.currentVersion != null) return false;
    if (desiredVersion != null ? !desiredVersion.equals(that.desiredVersion) :that.desiredVersion != null) return false;
    if (phase != null ? !phase.equals(that.phase) :that.phase != null) return false;
    return true;
  }
  public int hashCode() {
    return java.util.Objects.hash(components,  conditions,  currentVersion,  desiredVersion,  phase,  super.hashCode());
  }
  public String toString() {
    StringBuilder sb = new StringBuilder();
    sb.append("{");
    if (components != null && !components.isEmpty()) { sb.append("components:"); sb.append(components + ","); }
    if (conditions != null && !conditions.isEmpty()) { sb.append("conditions:"); sb.append(conditions + ","); }
    if (currentVersion != null) { sb.append("currentVersion:"); sb.append(currentVersion + ","); }
    if (desiredVersion != null) { sb.append("desiredVersion:"); sb.append(desiredVersion + ","); }
    if (phase != null) { sb.append("phase:"); sb.append(phase); }
    sb.append("}");
    return sb.toString();
  }
  class ConditionsNestedImpl<N> extends HubConditionFluentImpl<MultiClusterHubStatusFluent.ConditionsNested<N>> implements MultiClusterHubStatusFluent.ConditionsNested<N>,Nested<N>{
    ConditionsNestedImpl(Integer index,HubCondition item) {
      this.index = index;
      this.builder = new HubConditionBuilder(this, item);
    }
    ConditionsNestedImpl() {
      this.index = -1;
      this.builder = new HubConditionBuilder(this);
    }
    HubConditionBuilder builder;
    Integer index;
    public N and() {
      return (N) MultiClusterHubStatusFluentImpl.this.setToConditions(index,builder.build());
    }
    public N endCondition() {
      return and();
    }
    
  }
  
}