package io.fabric8.openclustermanagement.api.model.multiclusterhub.operator.v1;

import io.fabric8.kubernetes.api.builder.VisitableBuilder;
import java.lang.Boolean;
public class MultiClusterHubBuilder extends MultiClusterHubFluentImpl<MultiClusterHubBuilder> implements VisitableBuilder<MultiClusterHub,MultiClusterHubBuilder>{
  public MultiClusterHubBuilder() {
    this(false);
  }
  public MultiClusterHubBuilder(Boolean validationEnabled) {
    this(new MultiClusterHub(), validationEnabled);
  }
  public MultiClusterHubBuilder(MultiClusterHubFluent<?> fluent) {
    this(fluent, false);
  }
  public MultiClusterHubBuilder(MultiClusterHubFluent<?> fluent,Boolean validationEnabled) {
    this(fluent, new MultiClusterHub(), validationEnabled);
  }
  public MultiClusterHubBuilder(MultiClusterHubFluent<?> fluent,MultiClusterHub instance) {
    this(fluent, instance, false);
  }
  public MultiClusterHubBuilder(MultiClusterHubFluent<?> fluent,MultiClusterHub instance,Boolean validationEnabled) {
    this.fluent = fluent; 
    fluent.withApiVersion(instance.getApiVersion()); 
    fluent.withKind(instance.getKind()); 
    fluent.withMetadata(instance.getMetadata()); 
    fluent.withSpec(instance.getSpec()); 
    fluent.withStatus(instance.getStatus()); 
    this.validationEnabled = validationEnabled; 
  }
  public MultiClusterHubBuilder(MultiClusterHub instance) {
    this(instance,false);
  }
  public MultiClusterHubBuilder(MultiClusterHub instance,Boolean validationEnabled) {
    this.fluent = this; 
    this.withApiVersion(instance.getApiVersion()); 
    this.withKind(instance.getKind()); 
    this.withMetadata(instance.getMetadata()); 
    this.withSpec(instance.getSpec()); 
    this.withStatus(instance.getStatus()); 
    this.validationEnabled = validationEnabled; 
  }
  MultiClusterHubFluent<?> fluent;
  Boolean validationEnabled;
  public MultiClusterHub build() {
    MultiClusterHub buildable = new MultiClusterHub(fluent.getApiVersion(),fluent.getKind(),fluent.getMetadata(),fluent.getSpec(),fluent.getStatus());
    return buildable;
  }
  
}