package io.fabric8.openclustermanagement.api.model.multiclusterhub.operator.v1;

import java.lang.SuppressWarnings;
import java.util.ArrayList;
import java.lang.String;
import java.util.function.Predicate;
import java.lang.Integer;
import io.fabric8.kubernetes.api.builder.BaseFluent;
import java.util.Collection;
import java.lang.Object;
import java.util.List;
import java.lang.Boolean;

 /**
  * Generated
  */
  @SuppressWarnings(value = "unchecked")
  public class IngressSpecFluentImpl<A extends IngressSpecFluent<A>> extends BaseFluent<A> implements IngressSpecFluent<A>{
  public IngressSpecFluentImpl() {
  }
  public IngressSpecFluentImpl(IngressSpec instance) {
    this.withSslCiphers(instance.getSslCiphers()); 
  }
  private List<String> sslCiphers = new ArrayList<String>();
  public A addToSslCiphers(Integer index,String item) {
    if (this.sslCiphers == null) {this.sslCiphers = new ArrayList<String>();}
    this.sslCiphers.add(index, item);
    return (A)this;
  }
  public A setToSslCiphers(Integer index,String item) {
    if (this.sslCiphers == null) {this.sslCiphers = new ArrayList<String>();}
    this.sslCiphers.set(index, item); return (A)this;
  }
  public A addToSslCiphers(java.lang.String... items) {
    if (this.sslCiphers == null) {this.sslCiphers = new ArrayList<String>();}
    for (String item : items) {this.sslCiphers.add(item);} return (A)this;
  }
  public A addAllToSslCiphers(Collection<String> items) {
    if (this.sslCiphers == null) {this.sslCiphers = new ArrayList<String>();}
    for (String item : items) {this.sslCiphers.add(item);} return (A)this;
  }
  public A removeFromSslCiphers(java.lang.String... items) {
    for (String item : items) {if (this.sslCiphers!= null){ this.sslCiphers.remove(item);}} return (A)this;
  }
  public A removeAllFromSslCiphers(Collection<String> items) {
    for (String item : items) {if (this.sslCiphers!= null){ this.sslCiphers.remove(item);}} return (A)this;
  }
  public List<String> getSslCiphers() {
    return this.sslCiphers;
  }
  public String getSslCipher(Integer index) {
    return this.sslCiphers.get(index);
  }
  public String getFirstSslCipher() {
    return this.sslCiphers.get(0);
  }
  public String getLastSslCipher() {
    return this.sslCiphers.get(sslCiphers.size() - 1);
  }
  public String getMatchingSslCipher(Predicate<String> predicate) {
    for (String item: sslCiphers) { if(predicate.test(item)){ return item;} } return null;
  }
  public Boolean hasMatchingSslCipher(Predicate<String> predicate) {
    for (String item: sslCiphers) { if(predicate.test(item)){ return true;} } return false;
  }
  public A withSslCiphers(List<String> sslCiphers) {
    if (sslCiphers != null) {this.sslCiphers = new ArrayList(); for (String item : sslCiphers){this.addToSslCiphers(item);}} else { this.sslCiphers = null;} return (A) this;
  }
  public A withSslCiphers(java.lang.String... sslCiphers) {
    if (this.sslCiphers != null) {this.sslCiphers.clear();}
    if (sslCiphers != null) {for (String item :sslCiphers){ this.addToSslCiphers(item);}} return (A) this;
  }
  public Boolean hasSslCiphers() {
    return sslCiphers != null && !sslCiphers.isEmpty();
  }
  public boolean equals(Object o) {
    if (this == o) return true;
    if (o == null || getClass() != o.getClass()) return false;
    IngressSpecFluentImpl that = (IngressSpecFluentImpl) o;
    if (sslCiphers != null ? !sslCiphers.equals(that.sslCiphers) :that.sslCiphers != null) return false;
    return true;
  }
  public int hashCode() {
    return java.util.Objects.hash(sslCiphers,  super.hashCode());
  }
  public String toString() {
    StringBuilder sb = new StringBuilder();
    sb.append("{");
    if (sslCiphers != null && !sslCiphers.isEmpty()) { sb.append("sslCiphers:"); sb.append(sslCiphers); }
    sb.append("}");
    return sb.toString();
  }
  
}