package io.fabric8.openclustermanagement.api.model.multiclusterhub.operator.v1;

import io.fabric8.kubernetes.api.builder.VisitableBuilder;
import java.lang.Boolean;
public class ExternalDNSGCPConfigBuilder extends ExternalDNSGCPConfigFluentImpl<ExternalDNSGCPConfigBuilder> implements VisitableBuilder<ExternalDNSGCPConfig,ExternalDNSGCPConfigBuilder>{
  public ExternalDNSGCPConfigBuilder() {
    this(false);
  }
  public ExternalDNSGCPConfigBuilder(Boolean validationEnabled) {
    this(new ExternalDNSGCPConfig(), validationEnabled);
  }
  public ExternalDNSGCPConfigBuilder(ExternalDNSGCPConfigFluent<?> fluent) {
    this(fluent, false);
  }
  public ExternalDNSGCPConfigBuilder(ExternalDNSGCPConfigFluent<?> fluent,Boolean validationEnabled) {
    this(fluent, new ExternalDNSGCPConfig(), validationEnabled);
  }
  public ExternalDNSGCPConfigBuilder(ExternalDNSGCPConfigFluent<?> fluent,ExternalDNSGCPConfig instance) {
    this(fluent, instance, false);
  }
  public ExternalDNSGCPConfigBuilder(ExternalDNSGCPConfigFluent<?> fluent,ExternalDNSGCPConfig instance,Boolean validationEnabled) {
    this.fluent = fluent; 
    fluent.withCredentials(instance.getCredentials()); 
    this.validationEnabled = validationEnabled; 
  }
  public ExternalDNSGCPConfigBuilder(ExternalDNSGCPConfig instance) {
    this(instance,false);
  }
  public ExternalDNSGCPConfigBuilder(ExternalDNSGCPConfig instance,Boolean validationEnabled) {
    this.fluent = this; 
    this.withCredentials(instance.getCredentials()); 
    this.validationEnabled = validationEnabled; 
  }
  ExternalDNSGCPConfigFluent<?> fluent;
  Boolean validationEnabled;
  public ExternalDNSGCPConfig build() {
    ExternalDNSGCPConfig buildable = new ExternalDNSGCPConfig(fluent.getCredentials());
    return buildable;
  }
  
}