package io.fabric8.openclustermanagement.api.model.multiclusterhub.operator.v1;

import io.fabric8.kubernetes.api.builder.VisitableBuilder;
import java.lang.Boolean;
public class ExternalDNSAWSConfigBuilder extends ExternalDNSAWSConfigFluentImpl<ExternalDNSAWSConfigBuilder> implements VisitableBuilder<ExternalDNSAWSConfig,ExternalDNSAWSConfigBuilder>{
  public ExternalDNSAWSConfigBuilder() {
    this(false);
  }
  public ExternalDNSAWSConfigBuilder(Boolean validationEnabled) {
    this(new ExternalDNSAWSConfig(), validationEnabled);
  }
  public ExternalDNSAWSConfigBuilder(ExternalDNSAWSConfigFluent<?> fluent) {
    this(fluent, false);
  }
  public ExternalDNSAWSConfigBuilder(ExternalDNSAWSConfigFluent<?> fluent,Boolean validationEnabled) {
    this(fluent, new ExternalDNSAWSConfig(), validationEnabled);
  }
  public ExternalDNSAWSConfigBuilder(ExternalDNSAWSConfigFluent<?> fluent,ExternalDNSAWSConfig instance) {
    this(fluent, instance, false);
  }
  public ExternalDNSAWSConfigBuilder(ExternalDNSAWSConfigFluent<?> fluent,ExternalDNSAWSConfig instance,Boolean validationEnabled) {
    this.fluent = fluent; 
    fluent.withCredentials(instance.getCredentials()); 
    this.validationEnabled = validationEnabled; 
  }
  public ExternalDNSAWSConfigBuilder(ExternalDNSAWSConfig instance) {
    this(instance,false);
  }
  public ExternalDNSAWSConfigBuilder(ExternalDNSAWSConfig instance,Boolean validationEnabled) {
    this.fluent = this; 
    this.withCredentials(instance.getCredentials()); 
    this.validationEnabled = validationEnabled; 
  }
  ExternalDNSAWSConfigFluent<?> fluent;
  Boolean validationEnabled;
  public ExternalDNSAWSConfig build() {
    ExternalDNSAWSConfig buildable = new ExternalDNSAWSConfig(fluent.getCredentials());
    return buildable;
  }
  
}