/*
 * Decompiled with CFR 0.152.
 */
package io.fabric8.openclustermanagement.api.model.operator.v1;

import io.fabric8.kubernetes.api.builder.BaseFluent;
import io.fabric8.kubernetes.api.builder.Nested;
import io.fabric8.kubernetes.api.model.Condition;
import io.fabric8.openclustermanagement.api.model.operator.v1.ClusterManagerStatus;
import io.fabric8.openclustermanagement.api.model.operator.v1.ClusterManagerStatusFluent;
import io.fabric8.openclustermanagement.api.model.operator.v1.GenerationStatus;
import io.fabric8.openclustermanagement.api.model.operator.v1.GenerationStatusBuilder;
import io.fabric8.openclustermanagement.api.model.operator.v1.GenerationStatusFluentImpl;
import io.fabric8.openclustermanagement.api.model.operator.v1.RelatedResourceMeta;
import io.fabric8.openclustermanagement.api.model.operator.v1.RelatedResourceMetaBuilder;
import io.fabric8.openclustermanagement.api.model.operator.v1.RelatedResourceMetaFluentImpl;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Iterator;
import java.util.List;
import java.util.Objects;
import java.util.function.Predicate;

public class ClusterManagerStatusFluentImpl<A extends ClusterManagerStatusFluent<A>>
extends BaseFluent<A>
implements ClusterManagerStatusFluent<A> {
    private List<Condition> conditions = new ArrayList<Condition>();
    private ArrayList<GenerationStatusBuilder> generations = new ArrayList();
    private Long observedGeneration;
    private ArrayList<RelatedResourceMetaBuilder> relatedResources = new ArrayList();

    public ClusterManagerStatusFluentImpl() {
    }

    public ClusterManagerStatusFluentImpl(ClusterManagerStatus instance) {
        this.withConditions(instance.getConditions());
        this.withGenerations(instance.getGenerations());
        this.withObservedGeneration(instance.getObservedGeneration());
        this.withRelatedResources(instance.getRelatedResources());
    }

    @Override
    public A addToConditions(Integer index, Condition item) {
        if (this.conditions == null) {
            this.conditions = new ArrayList<Condition>();
        }
        this.conditions.add(index, item);
        return (A)this;
    }

    @Override
    public A setToConditions(Integer index, Condition item) {
        if (this.conditions == null) {
            this.conditions = new ArrayList<Condition>();
        }
        this.conditions.set(index, item);
        return (A)this;
    }

    @Override
    public A addToConditions(Condition ... items) {
        if (this.conditions == null) {
            this.conditions = new ArrayList<Condition>();
        }
        for (Condition item : items) {
            this.conditions.add(item);
        }
        return (A)this;
    }

    @Override
    public A addAllToConditions(Collection<Condition> items) {
        if (this.conditions == null) {
            this.conditions = new ArrayList<Condition>();
        }
        for (Condition item : items) {
            this.conditions.add(item);
        }
        return (A)this;
    }

    @Override
    public A removeFromConditions(Condition ... items) {
        for (Condition item : items) {
            if (this.conditions == null) continue;
            this.conditions.remove(item);
        }
        return (A)this;
    }

    @Override
    public A removeAllFromConditions(Collection<Condition> items) {
        for (Condition item : items) {
            if (this.conditions == null) continue;
            this.conditions.remove(item);
        }
        return (A)this;
    }

    @Override
    public List<Condition> getConditions() {
        return this.conditions;
    }

    @Override
    public Condition getCondition(Integer index) {
        return this.conditions.get(index);
    }

    @Override
    public Condition getFirstCondition() {
        return this.conditions.get(0);
    }

    @Override
    public Condition getLastCondition() {
        return this.conditions.get(this.conditions.size() - 1);
    }

    @Override
    public Condition getMatchingCondition(Predicate<Condition> predicate) {
        for (Condition item : this.conditions) {
            if (!predicate.test(item)) continue;
            return item;
        }
        return null;
    }

    @Override
    public Boolean hasMatchingCondition(Predicate<Condition> predicate) {
        for (Condition item : this.conditions) {
            if (!predicate.test(item)) continue;
            return true;
        }
        return false;
    }

    @Override
    public A withConditions(List<Condition> conditions) {
        if (conditions != null) {
            this.conditions = new ArrayList<Condition>();
            for (Condition item : conditions) {
                this.addToConditions(item);
            }
        } else {
            this.conditions = null;
        }
        return (A)this;
    }

    @Override
    public A withConditions(Condition ... conditions) {
        if (this.conditions != null) {
            this.conditions.clear();
        }
        if (conditions != null) {
            for (Condition item : conditions) {
                this.addToConditions(item);
            }
        }
        return (A)this;
    }

    @Override
    public Boolean hasConditions() {
        return this.conditions != null && !this.conditions.isEmpty();
    }

    @Override
    public A addToGenerations(Integer index, GenerationStatus item) {
        if (this.generations == null) {
            this.generations = new ArrayList();
        }
        GenerationStatusBuilder builder = new GenerationStatusBuilder(item);
        this._visitables.get((Object)"generations").add(index >= 0 ? index.intValue() : this._visitables.get((Object)"generations").size(), builder);
        this.generations.add(index >= 0 ? index.intValue() : this.generations.size(), builder);
        return (A)this;
    }

    @Override
    public A setToGenerations(Integer index, GenerationStatus item) {
        if (this.generations == null) {
            this.generations = new ArrayList();
        }
        GenerationStatusBuilder builder = new GenerationStatusBuilder(item);
        if (index < 0 || index >= this._visitables.get((Object)"generations").size()) {
            this._visitables.get((Object)"generations").add(builder);
        } else {
            this._visitables.get((Object)"generations").set(index, builder);
        }
        if (index < 0 || index >= this.generations.size()) {
            this.generations.add(builder);
        } else {
            this.generations.set(index, builder);
        }
        return (A)this;
    }

    @Override
    public A addToGenerations(GenerationStatus ... items) {
        if (this.generations == null) {
            this.generations = new ArrayList();
        }
        for (GenerationStatus item : items) {
            GenerationStatusBuilder builder = new GenerationStatusBuilder(item);
            this._visitables.get((Object)"generations").add(builder);
            this.generations.add(builder);
        }
        return (A)this;
    }

    @Override
    public A addAllToGenerations(Collection<GenerationStatus> items) {
        if (this.generations == null) {
            this.generations = new ArrayList();
        }
        for (GenerationStatus item : items) {
            GenerationStatusBuilder builder = new GenerationStatusBuilder(item);
            this._visitables.get((Object)"generations").add(builder);
            this.generations.add(builder);
        }
        return (A)this;
    }

    @Override
    public A removeFromGenerations(GenerationStatus ... items) {
        for (GenerationStatus item : items) {
            GenerationStatusBuilder builder = new GenerationStatusBuilder(item);
            this._visitables.get((Object)"generations").remove(builder);
            if (this.generations == null) continue;
            this.generations.remove(builder);
        }
        return (A)this;
    }

    @Override
    public A removeAllFromGenerations(Collection<GenerationStatus> items) {
        for (GenerationStatus item : items) {
            GenerationStatusBuilder builder = new GenerationStatusBuilder(item);
            this._visitables.get((Object)"generations").remove(builder);
            if (this.generations == null) continue;
            this.generations.remove(builder);
        }
        return (A)this;
    }

    @Override
    public A removeMatchingFromGenerations(Predicate<GenerationStatusBuilder> predicate) {
        if (this.generations == null) {
            return (A)this;
        }
        Iterator<GenerationStatusBuilder> each = this.generations.iterator();
        List visitables = this._visitables.get((Object)"generations");
        while (each.hasNext()) {
            GenerationStatusBuilder builder = each.next();
            if (!predicate.test(builder)) continue;
            visitables.remove(builder);
            each.remove();
        }
        return (A)this;
    }

    @Override
    @Deprecated
    public List<GenerationStatus> getGenerations() {
        return this.generations != null ? ClusterManagerStatusFluentImpl.build(this.generations) : null;
    }

    @Override
    public List<GenerationStatus> buildGenerations() {
        return this.generations != null ? ClusterManagerStatusFluentImpl.build(this.generations) : null;
    }

    @Override
    public GenerationStatus buildGeneration(Integer index) {
        return this.generations.get(index).build();
    }

    @Override
    public GenerationStatus buildFirstGeneration() {
        return this.generations.get(0).build();
    }

    @Override
    public GenerationStatus buildLastGeneration() {
        return this.generations.get(this.generations.size() - 1).build();
    }

    @Override
    public GenerationStatus buildMatchingGeneration(Predicate<GenerationStatusBuilder> predicate) {
        for (GenerationStatusBuilder item : this.generations) {
            if (!predicate.test(item)) continue;
            return item.build();
        }
        return null;
    }

    @Override
    public Boolean hasMatchingGeneration(Predicate<GenerationStatusBuilder> predicate) {
        for (GenerationStatusBuilder item : this.generations) {
            if (!predicate.test(item)) continue;
            return true;
        }
        return false;
    }

    @Override
    public A withGenerations(List<GenerationStatus> generations) {
        if (this.generations != null) {
            this._visitables.get((Object)"generations").removeAll(this.generations);
        }
        if (generations != null) {
            this.generations = new ArrayList();
            for (GenerationStatus item : generations) {
                this.addToGenerations(item);
            }
        } else {
            this.generations = null;
        }
        return (A)this;
    }

    @Override
    public A withGenerations(GenerationStatus ... generations) {
        if (this.generations != null) {
            this.generations.clear();
        }
        if (generations != null) {
            for (GenerationStatus item : generations) {
                this.addToGenerations(item);
            }
        }
        return (A)this;
    }

    @Override
    public Boolean hasGenerations() {
        return this.generations != null && !this.generations.isEmpty();
    }

    @Override
    public ClusterManagerStatusFluent.GenerationsNested<A> addNewGeneration() {
        return new GenerationsNestedImpl();
    }

    @Override
    public ClusterManagerStatusFluent.GenerationsNested<A> addNewGenerationLike(GenerationStatus item) {
        return new GenerationsNestedImpl(-1, item);
    }

    @Override
    public ClusterManagerStatusFluent.GenerationsNested<A> setNewGenerationLike(Integer index, GenerationStatus item) {
        return new GenerationsNestedImpl(index, item);
    }

    @Override
    public ClusterManagerStatusFluent.GenerationsNested<A> editGeneration(Integer index) {
        if (this.generations.size() <= index) {
            throw new RuntimeException("Can't edit generations. Index exceeds size.");
        }
        return this.setNewGenerationLike(index, this.buildGeneration(index));
    }

    @Override
    public ClusterManagerStatusFluent.GenerationsNested<A> editFirstGeneration() {
        if (this.generations.size() == 0) {
            throw new RuntimeException("Can't edit first generations. The list is empty.");
        }
        return this.setNewGenerationLike(0, this.buildGeneration(0));
    }

    @Override
    public ClusterManagerStatusFluent.GenerationsNested<A> editLastGeneration() {
        int index = this.generations.size() - 1;
        if (index < 0) {
            throw new RuntimeException("Can't edit last generations. The list is empty.");
        }
        return this.setNewGenerationLike(index, this.buildGeneration(index));
    }

    @Override
    public ClusterManagerStatusFluent.GenerationsNested<A> editMatchingGeneration(Predicate<GenerationStatusBuilder> predicate) {
        int index = -1;
        for (int i = 0; i < this.generations.size(); ++i) {
            if (!predicate.test(this.generations.get(i))) continue;
            index = i;
            break;
        }
        if (index < 0) {
            throw new RuntimeException("Can't edit matching generations. No match found.");
        }
        return this.setNewGenerationLike(index, this.buildGeneration(index));
    }

    @Override
    public Long getObservedGeneration() {
        return this.observedGeneration;
    }

    @Override
    public A withObservedGeneration(Long observedGeneration) {
        this.observedGeneration = observedGeneration;
        return (A)this;
    }

    @Override
    public Boolean hasObservedGeneration() {
        return this.observedGeneration != null;
    }

    @Override
    public A addToRelatedResources(Integer index, RelatedResourceMeta item) {
        if (this.relatedResources == null) {
            this.relatedResources = new ArrayList();
        }
        RelatedResourceMetaBuilder builder = new RelatedResourceMetaBuilder(item);
        this._visitables.get((Object)"relatedResources").add(index >= 0 ? index.intValue() : this._visitables.get((Object)"relatedResources").size(), builder);
        this.relatedResources.add(index >= 0 ? index.intValue() : this.relatedResources.size(), builder);
        return (A)this;
    }

    @Override
    public A setToRelatedResources(Integer index, RelatedResourceMeta item) {
        if (this.relatedResources == null) {
            this.relatedResources = new ArrayList();
        }
        RelatedResourceMetaBuilder builder = new RelatedResourceMetaBuilder(item);
        if (index < 0 || index >= this._visitables.get((Object)"relatedResources").size()) {
            this._visitables.get((Object)"relatedResources").add(builder);
        } else {
            this._visitables.get((Object)"relatedResources").set(index, builder);
        }
        if (index < 0 || index >= this.relatedResources.size()) {
            this.relatedResources.add(builder);
        } else {
            this.relatedResources.set(index, builder);
        }
        return (A)this;
    }

    @Override
    public A addToRelatedResources(RelatedResourceMeta ... items) {
        if (this.relatedResources == null) {
            this.relatedResources = new ArrayList();
        }
        for (RelatedResourceMeta item : items) {
            RelatedResourceMetaBuilder builder = new RelatedResourceMetaBuilder(item);
            this._visitables.get((Object)"relatedResources").add(builder);
            this.relatedResources.add(builder);
        }
        return (A)this;
    }

    @Override
    public A addAllToRelatedResources(Collection<RelatedResourceMeta> items) {
        if (this.relatedResources == null) {
            this.relatedResources = new ArrayList();
        }
        for (RelatedResourceMeta item : items) {
            RelatedResourceMetaBuilder builder = new RelatedResourceMetaBuilder(item);
            this._visitables.get((Object)"relatedResources").add(builder);
            this.relatedResources.add(builder);
        }
        return (A)this;
    }

    @Override
    public A removeFromRelatedResources(RelatedResourceMeta ... items) {
        for (RelatedResourceMeta item : items) {
            RelatedResourceMetaBuilder builder = new RelatedResourceMetaBuilder(item);
            this._visitables.get((Object)"relatedResources").remove(builder);
            if (this.relatedResources == null) continue;
            this.relatedResources.remove(builder);
        }
        return (A)this;
    }

    @Override
    public A removeAllFromRelatedResources(Collection<RelatedResourceMeta> items) {
        for (RelatedResourceMeta item : items) {
            RelatedResourceMetaBuilder builder = new RelatedResourceMetaBuilder(item);
            this._visitables.get((Object)"relatedResources").remove(builder);
            if (this.relatedResources == null) continue;
            this.relatedResources.remove(builder);
        }
        return (A)this;
    }

    @Override
    public A removeMatchingFromRelatedResources(Predicate<RelatedResourceMetaBuilder> predicate) {
        if (this.relatedResources == null) {
            return (A)this;
        }
        Iterator<RelatedResourceMetaBuilder> each = this.relatedResources.iterator();
        List visitables = this._visitables.get((Object)"relatedResources");
        while (each.hasNext()) {
            RelatedResourceMetaBuilder builder = each.next();
            if (!predicate.test(builder)) continue;
            visitables.remove(builder);
            each.remove();
        }
        return (A)this;
    }

    @Override
    @Deprecated
    public List<RelatedResourceMeta> getRelatedResources() {
        return this.relatedResources != null ? ClusterManagerStatusFluentImpl.build(this.relatedResources) : null;
    }

    @Override
    public List<RelatedResourceMeta> buildRelatedResources() {
        return this.relatedResources != null ? ClusterManagerStatusFluentImpl.build(this.relatedResources) : null;
    }

    @Override
    public RelatedResourceMeta buildRelatedResource(Integer index) {
        return this.relatedResources.get(index).build();
    }

    @Override
    public RelatedResourceMeta buildFirstRelatedResource() {
        return this.relatedResources.get(0).build();
    }

    @Override
    public RelatedResourceMeta buildLastRelatedResource() {
        return this.relatedResources.get(this.relatedResources.size() - 1).build();
    }

    @Override
    public RelatedResourceMeta buildMatchingRelatedResource(Predicate<RelatedResourceMetaBuilder> predicate) {
        for (RelatedResourceMetaBuilder item : this.relatedResources) {
            if (!predicate.test(item)) continue;
            return item.build();
        }
        return null;
    }

    @Override
    public Boolean hasMatchingRelatedResource(Predicate<RelatedResourceMetaBuilder> predicate) {
        for (RelatedResourceMetaBuilder item : this.relatedResources) {
            if (!predicate.test(item)) continue;
            return true;
        }
        return false;
    }

    @Override
    public A withRelatedResources(List<RelatedResourceMeta> relatedResources) {
        if (this.relatedResources != null) {
            this._visitables.get((Object)"relatedResources").removeAll(this.relatedResources);
        }
        if (relatedResources != null) {
            this.relatedResources = new ArrayList();
            for (RelatedResourceMeta item : relatedResources) {
                this.addToRelatedResources(item);
            }
        } else {
            this.relatedResources = null;
        }
        return (A)this;
    }

    @Override
    public A withRelatedResources(RelatedResourceMeta ... relatedResources) {
        if (this.relatedResources != null) {
            this.relatedResources.clear();
        }
        if (relatedResources != null) {
            for (RelatedResourceMeta item : relatedResources) {
                this.addToRelatedResources(item);
            }
        }
        return (A)this;
    }

    @Override
    public Boolean hasRelatedResources() {
        return this.relatedResources != null && !this.relatedResources.isEmpty();
    }

    @Override
    public A addNewRelatedResource(String group, String name, String namespace, String resource, String version) {
        return this.addToRelatedResources(new RelatedResourceMeta(group, name, namespace, resource, version));
    }

    @Override
    public ClusterManagerStatusFluent.RelatedResourcesNested<A> addNewRelatedResource() {
        return new RelatedResourcesNestedImpl();
    }

    @Override
    public ClusterManagerStatusFluent.RelatedResourcesNested<A> addNewRelatedResourceLike(RelatedResourceMeta item) {
        return new RelatedResourcesNestedImpl(-1, item);
    }

    @Override
    public ClusterManagerStatusFluent.RelatedResourcesNested<A> setNewRelatedResourceLike(Integer index, RelatedResourceMeta item) {
        return new RelatedResourcesNestedImpl(index, item);
    }

    @Override
    public ClusterManagerStatusFluent.RelatedResourcesNested<A> editRelatedResource(Integer index) {
        if (this.relatedResources.size() <= index) {
            throw new RuntimeException("Can't edit relatedResources. Index exceeds size.");
        }
        return this.setNewRelatedResourceLike(index, this.buildRelatedResource(index));
    }

    @Override
    public ClusterManagerStatusFluent.RelatedResourcesNested<A> editFirstRelatedResource() {
        if (this.relatedResources.size() == 0) {
            throw new RuntimeException("Can't edit first relatedResources. The list is empty.");
        }
        return this.setNewRelatedResourceLike(0, this.buildRelatedResource(0));
    }

    @Override
    public ClusterManagerStatusFluent.RelatedResourcesNested<A> editLastRelatedResource() {
        int index = this.relatedResources.size() - 1;
        if (index < 0) {
            throw new RuntimeException("Can't edit last relatedResources. The list is empty.");
        }
        return this.setNewRelatedResourceLike(index, this.buildRelatedResource(index));
    }

    @Override
    public ClusterManagerStatusFluent.RelatedResourcesNested<A> editMatchingRelatedResource(Predicate<RelatedResourceMetaBuilder> predicate) {
        int index = -1;
        for (int i = 0; i < this.relatedResources.size(); ++i) {
            if (!predicate.test(this.relatedResources.get(i))) continue;
            index = i;
            break;
        }
        if (index < 0) {
            throw new RuntimeException("Can't edit matching relatedResources. No match found.");
        }
        return this.setNewRelatedResourceLike(index, this.buildRelatedResource(index));
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        ClusterManagerStatusFluentImpl that = (ClusterManagerStatusFluentImpl)o;
        if (this.conditions != null ? !this.conditions.equals(that.conditions) : that.conditions != null) {
            return false;
        }
        if (this.generations != null ? !this.generations.equals(that.generations) : that.generations != null) {
            return false;
        }
        if (this.observedGeneration != null ? !this.observedGeneration.equals(that.observedGeneration) : that.observedGeneration != null) {
            return false;
        }
        return !(this.relatedResources != null ? !this.relatedResources.equals(that.relatedResources) : that.relatedResources != null);
    }

    public int hashCode() {
        return Objects.hash(this.conditions, this.generations, this.observedGeneration, this.relatedResources, super.hashCode());
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("{");
        if (this.conditions != null && !this.conditions.isEmpty()) {
            sb.append("conditions:");
            sb.append(this.conditions + ",");
        }
        if (this.generations != null && !this.generations.isEmpty()) {
            sb.append("generations:");
            sb.append(this.generations + ",");
        }
        if (this.observedGeneration != null) {
            sb.append("observedGeneration:");
            sb.append(this.observedGeneration + ",");
        }
        if (this.relatedResources != null && !this.relatedResources.isEmpty()) {
            sb.append("relatedResources:");
            sb.append(this.relatedResources);
        }
        sb.append("}");
        return sb.toString();
    }

    class RelatedResourcesNestedImpl<N>
    extends RelatedResourceMetaFluentImpl<ClusterManagerStatusFluent.RelatedResourcesNested<N>>
    implements ClusterManagerStatusFluent.RelatedResourcesNested<N>,
    Nested<N> {
        RelatedResourceMetaBuilder builder;
        Integer index;

        RelatedResourcesNestedImpl(Integer index, RelatedResourceMeta item) {
            this.index = index;
            this.builder = new RelatedResourceMetaBuilder(this, item);
        }

        RelatedResourcesNestedImpl() {
            this.index = -1;
            this.builder = new RelatedResourceMetaBuilder(this);
        }

        @Override
        public N and() {
            return (N)ClusterManagerStatusFluentImpl.this.setToRelatedResources(this.index, this.builder.build());
        }

        @Override
        public N endRelatedResource() {
            return this.and();
        }
    }

    class GenerationsNestedImpl<N>
    extends GenerationStatusFluentImpl<ClusterManagerStatusFluent.GenerationsNested<N>>
    implements ClusterManagerStatusFluent.GenerationsNested<N>,
    Nested<N> {
        GenerationStatusBuilder builder;
        Integer index;

        GenerationsNestedImpl(Integer index, GenerationStatus item) {
            this.index = index;
            this.builder = new GenerationStatusBuilder(this, item);
        }

        GenerationsNestedImpl() {
            this.index = -1;
            this.builder = new GenerationStatusBuilder(this);
        }

        @Override
        public N and() {
            return (N)ClusterManagerStatusFluentImpl.this.setToGenerations(this.index, this.builder.build());
        }

        @Override
        public N endGeneration() {
            return this.and();
        }
    }
}

