package io.fabric8.openclustermanagement.api.model.operator.v1;

import io.fabric8.kubernetes.api.builder.VisitableBuilder;
import java.lang.Boolean;
public class ClusterManagerListBuilder extends ClusterManagerListFluentImpl<ClusterManagerListBuilder> implements VisitableBuilder<ClusterManagerList,ClusterManagerListBuilder>{
  public ClusterManagerListBuilder() {
    this(false);
  }
  public ClusterManagerListBuilder(Boolean validationEnabled) {
    this(new ClusterManagerList(), validationEnabled);
  }
  public ClusterManagerListBuilder(ClusterManagerListFluent<?> fluent) {
    this(fluent, false);
  }
  public ClusterManagerListBuilder(ClusterManagerListFluent<?> fluent,Boolean validationEnabled) {
    this(fluent, new ClusterManagerList(), validationEnabled);
  }
  public ClusterManagerListBuilder(ClusterManagerListFluent<?> fluent,ClusterManagerList instance) {
    this(fluent, instance, false);
  }
  public ClusterManagerListBuilder(ClusterManagerListFluent<?> fluent,ClusterManagerList instance,Boolean validationEnabled) {
    this.fluent = fluent; 
    fluent.withApiVersion(instance.getApiVersion()); 
    fluent.withItems(instance.getItems()); 
    fluent.withKind(instance.getKind()); 
    fluent.withMetadata(instance.getMetadata()); 
    this.validationEnabled = validationEnabled; 
  }
  public ClusterManagerListBuilder(ClusterManagerList instance) {
    this(instance,false);
  }
  public ClusterManagerListBuilder(ClusterManagerList instance,Boolean validationEnabled) {
    this.fluent = this; 
    this.withApiVersion(instance.getApiVersion()); 
    this.withItems(instance.getItems()); 
    this.withKind(instance.getKind()); 
    this.withMetadata(instance.getMetadata()); 
    this.validationEnabled = validationEnabled; 
  }
  ClusterManagerListFluent<?> fluent;
  Boolean validationEnabled;
  public ClusterManagerList build() {
    ClusterManagerList buildable = new ClusterManagerList(fluent.getApiVersion(),fluent.getItems(),fluent.getKind(),fluent.getMetadata());
    return buildable;
  }
  
}