package io.fabric8.openclustermanagement.api.model.operator.v1;

import io.fabric8.kubernetes.api.builder.VisitableBuilder;
public class NodePlacementBuilder extends NodePlacementFluent<NodePlacementBuilder> implements VisitableBuilder<NodePlacement,NodePlacementBuilder>{
  public NodePlacementBuilder() {
    this(new NodePlacement());
  }
  
  public NodePlacementBuilder(NodePlacementFluent<?> fluent) {
    this(fluent, new NodePlacement());
  }
  
  public NodePlacementBuilder(NodePlacementFluent<?> fluent,NodePlacement instance) {
    this.fluent = fluent;
    fluent.copyInstance(instance);
  }
  
  public NodePlacementBuilder(NodePlacement instance) {
    this.fluent = this;
    this.copyInstance(instance);
  }
  NodePlacementFluent<?> fluent;
  
  public NodePlacement build() {
    NodePlacement buildable = new NodePlacement(fluent.getNodeSelector(),fluent.getTolerations());
    buildable.setAdditionalProperties(fluent.getAdditionalProperties());
    return buildable;
  }
  

}