package io.fabric8.openclustermanagement.api.model.operator.v1;

import java.lang.SuppressWarnings;
import io.fabric8.kubernetes.api.builder.Nested;
import java.lang.String;
import java.util.LinkedHashMap;
import io.fabric8.kubernetes.api.builder.BaseFluent;
import java.lang.Object;
import java.util.Map;

/**
 * Generated
 */
@SuppressWarnings("unchecked")
public class ClusterManagerSpecFluent<A extends ClusterManagerSpecFluent<A>> extends BaseFluent<A>{
  public ClusterManagerSpecFluent() {
  }
  
  public ClusterManagerSpecFluent(ClusterManagerSpec instance) {
    this.copyInstance(instance);
  }
  private NodePlacementBuilder nodePlacement;
  private String placementImagePullSpec;
  private String registrationImagePullSpec;
  private String workImagePullSpec;
  private Map<String,Object> additionalProperties;
  
  protected void copyInstance(ClusterManagerSpec instance) {
    instance = (instance != null ? instance : new ClusterManagerSpec());
    if (instance != null) {
          this.withNodePlacement(instance.getNodePlacement());
          this.withPlacementImagePullSpec(instance.getPlacementImagePullSpec());
          this.withRegistrationImagePullSpec(instance.getRegistrationImagePullSpec());
          this.withWorkImagePullSpec(instance.getWorkImagePullSpec());
          this.withAdditionalProperties(instance.getAdditionalProperties());
        }
  }
  
  public NodePlacement buildNodePlacement() {
    return this.nodePlacement != null ? this.nodePlacement.build() : null;
  }
  
  public A withNodePlacement(NodePlacement nodePlacement) {
    this._visitables.remove("nodePlacement");
    if (nodePlacement != null) {
        this.nodePlacement = new NodePlacementBuilder(nodePlacement);
        this._visitables.get("nodePlacement").add(this.nodePlacement);
    } else {
        this.nodePlacement = null;
        this._visitables.get("nodePlacement").remove(this.nodePlacement);
    }
    return (A) this;
  }
  
  public boolean hasNodePlacement() {
    return this.nodePlacement != null;
  }
  
  public NodePlacementNested<A> withNewNodePlacement() {
    return new NodePlacementNested(null);
  }
  
  public NodePlacementNested<A> withNewNodePlacementLike(NodePlacement item) {
    return new NodePlacementNested(item);
  }
  
  public NodePlacementNested<A> editNodePlacement() {
    return withNewNodePlacementLike(java.util.Optional.ofNullable(buildNodePlacement()).orElse(null));
  }
  
  public NodePlacementNested<A> editOrNewNodePlacement() {
    return withNewNodePlacementLike(java.util.Optional.ofNullable(buildNodePlacement()).orElse(new NodePlacementBuilder().build()));
  }
  
  public NodePlacementNested<A> editOrNewNodePlacementLike(NodePlacement item) {
    return withNewNodePlacementLike(java.util.Optional.ofNullable(buildNodePlacement()).orElse(item));
  }
  
  public String getPlacementImagePullSpec() {
    return this.placementImagePullSpec;
  }
  
  public A withPlacementImagePullSpec(String placementImagePullSpec) {
    this.placementImagePullSpec = placementImagePullSpec;
    return (A) this;
  }
  
  public boolean hasPlacementImagePullSpec() {
    return this.placementImagePullSpec != null;
  }
  
  public String getRegistrationImagePullSpec() {
    return this.registrationImagePullSpec;
  }
  
  public A withRegistrationImagePullSpec(String registrationImagePullSpec) {
    this.registrationImagePullSpec = registrationImagePullSpec;
    return (A) this;
  }
  
  public boolean hasRegistrationImagePullSpec() {
    return this.registrationImagePullSpec != null;
  }
  
  public String getWorkImagePullSpec() {
    return this.workImagePullSpec;
  }
  
  public A withWorkImagePullSpec(String workImagePullSpec) {
    this.workImagePullSpec = workImagePullSpec;
    return (A) this;
  }
  
  public boolean hasWorkImagePullSpec() {
    return this.workImagePullSpec != null;
  }
  
  public A addToAdditionalProperties(String key,Object value) {
    if(this.additionalProperties == null && key != null && value != null) { this.additionalProperties = new LinkedHashMap(); }
    if(key != null && value != null) {this.additionalProperties.put(key, value);} return (A)this;
  }
  
  public A addToAdditionalProperties(Map<String,Object> map) {
    if(this.additionalProperties == null && map != null) { this.additionalProperties = new LinkedHashMap(); }
    if(map != null) { this.additionalProperties.putAll(map);} return (A)this;
  }
  
  public A removeFromAdditionalProperties(String key) {
    if(this.additionalProperties == null) { return (A) this; }
    if(key != null && this.additionalProperties != null) {this.additionalProperties.remove(key);} return (A)this;
  }
  
  public A removeFromAdditionalProperties(Map<String,Object> map) {
    if(this.additionalProperties == null) { return (A) this; }
    if(map != null) { for(Object key : map.keySet()) {if (this.additionalProperties != null){this.additionalProperties.remove(key);}}} return (A)this;
  }
  
  public Map<String,Object> getAdditionalProperties() {
    return this.additionalProperties;
  }
  
  public <K,V>A withAdditionalProperties(Map<String,Object> additionalProperties) {
    if (additionalProperties == null) {
      this.additionalProperties = null;
    } else {
      this.additionalProperties = new LinkedHashMap(additionalProperties);
    }
    return (A) this;
  }
  
  public boolean hasAdditionalProperties() {
    return this.additionalProperties != null;
  }
  
  public boolean equals(Object o) {
    if (this == o) return true;
    if (o == null || getClass() != o.getClass()) return false;
    if (!super.equals(o)) return false;
    ClusterManagerSpecFluent that = (ClusterManagerSpecFluent) o;
    if (!java.util.Objects.equals(nodePlacement, that.nodePlacement)) return false;
    if (!java.util.Objects.equals(placementImagePullSpec, that.placementImagePullSpec)) return false;
    if (!java.util.Objects.equals(registrationImagePullSpec, that.registrationImagePullSpec)) return false;
    if (!java.util.Objects.equals(workImagePullSpec, that.workImagePullSpec)) return false;
    if (!java.util.Objects.equals(additionalProperties, that.additionalProperties)) return false;
    return true;
  }
  
  public int hashCode() {
    return java.util.Objects.hash(nodePlacement,  placementImagePullSpec,  registrationImagePullSpec,  workImagePullSpec,  additionalProperties,  super.hashCode());
  }
  
  public String toString() {
    StringBuilder sb = new StringBuilder();
    sb.append("{");
    if (nodePlacement != null) { sb.append("nodePlacement:"); sb.append(nodePlacement + ","); }
    if (placementImagePullSpec != null) { sb.append("placementImagePullSpec:"); sb.append(placementImagePullSpec + ","); }
    if (registrationImagePullSpec != null) { sb.append("registrationImagePullSpec:"); sb.append(registrationImagePullSpec + ","); }
    if (workImagePullSpec != null) { sb.append("workImagePullSpec:"); sb.append(workImagePullSpec + ","); }
    if (additionalProperties != null && !additionalProperties.isEmpty()) { sb.append("additionalProperties:"); sb.append(additionalProperties); }
    sb.append("}");
    return sb.toString();
  }
  public class NodePlacementNested<N> extends NodePlacementFluent<NodePlacementNested<N>> implements Nested<N>{
    NodePlacementNested(NodePlacement item) {
      this.builder = new NodePlacementBuilder(this, item);
    }
    NodePlacementBuilder builder;
    
    public N and() {
      return (N) ClusterManagerSpecFluent.this.withNodePlacement(builder.build());
    }
    
    public N endNodePlacement() {
      return and();
    }
    
  
  }

}