package io.fabric8.openclustermanagement.api.model.multiclusterhub.operator.v1;

import io.fabric8.kubernetes.api.builder.VisitableBuilder;
public class ExternalDNSConfigBuilder extends ExternalDNSConfigFluent<ExternalDNSConfigBuilder> implements VisitableBuilder<ExternalDNSConfig,ExternalDNSConfigBuilder>{
  public ExternalDNSConfigBuilder() {
    this(new ExternalDNSConfig());
  }
  
  public ExternalDNSConfigBuilder(ExternalDNSConfigFluent<?> fluent) {
    this(fluent, new ExternalDNSConfig());
  }
  
  public ExternalDNSConfigBuilder(ExternalDNSConfigFluent<?> fluent,ExternalDNSConfig instance) {
    this.fluent = fluent;
    fluent.copyInstance(instance);
  }
  
  public ExternalDNSConfigBuilder(ExternalDNSConfig instance) {
    this.fluent = this;
    this.copyInstance(instance);
  }
  ExternalDNSConfigFluent<?> fluent;
  
  public ExternalDNSConfig build() {
    ExternalDNSConfig buildable = new ExternalDNSConfig(fluent.buildAws(),fluent.buildGcp());
    buildable.setAdditionalProperties(fluent.getAdditionalProperties());
    return buildable;
  }
  

}