package io.fabric8.openclustermanagement.api.model.operator.v1;

import io.fabric8.kubernetes.api.builder.VisitableBuilder;
public class KlusterletStatusBuilder extends KlusterletStatusFluent<KlusterletStatusBuilder> implements VisitableBuilder<KlusterletStatus,KlusterletStatusBuilder>{
  public KlusterletStatusBuilder() {
    this(new KlusterletStatus());
  }
  
  public KlusterletStatusBuilder(KlusterletStatusFluent<?> fluent) {
    this(fluent, new KlusterletStatus());
  }
  
  public KlusterletStatusBuilder(KlusterletStatusFluent<?> fluent,KlusterletStatus instance) {
    this.fluent = fluent;
    fluent.copyInstance(instance);
  }
  
  public KlusterletStatusBuilder(KlusterletStatus instance) {
    this.fluent = this;
    this.copyInstance(instance);
  }
  KlusterletStatusFluent<?> fluent;
  
  public KlusterletStatus build() {
    KlusterletStatus buildable = new KlusterletStatus(fluent.getConditions(),fluent.buildGenerations(),fluent.getObservedGeneration(),fluent.buildRelatedResources());
    buildable.setAdditionalProperties(fluent.getAdditionalProperties());
    return buildable;
  }
  

}