package io.fabric8.openclustermanagement.api.model.multiclusterhub.operator.v1;

import io.fabric8.kubernetes.api.builder.VisitableBuilder;
import java.lang.SuppressWarnings;
import io.fabric8.kubernetes.api.builder.Nested;
import java.util.ArrayList;
import java.lang.String;
import java.util.LinkedHashMap;
import java.util.function.Predicate;
import io.fabric8.kubernetes.api.builder.BaseFluent;
import java.util.Iterator;
import java.util.Collection;
import java.lang.Object;
import java.util.List;
import java.util.Map;

/**
 * Generated
 */
@SuppressWarnings("unchecked")
public class MultiClusterHubStatusFluent<A extends MultiClusterHubStatusFluent<A>> extends BaseFluent<A>{
  public MultiClusterHubStatusFluent() {
  }
  
  public MultiClusterHubStatusFluent(MultiClusterHubStatus instance) {
    this.copyInstance(instance);
  }
  private Map<String,StatusCondition> components;
  private ArrayList<HubConditionBuilder> conditions = new ArrayList<HubConditionBuilder>();
  private String currentVersion;
  private String desiredVersion;
  private String phase;
  private Map<String,Object> additionalProperties;
  
  protected void copyInstance(MultiClusterHubStatus instance) {
    instance = (instance != null ? instance : new MultiClusterHubStatus());
    if (instance != null) {
          this.withComponents(instance.getComponents());
          this.withConditions(instance.getConditions());
          this.withCurrentVersion(instance.getCurrentVersion());
          this.withDesiredVersion(instance.getDesiredVersion());
          this.withPhase(instance.getPhase());
          this.withAdditionalProperties(instance.getAdditionalProperties());
        }
  }
  
  public A addToComponents(String key,StatusCondition value) {
    if(this.components == null && key != null && value != null) { this.components = new LinkedHashMap(); }
    if(key != null && value != null) {this.components.put(key, value);} return (A)this;
  }
  
  public A addToComponents(Map<String,StatusCondition> map) {
    if(this.components == null && map != null) { this.components = new LinkedHashMap(); }
    if(map != null) { this.components.putAll(map);} return (A)this;
  }
  
  public A removeFromComponents(String key) {
    if(this.components == null) { return (A) this; }
    if(key != null && this.components != null) {this.components.remove(key);} return (A)this;
  }
  
  public A removeFromComponents(Map<String,StatusCondition> map) {
    if(this.components == null) { return (A) this; }
    if(map != null) { for(Object key : map.keySet()) {if (this.components != null){this.components.remove(key);}}} return (A)this;
  }
  
  public Map<String,StatusCondition> getComponents() {
    return this.components;
  }
  
  public <K,V>A withComponents(Map<String,StatusCondition> components) {
    if (components == null) {
      this.components = null;
    } else {
      this.components = new LinkedHashMap(components);
    }
    return (A) this;
  }
  
  public boolean hasComponents() {
    return this.components != null;
  }
  
  public A addToConditions(int index,HubCondition item) {
    if (this.conditions == null) {this.conditions = new ArrayList<HubConditionBuilder>();}
    HubConditionBuilder builder = new HubConditionBuilder(item);
    if (index < 0 || index >= conditions.size()) { _visitables.get("conditions").add(builder); conditions.add(builder); } else { _visitables.get("conditions").add(index, builder); conditions.add(index, builder);}
    return (A)this;
  }
  
  public A setToConditions(int index,HubCondition item) {
    if (this.conditions == null) {this.conditions = new ArrayList<HubConditionBuilder>();}
    HubConditionBuilder builder = new HubConditionBuilder(item);
    if (index < 0 || index >= conditions.size()) { _visitables.get("conditions").add(builder); conditions.add(builder); } else { _visitables.get("conditions").set(index, builder); conditions.set(index, builder);}
    return (A)this;
  }
  
  public A addToConditions(io.fabric8.openclustermanagement.api.model.multiclusterhub.operator.v1.HubCondition... items) {
    if (this.conditions == null) {this.conditions = new ArrayList<HubConditionBuilder>();}
    for (HubCondition item : items) {HubConditionBuilder builder = new HubConditionBuilder(item);_visitables.get("conditions").add(builder);this.conditions.add(builder);} return (A)this;
  }
  
  public A addAllToConditions(Collection<HubCondition> items) {
    if (this.conditions == null) {this.conditions = new ArrayList<HubConditionBuilder>();}
    for (HubCondition item : items) {HubConditionBuilder builder = new HubConditionBuilder(item);_visitables.get("conditions").add(builder);this.conditions.add(builder);} return (A)this;
  }
  
  public A removeFromConditions(io.fabric8.openclustermanagement.api.model.multiclusterhub.operator.v1.HubCondition... items) {
    if (this.conditions == null) return (A)this;
    for (HubCondition item : items) {HubConditionBuilder builder = new HubConditionBuilder(item);_visitables.get("conditions").remove(builder); this.conditions.remove(builder);} return (A)this;
  }
  
  public A removeAllFromConditions(Collection<HubCondition> items) {
    if (this.conditions == null) return (A)this;
    for (HubCondition item : items) {HubConditionBuilder builder = new HubConditionBuilder(item);_visitables.get("conditions").remove(builder); this.conditions.remove(builder);} return (A)this;
  }
  
  public A removeMatchingFromConditions(Predicate<HubConditionBuilder> predicate) {
    if (conditions == null) return (A) this;
    final Iterator<HubConditionBuilder> each = conditions.iterator();
    final List visitables = _visitables.get("conditions");
    while (each.hasNext()) {
      HubConditionBuilder builder = each.next();
      if (predicate.test(builder)) {
        visitables.remove(builder);
        each.remove();
      }
    }
    return (A)this;
  }
  
  public List<HubCondition> buildConditions() {
    return this.conditions != null ? build(conditions) : null;
  }
  
  public HubCondition buildCondition(int index) {
    return this.conditions.get(index).build();
  }
  
  public HubCondition buildFirstCondition() {
    return this.conditions.get(0).build();
  }
  
  public HubCondition buildLastCondition() {
    return this.conditions.get(conditions.size() - 1).build();
  }
  
  public HubCondition buildMatchingCondition(Predicate<HubConditionBuilder> predicate) {
      for (HubConditionBuilder item : conditions) {
        if (predicate.test(item)) {
          return item.build();
        }
      }
      return null;
  }
  
  public boolean hasMatchingCondition(Predicate<HubConditionBuilder> predicate) {
      for (HubConditionBuilder item : conditions) {
        if (predicate.test(item)) {
          return true;
        }
      }
      return false;
  }
  
  public A withConditions(List<HubCondition> conditions) {
    if (this.conditions != null) {
      this._visitables.get("conditions").clear();
    }
    if (conditions != null) {
        this.conditions = new ArrayList();
        for (HubCondition item : conditions) {
          this.addToConditions(item);
        }
    } else {
      this.conditions = null;
    }
    return (A) this;
  }
  
  public A withConditions(io.fabric8.openclustermanagement.api.model.multiclusterhub.operator.v1.HubCondition... conditions) {
    if (this.conditions != null) {
        this.conditions.clear();
        _visitables.remove("conditions");
    }
    if (conditions != null) {
      for (HubCondition item : conditions) {
        this.addToConditions(item);
      }
    }
    return (A) this;
  }
  
  public boolean hasConditions() {
    return this.conditions != null && !this.conditions.isEmpty();
  }
  
  public ConditionsNested<A> addNewCondition() {
    return new ConditionsNested(-1, null);
  }
  
  public ConditionsNested<A> addNewConditionLike(HubCondition item) {
    return new ConditionsNested(-1, item);
  }
  
  public ConditionsNested<A> setNewConditionLike(int index,HubCondition item) {
    return new ConditionsNested(index, item);
  }
  
  public ConditionsNested<A> editCondition(int index) {
    if (conditions.size() <= index) throw new RuntimeException("Can't edit conditions. Index exceeds size.");
    return setNewConditionLike(index, buildCondition(index));
  }
  
  public ConditionsNested<A> editFirstCondition() {
    if (conditions.size() == 0) throw new RuntimeException("Can't edit first conditions. The list is empty.");
    return setNewConditionLike(0, buildCondition(0));
  }
  
  public ConditionsNested<A> editLastCondition() {
    int index = conditions.size() - 1;
    if (index < 0) throw new RuntimeException("Can't edit last conditions. The list is empty.");
    return setNewConditionLike(index, buildCondition(index));
  }
  
  public ConditionsNested<A> editMatchingCondition(Predicate<HubConditionBuilder> predicate) {
    int index = -1;
    for (int i=0;i<conditions.size();i++) { 
    if (predicate.test(conditions.get(i))) {index = i; break;}
    } 
    if (index < 0) throw new RuntimeException("Can't edit matching conditions. No match found.");
    return setNewConditionLike(index, buildCondition(index));
  }
  
  public String getCurrentVersion() {
    return this.currentVersion;
  }
  
  public A withCurrentVersion(String currentVersion) {
    this.currentVersion = currentVersion;
    return (A) this;
  }
  
  public boolean hasCurrentVersion() {
    return this.currentVersion != null;
  }
  
  public String getDesiredVersion() {
    return this.desiredVersion;
  }
  
  public A withDesiredVersion(String desiredVersion) {
    this.desiredVersion = desiredVersion;
    return (A) this;
  }
  
  public boolean hasDesiredVersion() {
    return this.desiredVersion != null;
  }
  
  public String getPhase() {
    return this.phase;
  }
  
  public A withPhase(String phase) {
    this.phase = phase;
    return (A) this;
  }
  
  public boolean hasPhase() {
    return this.phase != null;
  }
  
  public A addToAdditionalProperties(String key,Object value) {
    if(this.additionalProperties == null && key != null && value != null) { this.additionalProperties = new LinkedHashMap(); }
    if(key != null && value != null) {this.additionalProperties.put(key, value);} return (A)this;
  }
  
  public A addToAdditionalProperties(Map<String,Object> map) {
    if(this.additionalProperties == null && map != null) { this.additionalProperties = new LinkedHashMap(); }
    if(map != null) { this.additionalProperties.putAll(map);} return (A)this;
  }
  
  public A removeFromAdditionalProperties(String key) {
    if(this.additionalProperties == null) { return (A) this; }
    if(key != null && this.additionalProperties != null) {this.additionalProperties.remove(key);} return (A)this;
  }
  
  public A removeFromAdditionalProperties(Map<String,Object> map) {
    if(this.additionalProperties == null) { return (A) this; }
    if(map != null) { for(Object key : map.keySet()) {if (this.additionalProperties != null){this.additionalProperties.remove(key);}}} return (A)this;
  }
  
  public Map<String,Object> getAdditionalProperties() {
    return this.additionalProperties;
  }
  
  public <K,V>A withAdditionalProperties(Map<String,Object> additionalProperties) {
    if (additionalProperties == null) {
      this.additionalProperties = null;
    } else {
      this.additionalProperties = new LinkedHashMap(additionalProperties);
    }
    return (A) this;
  }
  
  public boolean hasAdditionalProperties() {
    return this.additionalProperties != null;
  }
  
  public boolean equals(Object o) {
    if (this == o) return true;
    if (o == null || getClass() != o.getClass()) return false;
    if (!super.equals(o)) return false;
    MultiClusterHubStatusFluent that = (MultiClusterHubStatusFluent) o;
    if (!java.util.Objects.equals(components, that.components)) return false;
    if (!java.util.Objects.equals(conditions, that.conditions)) return false;
    if (!java.util.Objects.equals(currentVersion, that.currentVersion)) return false;
    if (!java.util.Objects.equals(desiredVersion, that.desiredVersion)) return false;
    if (!java.util.Objects.equals(phase, that.phase)) return false;
    if (!java.util.Objects.equals(additionalProperties, that.additionalProperties)) return false;
    return true;
  }
  
  public int hashCode() {
    return java.util.Objects.hash(components,  conditions,  currentVersion,  desiredVersion,  phase,  additionalProperties,  super.hashCode());
  }
  
  public String toString() {
    StringBuilder sb = new StringBuilder();
    sb.append("{");
    if (components != null && !components.isEmpty()) { sb.append("components:"); sb.append(components + ","); }
    if (conditions != null && !conditions.isEmpty()) { sb.append("conditions:"); sb.append(conditions + ","); }
    if (currentVersion != null) { sb.append("currentVersion:"); sb.append(currentVersion + ","); }
    if (desiredVersion != null) { sb.append("desiredVersion:"); sb.append(desiredVersion + ","); }
    if (phase != null) { sb.append("phase:"); sb.append(phase + ","); }
    if (additionalProperties != null && !additionalProperties.isEmpty()) { sb.append("additionalProperties:"); sb.append(additionalProperties); }
    sb.append("}");
    return sb.toString();
  }
  public class ConditionsNested<N> extends HubConditionFluent<ConditionsNested<N>> implements Nested<N>{
    ConditionsNested(int index,HubCondition item) {
      this.index = index;
      this.builder = new HubConditionBuilder(this, item);
    }
    HubConditionBuilder builder;
    int index;
    
    public N and() {
      return (N) MultiClusterHubStatusFluent.this.setToConditions(index,builder.build());
    }
    
    public N endCondition() {
      return and();
    }
    
  
  }

}