package io.fabric8.openclustermanagement.api.model.multiclusterhub.operator.v1;

import java.lang.SuppressWarnings;
import io.fabric8.kubernetes.api.builder.Nested;
import java.lang.String;
import io.fabric8.kubernetes.api.model.LocalObjectReferenceBuilder;
import java.util.LinkedHashMap;
import io.fabric8.kubernetes.api.model.LocalObjectReference;
import io.fabric8.kubernetes.api.builder.BaseFluent;
import java.lang.Object;
import java.util.Map;
import io.fabric8.kubernetes.api.model.LocalObjectReferenceFluent;

/**
 * Generated
 */
@SuppressWarnings("unchecked")
public class ExternalDNSGCPConfigFluent<A extends ExternalDNSGCPConfigFluent<A>> extends BaseFluent<A>{
  public ExternalDNSGCPConfigFluent() {
  }
  
  public ExternalDNSGCPConfigFluent(ExternalDNSGCPConfig instance) {
    this.copyInstance(instance);
  }
  private LocalObjectReferenceBuilder credentials;
  private Map<String,Object> additionalProperties;
  
  protected void copyInstance(ExternalDNSGCPConfig instance) {
    instance = (instance != null ? instance : new ExternalDNSGCPConfig());
    if (instance != null) {
          this.withCredentials(instance.getCredentials());
          this.withAdditionalProperties(instance.getAdditionalProperties());
        }
  }
  
  public LocalObjectReference buildCredentials() {
    return this.credentials != null ? this.credentials.build() : null;
  }
  
  public A withCredentials(LocalObjectReference credentials) {
    this._visitables.remove("credentials");
    if (credentials != null) {
        this.credentials = new LocalObjectReferenceBuilder(credentials);
        this._visitables.get("credentials").add(this.credentials);
    } else {
        this.credentials = null;
        this._visitables.get("credentials").remove(this.credentials);
    }
    return (A) this;
  }
  
  public boolean hasCredentials() {
    return this.credentials != null;
  }
  
  public A withNewCredentials(String name) {
    return (A)withCredentials(new LocalObjectReference(name));
  }
  
  public CredentialsNested<A> withNewCredentials() {
    return new CredentialsNested(null);
  }
  
  public CredentialsNested<A> withNewCredentialsLike(LocalObjectReference item) {
    return new CredentialsNested(item);
  }
  
  public CredentialsNested<A> editCredentials() {
    return withNewCredentialsLike(java.util.Optional.ofNullable(buildCredentials()).orElse(null));
  }
  
  public CredentialsNested<A> editOrNewCredentials() {
    return withNewCredentialsLike(java.util.Optional.ofNullable(buildCredentials()).orElse(new LocalObjectReferenceBuilder().build()));
  }
  
  public CredentialsNested<A> editOrNewCredentialsLike(LocalObjectReference item) {
    return withNewCredentialsLike(java.util.Optional.ofNullable(buildCredentials()).orElse(item));
  }
  
  public A addToAdditionalProperties(String key,Object value) {
    if(this.additionalProperties == null && key != null && value != null) { this.additionalProperties = new LinkedHashMap(); }
    if(key != null && value != null) {this.additionalProperties.put(key, value);} return (A)this;
  }
  
  public A addToAdditionalProperties(Map<String,Object> map) {
    if(this.additionalProperties == null && map != null) { this.additionalProperties = new LinkedHashMap(); }
    if(map != null) { this.additionalProperties.putAll(map);} return (A)this;
  }
  
  public A removeFromAdditionalProperties(String key) {
    if(this.additionalProperties == null) { return (A) this; }
    if(key != null && this.additionalProperties != null) {this.additionalProperties.remove(key);} return (A)this;
  }
  
  public A removeFromAdditionalProperties(Map<String,Object> map) {
    if(this.additionalProperties == null) { return (A) this; }
    if(map != null) { for(Object key : map.keySet()) {if (this.additionalProperties != null){this.additionalProperties.remove(key);}}} return (A)this;
  }
  
  public Map<String,Object> getAdditionalProperties() {
    return this.additionalProperties;
  }
  
  public <K,V>A withAdditionalProperties(Map<String,Object> additionalProperties) {
    if (additionalProperties == null) {
      this.additionalProperties = null;
    } else {
      this.additionalProperties = new LinkedHashMap(additionalProperties);
    }
    return (A) this;
  }
  
  public boolean hasAdditionalProperties() {
    return this.additionalProperties != null;
  }
  
  public boolean equals(Object o) {
    if (this == o) return true;
    if (o == null || getClass() != o.getClass()) return false;
    if (!super.equals(o)) return false;
    ExternalDNSGCPConfigFluent that = (ExternalDNSGCPConfigFluent) o;
    if (!java.util.Objects.equals(credentials, that.credentials)) return false;
    if (!java.util.Objects.equals(additionalProperties, that.additionalProperties)) return false;
    return true;
  }
  
  public int hashCode() {
    return java.util.Objects.hash(credentials,  additionalProperties,  super.hashCode());
  }
  
  public String toString() {
    StringBuilder sb = new StringBuilder();
    sb.append("{");
    if (credentials != null) { sb.append("credentials:"); sb.append(credentials + ","); }
    if (additionalProperties != null && !additionalProperties.isEmpty()) { sb.append("additionalProperties:"); sb.append(additionalProperties); }
    sb.append("}");
    return sb.toString();
  }
  public class CredentialsNested<N> extends LocalObjectReferenceFluent<CredentialsNested<N>> implements Nested<N>{
    CredentialsNested(LocalObjectReference item) {
      this.builder = new LocalObjectReferenceBuilder(this, item);
    }
    LocalObjectReferenceBuilder builder;
    
    public N and() {
      return (N) ExternalDNSGCPConfigFluent.this.withCredentials(builder.build());
    }
    
    public N endCredentials() {
      return and();
    }
    
  
  }

}