package io.fabric8.openclustermanagement.api.model.multiclusterhub.operator.v1;

import io.fabric8.kubernetes.api.builder.VisitableBuilder;
import java.lang.Boolean;
public class OverridesBuilder extends OverridesFluentImpl<OverridesBuilder> implements VisitableBuilder<Overrides,OverridesBuilder>{
  public OverridesBuilder() {
    this(false);
  }
  public OverridesBuilder(Boolean validationEnabled) {
    this(new Overrides(), validationEnabled);
  }
  public OverridesBuilder(OverridesFluent<?> fluent) {
    this(fluent, false);
  }
  public OverridesBuilder(OverridesFluent<?> fluent,Boolean validationEnabled) {
    this(fluent, new Overrides(), validationEnabled);
  }
  public OverridesBuilder(OverridesFluent<?> fluent,Overrides instance) {
    this(fluent, instance, false);
  }
  public OverridesBuilder(OverridesFluent<?> fluent,Overrides instance,Boolean validationEnabled) {
    this.fluent = fluent; 
    fluent.withImagePullPolicy(instance.getImagePullPolicy()); 
    this.validationEnabled = validationEnabled; 
  }
  public OverridesBuilder(Overrides instance) {
    this(instance,false);
  }
  public OverridesBuilder(Overrides instance,Boolean validationEnabled) {
    this.fluent = this; 
    this.withImagePullPolicy(instance.getImagePullPolicy()); 
    this.validationEnabled = validationEnabled; 
  }
  OverridesFluent<?> fluent;
  Boolean validationEnabled;
  public Overrides build() {
    Overrides buildable = new Overrides(fluent.getImagePullPolicy());
    return buildable;
  }
  
}