package io.fabric8.openclustermanagement.api.model.operator.v1;

import io.fabric8.kubernetes.api.builder.VisitableBuilder;
import java.lang.Boolean;
public class KlusterletBuilder extends KlusterletFluentImpl<KlusterletBuilder> implements VisitableBuilder<Klusterlet,KlusterletBuilder>{
  public KlusterletBuilder() {
    this(false);
  }
  public KlusterletBuilder(Boolean validationEnabled) {
    this(new Klusterlet(), validationEnabled);
  }
  public KlusterletBuilder(KlusterletFluent<?> fluent) {
    this(fluent, false);
  }
  public KlusterletBuilder(KlusterletFluent<?> fluent,Boolean validationEnabled) {
    this(fluent, new Klusterlet(), validationEnabled);
  }
  public KlusterletBuilder(KlusterletFluent<?> fluent,Klusterlet instance) {
    this(fluent, instance, false);
  }
  public KlusterletBuilder(KlusterletFluent<?> fluent,Klusterlet instance,Boolean validationEnabled) {
    this.fluent = fluent; 
    fluent.withApiVersion(instance.getApiVersion()); 
    fluent.withKind(instance.getKind()); 
    fluent.withMetadata(instance.getMetadata()); 
    fluent.withSpec(instance.getSpec()); 
    fluent.withStatus(instance.getStatus()); 
    this.validationEnabled = validationEnabled; 
  }
  public KlusterletBuilder(Klusterlet instance) {
    this(instance,false);
  }
  public KlusterletBuilder(Klusterlet instance,Boolean validationEnabled) {
    this.fluent = this; 
    this.withApiVersion(instance.getApiVersion()); 
    this.withKind(instance.getKind()); 
    this.withMetadata(instance.getMetadata()); 
    this.withSpec(instance.getSpec()); 
    this.withStatus(instance.getStatus()); 
    this.validationEnabled = validationEnabled; 
  }
  KlusterletFluent<?> fluent;
  Boolean validationEnabled;
  public Klusterlet build() {
    Klusterlet buildable = new Klusterlet(fluent.getApiVersion(),fluent.getKind(),fluent.getMetadata(),fluent.getSpec(),fluent.getStatus());
    return buildable;
  }
  
}