package io.fabric8.openclustermanagement.api.model.operator.v1;

import io.fabric8.kubernetes.api.builder.VisitableBuilder;
import java.lang.SuppressWarnings;
import io.fabric8.kubernetes.api.builder.Nested;
import java.util.ArrayList;
import java.lang.String;
import java.util.function.Predicate;
import java.lang.Deprecated;
import io.fabric8.kubernetes.api.builder.BaseFluent;
import java.util.Iterator;
import java.util.List;
import java.lang.Boolean;
import io.fabric8.kubernetes.api.model.Condition;
import java.lang.Integer;
import java.lang.Long;
import java.util.Collection;
import java.lang.Object;

 /**
  * Generated
  */
  @SuppressWarnings(value = "unchecked")
  public class ClusterManagerStatusFluentImpl<A extends ClusterManagerStatusFluent<A>> extends BaseFluent<A> implements ClusterManagerStatusFluent<A>{
  public ClusterManagerStatusFluentImpl() {
  }
  public ClusterManagerStatusFluentImpl(ClusterManagerStatus instance) {
    this.withConditions(instance.getConditions()); 
    this.withGenerations(instance.getGenerations()); 
    this.withObservedGeneration(instance.getObservedGeneration()); 
    this.withRelatedResources(instance.getRelatedResources()); 
  }
  private List<Condition> conditions = new ArrayList<Condition>();
  private ArrayList<GenerationStatusBuilder> generations = new ArrayList<GenerationStatusBuilder>();
  private Long observedGeneration;
  private ArrayList<RelatedResourceMetaBuilder> relatedResources = new ArrayList<RelatedResourceMetaBuilder>();
  public A addToConditions(Integer index,Condition item) {
    if (this.conditions == null) {this.conditions = new ArrayList<Condition>();}
    this.conditions.add(index, item);
    return (A)this;
  }
  public A setToConditions(Integer index,Condition item) {
    if (this.conditions == null) {this.conditions = new ArrayList<Condition>();}
    this.conditions.set(index, item); return (A)this;
  }
  public A addToConditions(io.fabric8.kubernetes.api.model.Condition... items) {
    if (this.conditions == null) {this.conditions = new ArrayList<Condition>();}
    for (Condition item : items) {this.conditions.add(item);} return (A)this;
  }
  public A addAllToConditions(Collection<Condition> items) {
    if (this.conditions == null) {this.conditions = new ArrayList<Condition>();}
    for (Condition item : items) {this.conditions.add(item);} return (A)this;
  }
  public A removeFromConditions(io.fabric8.kubernetes.api.model.Condition... items) {
    for (Condition item : items) {if (this.conditions!= null){ this.conditions.remove(item);}} return (A)this;
  }
  public A removeAllFromConditions(Collection<Condition> items) {
    for (Condition item : items) {if (this.conditions!= null){ this.conditions.remove(item);}} return (A)this;
  }
  public List<Condition> getConditions() {
    return this.conditions;
  }
  public Condition getCondition(Integer index) {
    return this.conditions.get(index);
  }
  public Condition getFirstCondition() {
    return this.conditions.get(0);
  }
  public Condition getLastCondition() {
    return this.conditions.get(conditions.size() - 1);
  }
  public Condition getMatchingCondition(Predicate<Condition> predicate) {
    for (Condition item: conditions) { if(predicate.test(item)){ return item;} } return null;
  }
  public Boolean hasMatchingCondition(Predicate<Condition> predicate) {
    for (Condition item: conditions) { if(predicate.test(item)){ return true;} } return false;
  }
  public A withConditions(List<Condition> conditions) {
    if (conditions != null) {this.conditions = new ArrayList(); for (Condition item : conditions){this.addToConditions(item);}} else { this.conditions = null;} return (A) this;
  }
  public A withConditions(io.fabric8.kubernetes.api.model.Condition... conditions) {
    if (this.conditions != null) {this.conditions.clear();}
    if (conditions != null) {for (Condition item :conditions){ this.addToConditions(item);}} return (A) this;
  }
  public Boolean hasConditions() {
    return conditions != null && !conditions.isEmpty();
  }
  public A addToGenerations(Integer index,GenerationStatus item) {
    if (this.generations == null) {this.generations = new ArrayList<GenerationStatusBuilder>();}
    GenerationStatusBuilder builder = new GenerationStatusBuilder(item);_visitables.get("generations").add(index >= 0 ? index : _visitables.get("generations").size(), builder);this.generations.add(index >= 0 ? index : generations.size(), builder); return (A)this;
  }
  public A setToGenerations(Integer index,GenerationStatus item) {
    if (this.generations == null) {this.generations = new ArrayList<GenerationStatusBuilder>();}
    GenerationStatusBuilder builder = new GenerationStatusBuilder(item);
    if (index < 0 || index >= _visitables.get("generations").size()) { _visitables.get("generations").add(builder); } else { _visitables.get("generations").set(index, builder);}
    if (index < 0 || index >= generations.size()) { generations.add(builder); } else { generations.set(index, builder);}
     return (A)this;
  }
  public A addToGenerations(io.fabric8.openclustermanagement.api.model.operator.v1.GenerationStatus... items) {
    if (this.generations == null) {this.generations = new ArrayList<GenerationStatusBuilder>();}
    for (GenerationStatus item : items) {GenerationStatusBuilder builder = new GenerationStatusBuilder(item);_visitables.get("generations").add(builder);this.generations.add(builder);} return (A)this;
  }
  public A addAllToGenerations(Collection<GenerationStatus> items) {
    if (this.generations == null) {this.generations = new ArrayList<GenerationStatusBuilder>();}
    for (GenerationStatus item : items) {GenerationStatusBuilder builder = new GenerationStatusBuilder(item);_visitables.get("generations").add(builder);this.generations.add(builder);} return (A)this;
  }
  public A removeFromGenerations(io.fabric8.openclustermanagement.api.model.operator.v1.GenerationStatus... items) {
    for (GenerationStatus item : items) {GenerationStatusBuilder builder = new GenerationStatusBuilder(item);_visitables.get("generations").remove(builder);if (this.generations != null) {this.generations.remove(builder);}} return (A)this;
  }
  public A removeAllFromGenerations(Collection<GenerationStatus> items) {
    for (GenerationStatus item : items) {GenerationStatusBuilder builder = new GenerationStatusBuilder(item);_visitables.get("generations").remove(builder);if (this.generations != null) {this.generations.remove(builder);}} return (A)this;
  }
  public A removeMatchingFromGenerations(Predicate<GenerationStatusBuilder> predicate) {
    if (generations == null) return (A) this;
    final Iterator<GenerationStatusBuilder> each = generations.iterator();
    final List visitables = _visitables.get("generations");
    while (each.hasNext()) {
      GenerationStatusBuilder builder = each.next();
      if (predicate.test(builder)) {
        visitables.remove(builder);
        each.remove();
      }
    }
    return (A)this;
  }
  
  /**
   * This method has been deprecated, please use method buildGenerations instead.
   * @return The buildable object.
   */
  @Deprecated
  public List<GenerationStatus> getGenerations() {
    return generations != null ? build(generations) : null;
  }
  public List<GenerationStatus> buildGenerations() {
    return generations != null ? build(generations) : null;
  }
  public GenerationStatus buildGeneration(Integer index) {
    return this.generations.get(index).build();
  }
  public GenerationStatus buildFirstGeneration() {
    return this.generations.get(0).build();
  }
  public GenerationStatus buildLastGeneration() {
    return this.generations.get(generations.size() - 1).build();
  }
  public GenerationStatus buildMatchingGeneration(Predicate<GenerationStatusBuilder> predicate) {
    for (GenerationStatusBuilder item: generations) { if(predicate.test(item)){ return item.build();} } return null;
  }
  public Boolean hasMatchingGeneration(Predicate<GenerationStatusBuilder> predicate) {
    for (GenerationStatusBuilder item: generations) { if(predicate.test(item)){ return true;} } return false;
  }
  public A withGenerations(List<GenerationStatus> generations) {
    if (this.generations != null) { _visitables.get("generations").removeAll(this.generations);}
    if (generations != null) {this.generations = new ArrayList(); for (GenerationStatus item : generations){this.addToGenerations(item);}} else { this.generations = null;} return (A) this;
  }
  public A withGenerations(io.fabric8.openclustermanagement.api.model.operator.v1.GenerationStatus... generations) {
    if (this.generations != null) {this.generations.clear();}
    if (generations != null) {for (GenerationStatus item :generations){ this.addToGenerations(item);}} return (A) this;
  }
  public Boolean hasGenerations() {
    return generations != null && !generations.isEmpty();
  }
  public ClusterManagerStatusFluent.GenerationsNested<A> addNewGeneration() {
    return new ClusterManagerStatusFluentImpl.GenerationsNestedImpl();
  }
  public ClusterManagerStatusFluent.GenerationsNested<A> addNewGenerationLike(GenerationStatus item) {
    return new ClusterManagerStatusFluentImpl.GenerationsNestedImpl(-1, item);
  }
  public ClusterManagerStatusFluent.GenerationsNested<A> setNewGenerationLike(Integer index,GenerationStatus item) {
    return new ClusterManagerStatusFluentImpl.GenerationsNestedImpl(index, item);
  }
  public ClusterManagerStatusFluent.GenerationsNested<A> editGeneration(Integer index) {
    if (generations.size() <= index) throw new RuntimeException("Can't edit generations. Index exceeds size.");
    return setNewGenerationLike(index, buildGeneration(index));
  }
  public ClusterManagerStatusFluent.GenerationsNested<A> editFirstGeneration() {
    if (generations.size() == 0) throw new RuntimeException("Can't edit first generations. The list is empty.");
    return setNewGenerationLike(0, buildGeneration(0));
  }
  public ClusterManagerStatusFluent.GenerationsNested<A> editLastGeneration() {
    int index = generations.size() - 1;
    if (index < 0) throw new RuntimeException("Can't edit last generations. The list is empty.");
    return setNewGenerationLike(index, buildGeneration(index));
  }
  public ClusterManagerStatusFluent.GenerationsNested<A> editMatchingGeneration(Predicate<GenerationStatusBuilder> predicate) {
    int index = -1;
    for (int i=0;i<generations.size();i++) { 
    if (predicate.test(generations.get(i))) {index = i; break;}
    } 
    if (index < 0) throw new RuntimeException("Can't edit matching generations. No match found.");
    return setNewGenerationLike(index, buildGeneration(index));
  }
  public Long getObservedGeneration() {
    return this.observedGeneration;
  }
  public A withObservedGeneration(Long observedGeneration) {
    this.observedGeneration=observedGeneration; return (A) this;
  }
  public Boolean hasObservedGeneration() {
    return this.observedGeneration != null;
  }
  public A addToRelatedResources(Integer index,RelatedResourceMeta item) {
    if (this.relatedResources == null) {this.relatedResources = new ArrayList<RelatedResourceMetaBuilder>();}
    RelatedResourceMetaBuilder builder = new RelatedResourceMetaBuilder(item);_visitables.get("relatedResources").add(index >= 0 ? index : _visitables.get("relatedResources").size(), builder);this.relatedResources.add(index >= 0 ? index : relatedResources.size(), builder); return (A)this;
  }
  public A setToRelatedResources(Integer index,RelatedResourceMeta item) {
    if (this.relatedResources == null) {this.relatedResources = new ArrayList<RelatedResourceMetaBuilder>();}
    RelatedResourceMetaBuilder builder = new RelatedResourceMetaBuilder(item);
    if (index < 0 || index >= _visitables.get("relatedResources").size()) { _visitables.get("relatedResources").add(builder); } else { _visitables.get("relatedResources").set(index, builder);}
    if (index < 0 || index >= relatedResources.size()) { relatedResources.add(builder); } else { relatedResources.set(index, builder);}
     return (A)this;
  }
  public A addToRelatedResources(io.fabric8.openclustermanagement.api.model.operator.v1.RelatedResourceMeta... items) {
    if (this.relatedResources == null) {this.relatedResources = new ArrayList<RelatedResourceMetaBuilder>();}
    for (RelatedResourceMeta item : items) {RelatedResourceMetaBuilder builder = new RelatedResourceMetaBuilder(item);_visitables.get("relatedResources").add(builder);this.relatedResources.add(builder);} return (A)this;
  }
  public A addAllToRelatedResources(Collection<RelatedResourceMeta> items) {
    if (this.relatedResources == null) {this.relatedResources = new ArrayList<RelatedResourceMetaBuilder>();}
    for (RelatedResourceMeta item : items) {RelatedResourceMetaBuilder builder = new RelatedResourceMetaBuilder(item);_visitables.get("relatedResources").add(builder);this.relatedResources.add(builder);} return (A)this;
  }
  public A removeFromRelatedResources(io.fabric8.openclustermanagement.api.model.operator.v1.RelatedResourceMeta... items) {
    for (RelatedResourceMeta item : items) {RelatedResourceMetaBuilder builder = new RelatedResourceMetaBuilder(item);_visitables.get("relatedResources").remove(builder);if (this.relatedResources != null) {this.relatedResources.remove(builder);}} return (A)this;
  }
  public A removeAllFromRelatedResources(Collection<RelatedResourceMeta> items) {
    for (RelatedResourceMeta item : items) {RelatedResourceMetaBuilder builder = new RelatedResourceMetaBuilder(item);_visitables.get("relatedResources").remove(builder);if (this.relatedResources != null) {this.relatedResources.remove(builder);}} return (A)this;
  }
  public A removeMatchingFromRelatedResources(Predicate<RelatedResourceMetaBuilder> predicate) {
    if (relatedResources == null) return (A) this;
    final Iterator<RelatedResourceMetaBuilder> each = relatedResources.iterator();
    final List visitables = _visitables.get("relatedResources");
    while (each.hasNext()) {
      RelatedResourceMetaBuilder builder = each.next();
      if (predicate.test(builder)) {
        visitables.remove(builder);
        each.remove();
      }
    }
    return (A)this;
  }
  
  /**
   * This method has been deprecated, please use method buildRelatedResources instead.
   * @return The buildable object.
   */
  @Deprecated
  public List<RelatedResourceMeta> getRelatedResources() {
    return relatedResources != null ? build(relatedResources) : null;
  }
  public List<RelatedResourceMeta> buildRelatedResources() {
    return relatedResources != null ? build(relatedResources) : null;
  }
  public RelatedResourceMeta buildRelatedResource(Integer index) {
    return this.relatedResources.get(index).build();
  }
  public RelatedResourceMeta buildFirstRelatedResource() {
    return this.relatedResources.get(0).build();
  }
  public RelatedResourceMeta buildLastRelatedResource() {
    return this.relatedResources.get(relatedResources.size() - 1).build();
  }
  public RelatedResourceMeta buildMatchingRelatedResource(Predicate<RelatedResourceMetaBuilder> predicate) {
    for (RelatedResourceMetaBuilder item: relatedResources) { if(predicate.test(item)){ return item.build();} } return null;
  }
  public Boolean hasMatchingRelatedResource(Predicate<RelatedResourceMetaBuilder> predicate) {
    for (RelatedResourceMetaBuilder item: relatedResources) { if(predicate.test(item)){ return true;} } return false;
  }
  public A withRelatedResources(List<RelatedResourceMeta> relatedResources) {
    if (this.relatedResources != null) { _visitables.get("relatedResources").removeAll(this.relatedResources);}
    if (relatedResources != null) {this.relatedResources = new ArrayList(); for (RelatedResourceMeta item : relatedResources){this.addToRelatedResources(item);}} else { this.relatedResources = null;} return (A) this;
  }
  public A withRelatedResources(io.fabric8.openclustermanagement.api.model.operator.v1.RelatedResourceMeta... relatedResources) {
    if (this.relatedResources != null) {this.relatedResources.clear();}
    if (relatedResources != null) {for (RelatedResourceMeta item :relatedResources){ this.addToRelatedResources(item);}} return (A) this;
  }
  public Boolean hasRelatedResources() {
    return relatedResources != null && !relatedResources.isEmpty();
  }
  public A addNewRelatedResource(String group,String name,String namespace,String resource,String version) {
    return (A)addToRelatedResources(new RelatedResourceMeta(group, name, namespace, resource, version));
  }
  public ClusterManagerStatusFluent.RelatedResourcesNested<A> addNewRelatedResource() {
    return new ClusterManagerStatusFluentImpl.RelatedResourcesNestedImpl();
  }
  public ClusterManagerStatusFluent.RelatedResourcesNested<A> addNewRelatedResourceLike(RelatedResourceMeta item) {
    return new ClusterManagerStatusFluentImpl.RelatedResourcesNestedImpl(-1, item);
  }
  public ClusterManagerStatusFluent.RelatedResourcesNested<A> setNewRelatedResourceLike(Integer index,RelatedResourceMeta item) {
    return new ClusterManagerStatusFluentImpl.RelatedResourcesNestedImpl(index, item);
  }
  public ClusterManagerStatusFluent.RelatedResourcesNested<A> editRelatedResource(Integer index) {
    if (relatedResources.size() <= index) throw new RuntimeException("Can't edit relatedResources. Index exceeds size.");
    return setNewRelatedResourceLike(index, buildRelatedResource(index));
  }
  public ClusterManagerStatusFluent.RelatedResourcesNested<A> editFirstRelatedResource() {
    if (relatedResources.size() == 0) throw new RuntimeException("Can't edit first relatedResources. The list is empty.");
    return setNewRelatedResourceLike(0, buildRelatedResource(0));
  }
  public ClusterManagerStatusFluent.RelatedResourcesNested<A> editLastRelatedResource() {
    int index = relatedResources.size() - 1;
    if (index < 0) throw new RuntimeException("Can't edit last relatedResources. The list is empty.");
    return setNewRelatedResourceLike(index, buildRelatedResource(index));
  }
  public ClusterManagerStatusFluent.RelatedResourcesNested<A> editMatchingRelatedResource(Predicate<RelatedResourceMetaBuilder> predicate) {
    int index = -1;
    for (int i=0;i<relatedResources.size();i++) { 
    if (predicate.test(relatedResources.get(i))) {index = i; break;}
    } 
    if (index < 0) throw new RuntimeException("Can't edit matching relatedResources. No match found.");
    return setNewRelatedResourceLike(index, buildRelatedResource(index));
  }
  public boolean equals(Object o) {
    if (this == o) return true;
    if (o == null || getClass() != o.getClass()) return false;
    ClusterManagerStatusFluentImpl that = (ClusterManagerStatusFluentImpl) o;
    if (conditions != null ? !conditions.equals(that.conditions) :that.conditions != null) return false;
    if (generations != null ? !generations.equals(that.generations) :that.generations != null) return false;
    if (observedGeneration != null ? !observedGeneration.equals(that.observedGeneration) :that.observedGeneration != null) return false;
    if (relatedResources != null ? !relatedResources.equals(that.relatedResources) :that.relatedResources != null) return false;
    return true;
  }
  public int hashCode() {
    return java.util.Objects.hash(conditions,  generations,  observedGeneration,  relatedResources,  super.hashCode());
  }
  public String toString() {
    StringBuilder sb = new StringBuilder();
    sb.append("{");
    if (conditions != null && !conditions.isEmpty()) { sb.append("conditions:"); sb.append(conditions + ","); }
    if (generations != null && !generations.isEmpty()) { sb.append("generations:"); sb.append(generations + ","); }
    if (observedGeneration != null) { sb.append("observedGeneration:"); sb.append(observedGeneration + ","); }
    if (relatedResources != null && !relatedResources.isEmpty()) { sb.append("relatedResources:"); sb.append(relatedResources); }
    sb.append("}");
    return sb.toString();
  }
  class GenerationsNestedImpl<N> extends GenerationStatusFluentImpl<ClusterManagerStatusFluent.GenerationsNested<N>> implements ClusterManagerStatusFluent.GenerationsNested<N>,Nested<N>{
    GenerationsNestedImpl(Integer index,GenerationStatus item) {
      this.index = index;
      this.builder = new GenerationStatusBuilder(this, item);
    }
    GenerationsNestedImpl() {
      this.index = -1;
      this.builder = new GenerationStatusBuilder(this);
    }
    GenerationStatusBuilder builder;
    Integer index;
    public N and() {
      return (N) ClusterManagerStatusFluentImpl.this.setToGenerations(index,builder.build());
    }
    public N endGeneration() {
      return and();
    }
    
  }
  class RelatedResourcesNestedImpl<N> extends RelatedResourceMetaFluentImpl<ClusterManagerStatusFluent.RelatedResourcesNested<N>> implements ClusterManagerStatusFluent.RelatedResourcesNested<N>,Nested<N>{
    RelatedResourcesNestedImpl(Integer index,RelatedResourceMeta item) {
      this.index = index;
      this.builder = new RelatedResourceMetaBuilder(this, item);
    }
    RelatedResourcesNestedImpl() {
      this.index = -1;
      this.builder = new RelatedResourceMetaBuilder(this);
    }
    RelatedResourceMetaBuilder builder;
    Integer index;
    public N and() {
      return (N) ClusterManagerStatusFluentImpl.this.setToRelatedResources(index,builder.build());
    }
    public N endRelatedResource() {
      return and();
    }
    
  }
  
}