/*
 * Decompiled with CFR 0.152.
 */
package io.fabric8.openclustermanagement.api.model.multiclusterhub.operator.v1;

import io.fabric8.kubernetes.api.builder.VisitableBuilder;
import io.fabric8.openclustermanagement.api.model.multiclusterhub.operator.v1.BackupConfig;
import io.fabric8.openclustermanagement.api.model.multiclusterhub.operator.v1.BackupConfigFluent;
import io.fabric8.openclustermanagement.api.model.multiclusterhub.operator.v1.BackupConfigFluentImpl;

public class BackupConfigBuilder
extends BackupConfigFluentImpl<BackupConfigBuilder>
implements VisitableBuilder<BackupConfig, BackupConfigBuilder> {
    BackupConfigFluent<?> fluent;
    Boolean validationEnabled;

    public BackupConfigBuilder() {
        this(false);
    }

    public BackupConfigBuilder(Boolean validationEnabled) {
        this(new BackupConfig(), validationEnabled);
    }

    public BackupConfigBuilder(BackupConfigFluent<?> fluent) {
        this(fluent, (Boolean)false);
    }

    public BackupConfigBuilder(BackupConfigFluent<?> fluent, Boolean validationEnabled) {
        this(fluent, new BackupConfig(), validationEnabled);
    }

    public BackupConfigBuilder(BackupConfigFluent<?> fluent, BackupConfig instance) {
        this(fluent, instance, false);
    }

    public BackupConfigBuilder(BackupConfigFluent<?> fluent, BackupConfig instance, Boolean validationEnabled) {
        this.fluent = fluent;
        fluent.withMinBackupPeriodSeconds(instance.getMinBackupPeriodSeconds());
        fluent.withVelero(instance.getVelero());
        this.validationEnabled = validationEnabled;
    }

    public BackupConfigBuilder(BackupConfig instance) {
        this(instance, (Boolean)false);
    }

    public BackupConfigBuilder(BackupConfig instance, Boolean validationEnabled) {
        this.fluent = this;
        this.withMinBackupPeriodSeconds(instance.getMinBackupPeriodSeconds());
        this.withVelero(instance.getVelero());
        this.validationEnabled = validationEnabled;
    }

    public BackupConfig build() {
        BackupConfig buildable = new BackupConfig(this.fluent.getMinBackupPeriodSeconds(), this.fluent.getVelero());
        return buildable;
    }
}

