/*
 * Decompiled with CFR 0.152.
 */
package io.fabric8.openclustermanagement.api.model.operator.v1;

import io.fabric8.kubernetes.api.builder.BaseFluent;
import io.fabric8.kubernetes.api.builder.Nested;
import io.fabric8.openclustermanagement.api.model.operator.v1.KlusterletSpec;
import io.fabric8.openclustermanagement.api.model.operator.v1.KlusterletSpecFluent;
import io.fabric8.openclustermanagement.api.model.operator.v1.NodePlacement;
import io.fabric8.openclustermanagement.api.model.operator.v1.NodePlacementBuilder;
import io.fabric8.openclustermanagement.api.model.operator.v1.NodePlacementFluentImpl;
import io.fabric8.openclustermanagement.api.model.operator.v1.ServerURL;
import io.fabric8.openclustermanagement.api.model.operator.v1.ServerURLBuilder;
import io.fabric8.openclustermanagement.api.model.operator.v1.ServerURLFluentImpl;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Iterator;
import java.util.List;
import java.util.Objects;
import java.util.function.Predicate;

public class KlusterletSpecFluentImpl<A extends KlusterletSpecFluent<A>>
extends BaseFluent<A>
implements KlusterletSpecFluent<A> {
    private String clusterName;
    private ArrayList<ServerURLBuilder> externalServerURLs = new ArrayList();
    private String namespace;
    private NodePlacementBuilder nodePlacement;
    private String registrationImagePullSpec;
    private String workImagePullSpec;

    public KlusterletSpecFluentImpl() {
    }

    public KlusterletSpecFluentImpl(KlusterletSpec instance) {
        this.withClusterName(instance.getClusterName());
        this.withExternalServerURLs(instance.getExternalServerURLs());
        this.withNamespace(instance.getNamespace());
        this.withNodePlacement(instance.getNodePlacement());
        this.withRegistrationImagePullSpec(instance.getRegistrationImagePullSpec());
        this.withWorkImagePullSpec(instance.getWorkImagePullSpec());
    }

    @Override
    public String getClusterName() {
        return this.clusterName;
    }

    @Override
    public A withClusterName(String clusterName) {
        this.clusterName = clusterName;
        return (A)this;
    }

    @Override
    public Boolean hasClusterName() {
        return this.clusterName != null;
    }

    @Override
    public A addToExternalServerURLs(Integer index, ServerURL item) {
        if (this.externalServerURLs == null) {
            this.externalServerURLs = new ArrayList();
        }
        ServerURLBuilder builder = new ServerURLBuilder(item);
        this._visitables.get((Object)"externalServerURLs").add(index >= 0 ? index.intValue() : this._visitables.get((Object)"externalServerURLs").size(), builder);
        this.externalServerURLs.add(index >= 0 ? index.intValue() : this.externalServerURLs.size(), builder);
        return (A)this;
    }

    @Override
    public A setToExternalServerURLs(Integer index, ServerURL item) {
        if (this.externalServerURLs == null) {
            this.externalServerURLs = new ArrayList();
        }
        ServerURLBuilder builder = new ServerURLBuilder(item);
        if (index < 0 || index >= this._visitables.get((Object)"externalServerURLs").size()) {
            this._visitables.get((Object)"externalServerURLs").add(builder);
        } else {
            this._visitables.get((Object)"externalServerURLs").set(index, builder);
        }
        if (index < 0 || index >= this.externalServerURLs.size()) {
            this.externalServerURLs.add(builder);
        } else {
            this.externalServerURLs.set(index, builder);
        }
        return (A)this;
    }

    @Override
    public A addToExternalServerURLs(ServerURL ... items) {
        if (this.externalServerURLs == null) {
            this.externalServerURLs = new ArrayList();
        }
        for (ServerURL item : items) {
            ServerURLBuilder builder = new ServerURLBuilder(item);
            this._visitables.get((Object)"externalServerURLs").add(builder);
            this.externalServerURLs.add(builder);
        }
        return (A)this;
    }

    @Override
    public A addAllToExternalServerURLs(Collection<ServerURL> items) {
        if (this.externalServerURLs == null) {
            this.externalServerURLs = new ArrayList();
        }
        for (ServerURL item : items) {
            ServerURLBuilder builder = new ServerURLBuilder(item);
            this._visitables.get((Object)"externalServerURLs").add(builder);
            this.externalServerURLs.add(builder);
        }
        return (A)this;
    }

    @Override
    public A removeFromExternalServerURLs(ServerURL ... items) {
        for (ServerURL item : items) {
            ServerURLBuilder builder = new ServerURLBuilder(item);
            this._visitables.get((Object)"externalServerURLs").remove(builder);
            if (this.externalServerURLs == null) continue;
            this.externalServerURLs.remove(builder);
        }
        return (A)this;
    }

    @Override
    public A removeAllFromExternalServerURLs(Collection<ServerURL> items) {
        for (ServerURL item : items) {
            ServerURLBuilder builder = new ServerURLBuilder(item);
            this._visitables.get((Object)"externalServerURLs").remove(builder);
            if (this.externalServerURLs == null) continue;
            this.externalServerURLs.remove(builder);
        }
        return (A)this;
    }

    @Override
    public A removeMatchingFromExternalServerURLs(Predicate<ServerURLBuilder> predicate) {
        if (this.externalServerURLs == null) {
            return (A)this;
        }
        Iterator<ServerURLBuilder> each = this.externalServerURLs.iterator();
        List visitables = this._visitables.get((Object)"externalServerURLs");
        while (each.hasNext()) {
            ServerURLBuilder builder = each.next();
            if (!predicate.test(builder)) continue;
            visitables.remove(builder);
            each.remove();
        }
        return (A)this;
    }

    @Override
    @Deprecated
    public List<ServerURL> getExternalServerURLs() {
        return this.externalServerURLs != null ? KlusterletSpecFluentImpl.build(this.externalServerURLs) : null;
    }

    @Override
    public List<ServerURL> buildExternalServerURLs() {
        return this.externalServerURLs != null ? KlusterletSpecFluentImpl.build(this.externalServerURLs) : null;
    }

    @Override
    public ServerURL buildExternalServerURL(Integer index) {
        return this.externalServerURLs.get(index).build();
    }

    @Override
    public ServerURL buildFirstExternalServerURL() {
        return this.externalServerURLs.get(0).build();
    }

    @Override
    public ServerURL buildLastExternalServerURL() {
        return this.externalServerURLs.get(this.externalServerURLs.size() - 1).build();
    }

    @Override
    public ServerURL buildMatchingExternalServerURL(Predicate<ServerURLBuilder> predicate) {
        for (ServerURLBuilder item : this.externalServerURLs) {
            if (!predicate.test(item)) continue;
            return item.build();
        }
        return null;
    }

    @Override
    public Boolean hasMatchingExternalServerURL(Predicate<ServerURLBuilder> predicate) {
        for (ServerURLBuilder item : this.externalServerURLs) {
            if (!predicate.test(item)) continue;
            return true;
        }
        return false;
    }

    @Override
    public A withExternalServerURLs(List<ServerURL> externalServerURLs) {
        if (this.externalServerURLs != null) {
            this._visitables.get((Object)"externalServerURLs").removeAll(this.externalServerURLs);
        }
        if (externalServerURLs != null) {
            this.externalServerURLs = new ArrayList();
            for (ServerURL item : externalServerURLs) {
                this.addToExternalServerURLs(item);
            }
        } else {
            this.externalServerURLs = null;
        }
        return (A)this;
    }

    @Override
    public A withExternalServerURLs(ServerURL ... externalServerURLs) {
        if (this.externalServerURLs != null) {
            this.externalServerURLs.clear();
        }
        if (externalServerURLs != null) {
            for (ServerURL item : externalServerURLs) {
                this.addToExternalServerURLs(item);
            }
        }
        return (A)this;
    }

    @Override
    public Boolean hasExternalServerURLs() {
        return this.externalServerURLs != null && !this.externalServerURLs.isEmpty();
    }

    @Override
    public A addNewExternalServerURL(String caBundle, String url) {
        return this.addToExternalServerURLs(new ServerURL(caBundle, url));
    }

    @Override
    public KlusterletSpecFluent.ExternalServerURLsNested<A> addNewExternalServerURL() {
        return new ExternalServerURLsNestedImpl();
    }

    @Override
    public KlusterletSpecFluent.ExternalServerURLsNested<A> addNewExternalServerURLLike(ServerURL item) {
        return new ExternalServerURLsNestedImpl(-1, item);
    }

    @Override
    public KlusterletSpecFluent.ExternalServerURLsNested<A> setNewExternalServerURLLike(Integer index, ServerURL item) {
        return new ExternalServerURLsNestedImpl(index, item);
    }

    @Override
    public KlusterletSpecFluent.ExternalServerURLsNested<A> editExternalServerURL(Integer index) {
        if (this.externalServerURLs.size() <= index) {
            throw new RuntimeException("Can't edit externalServerURLs. Index exceeds size.");
        }
        return this.setNewExternalServerURLLike(index, this.buildExternalServerURL(index));
    }

    @Override
    public KlusterletSpecFluent.ExternalServerURLsNested<A> editFirstExternalServerURL() {
        if (this.externalServerURLs.size() == 0) {
            throw new RuntimeException("Can't edit first externalServerURLs. The list is empty.");
        }
        return this.setNewExternalServerURLLike(0, this.buildExternalServerURL(0));
    }

    @Override
    public KlusterletSpecFluent.ExternalServerURLsNested<A> editLastExternalServerURL() {
        int index = this.externalServerURLs.size() - 1;
        if (index < 0) {
            throw new RuntimeException("Can't edit last externalServerURLs. The list is empty.");
        }
        return this.setNewExternalServerURLLike(index, this.buildExternalServerURL(index));
    }

    @Override
    public KlusterletSpecFluent.ExternalServerURLsNested<A> editMatchingExternalServerURL(Predicate<ServerURLBuilder> predicate) {
        int index = -1;
        for (int i = 0; i < this.externalServerURLs.size(); ++i) {
            if (!predicate.test(this.externalServerURLs.get(i))) continue;
            index = i;
            break;
        }
        if (index < 0) {
            throw new RuntimeException("Can't edit matching externalServerURLs. No match found.");
        }
        return this.setNewExternalServerURLLike(index, this.buildExternalServerURL(index));
    }

    @Override
    public String getNamespace() {
        return this.namespace;
    }

    @Override
    public A withNamespace(String namespace) {
        this.namespace = namespace;
        return (A)this;
    }

    @Override
    public Boolean hasNamespace() {
        return this.namespace != null;
    }

    @Override
    @Deprecated
    public NodePlacement getNodePlacement() {
        return this.nodePlacement != null ? this.nodePlacement.build() : null;
    }

    @Override
    public NodePlacement buildNodePlacement() {
        return this.nodePlacement != null ? this.nodePlacement.build() : null;
    }

    @Override
    public A withNodePlacement(NodePlacement nodePlacement) {
        this._visitables.get((Object)"nodePlacement").remove(this.nodePlacement);
        if (nodePlacement != null) {
            this.nodePlacement = new NodePlacementBuilder(nodePlacement);
            this._visitables.get((Object)"nodePlacement").add(this.nodePlacement);
        }
        return (A)this;
    }

    @Override
    public Boolean hasNodePlacement() {
        return this.nodePlacement != null;
    }

    @Override
    public KlusterletSpecFluent.NodePlacementNested<A> withNewNodePlacement() {
        return new NodePlacementNestedImpl();
    }

    @Override
    public KlusterletSpecFluent.NodePlacementNested<A> withNewNodePlacementLike(NodePlacement item) {
        return new NodePlacementNestedImpl(item);
    }

    @Override
    public KlusterletSpecFluent.NodePlacementNested<A> editNodePlacement() {
        return this.withNewNodePlacementLike(this.getNodePlacement());
    }

    @Override
    public KlusterletSpecFluent.NodePlacementNested<A> editOrNewNodePlacement() {
        return this.withNewNodePlacementLike(this.getNodePlacement() != null ? this.getNodePlacement() : new NodePlacementBuilder().build());
    }

    @Override
    public KlusterletSpecFluent.NodePlacementNested<A> editOrNewNodePlacementLike(NodePlacement item) {
        return this.withNewNodePlacementLike(this.getNodePlacement() != null ? this.getNodePlacement() : item);
    }

    @Override
    public String getRegistrationImagePullSpec() {
        return this.registrationImagePullSpec;
    }

    @Override
    public A withRegistrationImagePullSpec(String registrationImagePullSpec) {
        this.registrationImagePullSpec = registrationImagePullSpec;
        return (A)this;
    }

    @Override
    public Boolean hasRegistrationImagePullSpec() {
        return this.registrationImagePullSpec != null;
    }

    @Override
    public String getWorkImagePullSpec() {
        return this.workImagePullSpec;
    }

    @Override
    public A withWorkImagePullSpec(String workImagePullSpec) {
        this.workImagePullSpec = workImagePullSpec;
        return (A)this;
    }

    @Override
    public Boolean hasWorkImagePullSpec() {
        return this.workImagePullSpec != null;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        KlusterletSpecFluentImpl that = (KlusterletSpecFluentImpl)o;
        if (this.clusterName != null ? !this.clusterName.equals(that.clusterName) : that.clusterName != null) {
            return false;
        }
        if (this.externalServerURLs != null ? !this.externalServerURLs.equals(that.externalServerURLs) : that.externalServerURLs != null) {
            return false;
        }
        if (this.namespace != null ? !this.namespace.equals(that.namespace) : that.namespace != null) {
            return false;
        }
        if (this.nodePlacement != null ? !this.nodePlacement.equals(that.nodePlacement) : that.nodePlacement != null) {
            return false;
        }
        if (this.registrationImagePullSpec != null ? !this.registrationImagePullSpec.equals(that.registrationImagePullSpec) : that.registrationImagePullSpec != null) {
            return false;
        }
        return !(this.workImagePullSpec != null ? !this.workImagePullSpec.equals(that.workImagePullSpec) : that.workImagePullSpec != null);
    }

    public int hashCode() {
        return Objects.hash(this.clusterName, this.externalServerURLs, this.namespace, this.nodePlacement, this.registrationImagePullSpec, this.workImagePullSpec, super.hashCode());
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("{");
        if (this.clusterName != null) {
            sb.append("clusterName:");
            sb.append(this.clusterName + ",");
        }
        if (this.externalServerURLs != null && !this.externalServerURLs.isEmpty()) {
            sb.append("externalServerURLs:");
            sb.append(this.externalServerURLs + ",");
        }
        if (this.namespace != null) {
            sb.append("namespace:");
            sb.append(this.namespace + ",");
        }
        if (this.nodePlacement != null) {
            sb.append("nodePlacement:");
            sb.append(this.nodePlacement + ",");
        }
        if (this.registrationImagePullSpec != null) {
            sb.append("registrationImagePullSpec:");
            sb.append(this.registrationImagePullSpec + ",");
        }
        if (this.workImagePullSpec != null) {
            sb.append("workImagePullSpec:");
            sb.append(this.workImagePullSpec);
        }
        sb.append("}");
        return sb.toString();
    }

    class NodePlacementNestedImpl<N>
    extends NodePlacementFluentImpl<KlusterletSpecFluent.NodePlacementNested<N>>
    implements KlusterletSpecFluent.NodePlacementNested<N>,
    Nested<N> {
        NodePlacementBuilder builder;

        NodePlacementNestedImpl(NodePlacement item) {
            this.builder = new NodePlacementBuilder(this, item);
        }

        NodePlacementNestedImpl() {
            this.builder = new NodePlacementBuilder(this);
        }

        @Override
        public N and() {
            return (N)KlusterletSpecFluentImpl.this.withNodePlacement(this.builder.build());
        }

        @Override
        public N endNodePlacement() {
            return this.and();
        }
    }

    class ExternalServerURLsNestedImpl<N>
    extends ServerURLFluentImpl<KlusterletSpecFluent.ExternalServerURLsNested<N>>
    implements KlusterletSpecFluent.ExternalServerURLsNested<N>,
    Nested<N> {
        ServerURLBuilder builder;
        Integer index;

        ExternalServerURLsNestedImpl(Integer index, ServerURL item) {
            this.index = index;
            this.builder = new ServerURLBuilder(this, item);
        }

        ExternalServerURLsNestedImpl() {
            this.index = -1;
            this.builder = new ServerURLBuilder(this);
        }

        @Override
        public N and() {
            return (N)KlusterletSpecFluentImpl.this.setToExternalServerURLs(this.index, this.builder.build());
        }

        @Override
        public N endExternalServerURL() {
            return this.and();
        }
    }
}

