package io.fabric8.openclustermanagement.api.model.operator.v1;

import io.fabric8.kubernetes.api.builder.VisitableBuilder;
import java.lang.Boolean;
public class NodePlacementBuilder extends NodePlacementFluentImpl<NodePlacementBuilder> implements VisitableBuilder<io.fabric8.openclustermanagement.api.model.operator.v1.NodePlacement,io.fabric8.openclustermanagement.api.model.operator.v1.NodePlacementBuilder>{
  public NodePlacementBuilder() {
    this(false);
  }
  public NodePlacementBuilder(Boolean validationEnabled) {
    this(new NodePlacement(), validationEnabled);
  }
  public NodePlacementBuilder(NodePlacementFluent<?> fluent) {
    this(fluent, false);
  }
  public NodePlacementBuilder(io.fabric8.openclustermanagement.api.model.operator.v1.NodePlacementFluent<?> fluent,java.lang.Boolean validationEnabled) {
    this(fluent, new NodePlacement(), validationEnabled);
  }
  public NodePlacementBuilder(io.fabric8.openclustermanagement.api.model.operator.v1.NodePlacementFluent<?> fluent,io.fabric8.openclustermanagement.api.model.operator.v1.NodePlacement instance) {
    this(fluent, instance, false);
  }
  public NodePlacementBuilder(io.fabric8.openclustermanagement.api.model.operator.v1.NodePlacementFluent<?> fluent,io.fabric8.openclustermanagement.api.model.operator.v1.NodePlacement instance,java.lang.Boolean validationEnabled) {
    this.fluent = fluent; 
    fluent.withNodeSelector(instance.getNodeSelector()); 
    fluent.withTolerations(instance.getTolerations()); 
    this.validationEnabled = validationEnabled; 
  }
  public NodePlacementBuilder(io.fabric8.openclustermanagement.api.model.operator.v1.NodePlacement instance) {
    this(instance,false);
  }
  public NodePlacementBuilder(io.fabric8.openclustermanagement.api.model.operator.v1.NodePlacement instance,java.lang.Boolean validationEnabled) {
    this.fluent = this; 
    this.withNodeSelector(instance.getNodeSelector()); 
    this.withTolerations(instance.getTolerations()); 
    this.validationEnabled = validationEnabled; 
  }
  io.fabric8.openclustermanagement.api.model.operator.v1.NodePlacementFluent<?> fluent;
  java.lang.Boolean validationEnabled;
  public io.fabric8.openclustermanagement.api.model.operator.v1.NodePlacement build() {
    NodePlacement buildable = new NodePlacement(fluent.getNodeSelector(),fluent.getTolerations());
    return buildable;
  }
  
}