package io.fabric8.openclustermanagement.api.model.operator.v1;

import io.fabric8.kubernetes.api.builder.VisitableBuilder;
import java.lang.Boolean;
public class KlusterletBuilder extends KlusterletFluentImpl<KlusterletBuilder> implements VisitableBuilder<Klusterlet,io.fabric8.openclustermanagement.api.model.operator.v1.KlusterletBuilder>{
  public KlusterletBuilder() {
    this(false);
  }
  public KlusterletBuilder(Boolean validationEnabled) {
    this(new Klusterlet(), validationEnabled);
  }
  public KlusterletBuilder(io.fabric8.openclustermanagement.api.model.operator.v1.KlusterletFluent<?> fluent) {
    this(fluent, false);
  }
  public KlusterletBuilder(io.fabric8.openclustermanagement.api.model.operator.v1.KlusterletFluent<?> fluent,java.lang.Boolean validationEnabled) {
    this(fluent, new Klusterlet(), validationEnabled);
  }
  public KlusterletBuilder(io.fabric8.openclustermanagement.api.model.operator.v1.KlusterletFluent<?> fluent,io.fabric8.openclustermanagement.api.model.operator.v1.Klusterlet instance) {
    this(fluent, instance, false);
  }
  public KlusterletBuilder(io.fabric8.openclustermanagement.api.model.operator.v1.KlusterletFluent<?> fluent,io.fabric8.openclustermanagement.api.model.operator.v1.Klusterlet instance,java.lang.Boolean validationEnabled) {
    this.fluent = fluent; 
    fluent.withApiVersion(instance.getApiVersion()); 
    fluent.withKind(instance.getKind()); 
    fluent.withMetadata(instance.getMetadata()); 
    fluent.withSpec(instance.getSpec()); 
    fluent.withStatus(instance.getStatus()); 
    this.validationEnabled = validationEnabled; 
  }
  public KlusterletBuilder(io.fabric8.openclustermanagement.api.model.operator.v1.Klusterlet instance) {
    this(instance,false);
  }
  public KlusterletBuilder(io.fabric8.openclustermanagement.api.model.operator.v1.Klusterlet instance,java.lang.Boolean validationEnabled) {
    this.fluent = this; 
    this.withApiVersion(instance.getApiVersion()); 
    this.withKind(instance.getKind()); 
    this.withMetadata(instance.getMetadata()); 
    this.withSpec(instance.getSpec()); 
    this.withStatus(instance.getStatus()); 
    this.validationEnabled = validationEnabled; 
  }
  io.fabric8.openclustermanagement.api.model.operator.v1.KlusterletFluent<?> fluent;
  java.lang.Boolean validationEnabled;
  public io.fabric8.openclustermanagement.api.model.operator.v1.Klusterlet build() {
    Klusterlet buildable = new Klusterlet(fluent.getApiVersion(),fluent.getKind(),fluent.getMetadata(),fluent.getSpec(),fluent.getStatus());
    return buildable;
  }
  
}