package io.fabric8.openclustermanagement.api.model.operator.v1;

import io.fabric8.kubernetes.api.builder.VisitableBuilder;
import java.lang.Boolean;
public class ClusterManagerSpecBuilder extends ClusterManagerSpecFluentImpl<ClusterManagerSpecBuilder> implements VisitableBuilder<io.fabric8.openclustermanagement.api.model.operator.v1.ClusterManagerSpec,ClusterManagerSpecBuilder>{
  public ClusterManagerSpecBuilder() {
    this(false);
  }
  public ClusterManagerSpecBuilder(Boolean validationEnabled) {
    this(new ClusterManagerSpec(), validationEnabled);
  }
  public ClusterManagerSpecBuilder(ClusterManagerSpecFluent<?> fluent) {
    this(fluent, false);
  }
  public ClusterManagerSpecBuilder(io.fabric8.openclustermanagement.api.model.operator.v1.ClusterManagerSpecFluent<?> fluent,java.lang.Boolean validationEnabled) {
    this(fluent, new ClusterManagerSpec(), validationEnabled);
  }
  public ClusterManagerSpecBuilder(io.fabric8.openclustermanagement.api.model.operator.v1.ClusterManagerSpecFluent<?> fluent,io.fabric8.openclustermanagement.api.model.operator.v1.ClusterManagerSpec instance) {
    this(fluent, instance, false);
  }
  public ClusterManagerSpecBuilder(io.fabric8.openclustermanagement.api.model.operator.v1.ClusterManagerSpecFluent<?> fluent,io.fabric8.openclustermanagement.api.model.operator.v1.ClusterManagerSpec instance,java.lang.Boolean validationEnabled) {
    this.fluent = fluent; 
    fluent.withNodePlacement(instance.getNodePlacement()); 
    fluent.withPlacementImagePullSpec(instance.getPlacementImagePullSpec()); 
    fluent.withRegistrationImagePullSpec(instance.getRegistrationImagePullSpec()); 
    fluent.withWorkImagePullSpec(instance.getWorkImagePullSpec()); 
    this.validationEnabled = validationEnabled; 
  }
  public ClusterManagerSpecBuilder(io.fabric8.openclustermanagement.api.model.operator.v1.ClusterManagerSpec instance) {
    this(instance,false);
  }
  public ClusterManagerSpecBuilder(io.fabric8.openclustermanagement.api.model.operator.v1.ClusterManagerSpec instance,java.lang.Boolean validationEnabled) {
    this.fluent = this; 
    this.withNodePlacement(instance.getNodePlacement()); 
    this.withPlacementImagePullSpec(instance.getPlacementImagePullSpec()); 
    this.withRegistrationImagePullSpec(instance.getRegistrationImagePullSpec()); 
    this.withWorkImagePullSpec(instance.getWorkImagePullSpec()); 
    this.validationEnabled = validationEnabled; 
  }
  io.fabric8.openclustermanagement.api.model.operator.v1.ClusterManagerSpecFluent<?> fluent;
  java.lang.Boolean validationEnabled;
  public io.fabric8.openclustermanagement.api.model.operator.v1.ClusterManagerSpec build() {
    ClusterManagerSpec buildable = new ClusterManagerSpec(fluent.getNodePlacement(),fluent.getPlacementImagePullSpec(),fluent.getRegistrationImagePullSpec(),fluent.getWorkImagePullSpec());
    return buildable;
  }
  
}